/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.spreadsheet.oda.driver.ui.impl.dataset;

import bpm.google.spreadsheet.oda.driver.runtime.impl.Connection;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleParameter;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheet;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheetColumn;
import bpm.google.spreadsheet.oda.driver.ui.Activator;
import bpm.google.spreadsheet.oda.driver.ui.Messages;
import bpm.google.spreadsheet.oda.driver.ui.impl.dataset.GoogleOdaFilterPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.pgroup.PGroup;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class GoogleOdaDataSetPage
extends DataSetWizardPage {
    private IConnection conn;
    private ArrayList<OdaGoogleSheet> listDataSetSheets;
    private PGroup groupeCols;
    private PGroup groupSheets;
    private Combo comboSheets;
    private Button btnSkip;
    private Button btnAdd;
    private Button btnRemove;
    private Button btnAddAll;
    private Button btnRemoveAll;
    private Button btnAddParam;
    private Button btnDelParam;
    private String sheetNameSelected;
    private OdaGoogleSheet sheetSelected;
    private List listCol;
    private IStructuredSelection selection;
    private TableViewer viewerColSelected;
    private Table tableColSelected;
    private ArrayList<OdaGoogleSheetColumn> listInputColums;
    private ArrayList<OdaGoogleParameter> listInputParam;
    private TableViewer viewerParameters;
    private Table tableParameters;
    private IStructuredSelection selectionParam;

    public GoogleOdaDataSetPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.GoogleOdaDataSetPage_0);
    }

    public void createPageCustomControl(Composite parent) {
        Composite inCompo = new Composite(parent, 0);
        inCompo.setLayout((Layout)new GridLayout(1, false));
        this.setControl(this.createPageControl(inCompo));
    }

    private Control createPageControl(Composite parent) {
        this.setMessage(Messages.GoogleOdaDataSetPage_1);
        this.setPageComplete(false);
        final Properties connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.GoogleOdaDataSetPage_2, -1);
                    try {
                        GoogleOdaDataSetPage.this.conn = (IConnection)new Connection();
                        GoogleOdaDataSetPage.this.conn.open(connProps);
                        GoogleOdaDataSetPage.this.listDataSetSheets = new ArrayList();
                        GoogleOdaDataSetPage.this.listDataSetSheets.addAll(((Connection)GoogleOdaDataSetPage.this.conn).getListSheets());
                    }
                    catch (Exception e) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)GoogleOdaDataSetPage.this.getShell(), (String)Messages.GoogleOdaDataSetPage_3, (String)Messages.GoogleOdaDataSetPage_4);
                            }
                        });
                        e.printStackTrace();
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e2) {
            e2.printStackTrace();
        }
        catch (InterruptedException e3) {
            e3.printStackTrace();
        }
        this.listInputColums = new ArrayList();
        this.listInputParam = new ArrayList();
        parent.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        parent.setLayout((Layout)new GridLayout(2, false));
        this.groupSheets = new PGroup(parent, 65536);
        this.groupSheets.setText(Messages.GoogleOdaDataSetPage_5);
        this.groupSheets.setLayoutData((Object)new GridData(4, 4, true, false, 2, 2));
        this.groupSheets.setLayout((Layout)new GridLayout(3, false));
        this.groupSheets.setImage(Activator.getDefault().getImageRegistry().get("application_view_list.png"));
        Label lbl = new Label((Composite)this.groupSheets, 0);
        lbl.setText(Messages.GoogleOdaDataSetPage_6);
        lbl.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.comboSheets = new Combo((Composite)this.groupSheets, 12);
        this.comboSheets.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        for (OdaGoogleSheet currentSheet : this.listDataSetSheets) {
            this.comboSheets.add(currentSheet.getSheetName());
        }
        this.comboSheets.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GoogleOdaDataSetPage.this.sheetNameSelected = GoogleOdaDataSetPage.this.comboSheets.getText();
                GoogleOdaDataSetPage.this.setMessage(String.valueOf(Messages.GoogleOdaDataSetPage_7) + GoogleOdaDataSetPage.this.comboSheets.getText());
                GoogleOdaDataSetPage.this.btnSkip.setEnabled(true);
                for (OdaGoogleSheet sheet : GoogleOdaDataSetPage.this.listDataSetSheets) {
                    if (!sheet.getSheetName().equals(GoogleOdaDataSetPage.this.sheetNameSelected)) continue;
                    GoogleOdaDataSetPage.this.sheetSelected = sheet;
                }
                GoogleOdaDataSetPage.this.listInputColums.clear();
                GoogleOdaDataSetPage.this.viewerColSelected.refresh();
                GoogleOdaDataSetPage.this.refreshListCol(GoogleOdaDataSetPage.this.sheetSelected);
            }
        });
        this.btnSkip = new Button((Composite)this.groupSheets, 32);
        this.btnSkip.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.btnSkip.setText(Messages.GoogleOdaDataSetPage_8);
        this.btnSkip.setEnabled(false);
        lbl = new Label(parent, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.groupeCols = new PGroup(parent, 65536);
        this.groupeCols.setLayoutData((Object)new GridData(4, 4, true, false, 2, 2));
        this.groupeCols.setLayout((Layout)new GridLayout(2, false));
        this.groupeCols.setText(Messages.GoogleOdaDataSetPage_9);
        this.groupeCols.setImage(Activator.getDefault().getImageRegistry().get("column.png"));
        lbl = new Label((Composite)this.groupeCols, 0);
        lbl.setText(Messages.GoogleOdaDataSetPage_10);
        lbl.setLayoutData((Object)new GridData(4, 4, false, true, 2, 2));
        Composite groupListColumn = new Composite((Composite)this.groupeCols, 2048);
        groupListColumn.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        groupListColumn.setLayout((Layout)new GridLayout(2, false));
        this.listCol = new List(groupListColumn, 2058);
        this.listCol.setLayoutData((Object)new GridData(4, 4, true, true, 1, 5));
        this.btnAdd = new Button(groupListColumn, 8);
        this.btnAdd.setToolTipText(Messages.GoogleOdaDataSetPage_11);
        this.btnAdd.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnAdd.setImage(Activator.getDefault().getImageRegistry().get("add.png"));
        this.btnRemove = new Button(groupListColumn, 8);
        this.btnRemove.setToolTipText(Messages.GoogleOdaDataSetPage_12);
        this.btnRemove.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnRemove.setImage(Activator.getDefault().getImageRegistry().get("delete.png"));
        this.btnAddAll = new Button(groupListColumn, 8);
        this.btnAddAll.setToolTipText(Messages.GoogleOdaDataSetPage_13);
        this.btnAddAll.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnAddAll.setImage(Activator.getDefault().getImageRegistry().get("table_add.png"));
        this.btnRemoveAll = new Button(groupListColumn, 8);
        this.btnRemoveAll.setToolTipText(Messages.GoogleOdaDataSetPage_14);
        this.btnRemoveAll.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnRemoveAll.setImage(Activator.getDefault().getImageRegistry().get("table_delete.png"));
        this.initListenersBtnTool();
        Composite groupListSelected = new Composite((Composite)this.groupeCols, 0);
        groupListSelected.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        groupListSelected.setLayout((Layout)new GridLayout(1, false));
        this.viewerColSelected = new TableViewer(groupListSelected, 68354);
        this.tableColSelected = this.viewerColSelected.getTable();
        this.tableColSelected.setLayoutData((Object)new GridData(4, 4, false, true, 1, 5));
        this.viewerColSelected.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList currentElement = (ArrayList)inputElement;
                return currentElement.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewerColSelected.setInput(this.listInputColums);
        TableViewerColumn column = new TableViewerColumn(this.viewerColSelected, 0);
        column.getColumn().setText(Messages.GoogleOdaDataSetPage_15);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OdaGoogleSheetColumn current = (OdaGoogleSheetColumn)element;
                return current.getColName();
            }

            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("table_go.png");
            }
        });
        column = new TableViewerColumn(this.viewerColSelected, 0);
        column.getColumn().setText(Messages.GoogleOdaDataSetPage_16);
        column.setEditingSupport((EditingSupport)new MyEditingSupport((ColumnViewer)this.viewerColSelected));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OdaGoogleSheetColumn current = (OdaGoogleSheetColumn)element;
                if (current.getColLabelName() == null) {
                    current.setColLabelName(current.getColName());
                }
                return current.getColLabelName();
            }
        });
        int i = 0;
        int n = this.tableColSelected.getColumnCount();
        while (i < n) {
            this.tableColSelected.getColumn(i).setWidth(145);
            ++i;
        }
        this.tableColSelected.setHeaderVisible(true);
        this.tableColSelected.setLinesVisible(true);
        this.viewerColSelected.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GoogleOdaDataSetPage.this.selection = (IStructuredSelection)event.getSelection();
            }
        });
        lbl = new Label(parent, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        PGroup groupeParam = new PGroup(parent, 65536);
        groupeParam.setLayoutData((Object)new GridData(4, 4, true, true, 2, 5));
        groupeParam.setLayout((Layout)new GridLayout(2, false));
        groupeParam.setText(Messages.GoogleOdaDataSetPage_17);
        groupeParam.setImage(Activator.getDefault().getImageRegistry().get("object.png"));
        lbl = new Label((Composite)groupeParam, 0);
        lbl.setText(Messages.GoogleOdaDataSetPage_18);
        lbl.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.initViewerParam(groupeParam);
        Composite compoParam = new Composite((Composite)groupeParam, 0);
        compoParam.setLayoutData((Object)new GridData(512, 4, true, true, 1, 3));
        compoParam.setLayout((Layout)new GridLayout(1, false));
        this.btnAddParam = new Button(compoParam, 8);
        this.btnAddParam.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnAddParam.setText(Messages.GoogleOdaDataSetPage_19);
        this.btnAddParam.setEnabled(false);
        this.btnAddParam.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GoogleOdaDataSetPage.this.listInputParam.add(new OdaGoogleParameter());
                GoogleOdaDataSetPage.this.changeEnableButtonParam();
                GoogleOdaDataSetPage.this.viewerParameters.refresh();
            }
        });
        this.btnDelParam = new Button(compoParam, 8);
        this.btnDelParam.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnDelParam.setText(Messages.GoogleOdaDataSetPage_20);
        this.btnDelParam.setEnabled(false);
        this.btnDelParam.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (GoogleOdaDataSetPage.this.selectionParam == null) {
                    MessageDialog.openInformation((Shell)GoogleOdaDataSetPage.this.getShell(), (String)Messages.GoogleOdaDataSetPage_21, (String)Messages.GoogleOdaDataSetPage_22);
                } else {
                    Object[] objectArray = GoogleOdaDataSetPage.this.selectionParam.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        GoogleOdaDataSetPage.this.listInputParam.remove((OdaGoogleParameter)obj);
                        ++n2;
                    }
                    GoogleOdaDataSetPage.this.viewerParameters.refresh();
                    GoogleOdaDataSetPage.this.changeEnableButtonParam();
                }
            }
        });
        lbl = new Label(compoParam, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lbl = new Label(compoParam, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        DataSetDesign dataSetDesigned = this.getInitializationDesign();
        if (dataSetDesigned != null && dataSetDesigned.getQueryText() != null && !dataSetDesigned.getQueryText().trim().equals("")) {
            this.initWidgetWithDataset(dataSetDesigned);
        }
        return parent;
    }

    private void initViewerParam(PGroup groupeParam) {
        this.viewerParameters = new TableViewer((Composite)groupeParam, 68354);
        this.tableParameters = this.viewerParameters.getTable();
        this.tableParameters.setLayoutData((Object)new GridData(512, 4, true, true, 1, 3));
        this.viewerParameters.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList currentElement = (ArrayList)inputElement;
                return currentElement.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewerParameters.setInput(this.listInputParam);
        TableViewerColumn column = new TableViewerColumn(this.viewerParameters, 0);
        column.getColumn().setText(Messages.GoogleOdaDataSetPage_23);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OdaGoogleParameter current = (OdaGoogleParameter)element;
                return current.getParamColumn();
            }

            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("tick.png");
            }
        });
        column.setEditingSupport((EditingSupport)new ComboEditingSupport(this.viewerParameters, 1));
        column = new TableViewerColumn(this.viewerParameters, 0);
        column.getColumn().setText(Messages.GoogleOdaDataSetPage_24);
        column.setEditingSupport((EditingSupport)new ComboEditingSupport(this.viewerParameters, 2));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OdaGoogleParameter current = (OdaGoogleParameter)element;
                return current.getParamOperator();
            }
        });
        int i = 0;
        int n = this.tableParameters.getColumnCount();
        while (i < n) {
            this.tableParameters.getColumn(i).setWidth(150);
            ++i;
        }
        this.tableParameters.setHeaderVisible(true);
        this.tableParameters.setLinesVisible(true);
        this.viewerParameters.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GoogleOdaDataSetPage.this.selectionParam = (IStructuredSelection)event.getSelection();
            }
        });
    }

    private void initListenersBtnTool() {
        this.btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GoogleOdaDataSetPage.this.setPageComplete(true);
                String[] stringArray = GoogleOdaDataSetPage.this.listCol.getSelection();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String nameSelect = stringArray[n2];
                    for (OdaGoogleSheetColumn col : GoogleOdaDataSetPage.this.sheetSelected.getSheetListCol()) {
                        if (!nameSelect.equals(col.getColName())) continue;
                        GoogleOdaDataSetPage.this.listInputColums.add(col);
                        GoogleOdaDataSetPage.this.viewerColSelected.refresh();
                    }
                    ++n2;
                }
                GoogleOdaDataSetPage.this.listCol.remove(GoogleOdaDataSetPage.this.listCol.getSelectionIndices());
                GoogleOdaDataSetPage.this.changeEnableButtonParam();
                GoogleOdaDataSetPage.this.viewerColSelected.refresh();
            }
        });
        this.btnAddAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GoogleOdaDataSetPage.this.setPageComplete(true);
                GoogleOdaDataSetPage.this.listCol.removeAll();
                GoogleOdaDataSetPage.this.listInputColums.clear();
                GoogleOdaDataSetPage.this.listInputColums.addAll(GoogleOdaDataSetPage.this.sheetSelected.getSheetListCol());
                GoogleOdaDataSetPage.this.changeEnableButtonParam();
                GoogleOdaDataSetPage.this.viewerColSelected.refresh();
            }
        });
        this.btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ArrayList<OdaGoogleSheetColumn> listColToRemove = new ArrayList<OdaGoogleSheetColumn>();
                Object[] objectArray = GoogleOdaDataSetPage.this.selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    listColToRemove.add((OdaGoogleSheetColumn)obj);
                    ++n2;
                }
                GoogleOdaDataSetPage.this.listInputColums.removeAll(listColToRemove);
                GoogleOdaDataSetPage.this.viewerColSelected.refresh();
                for (OdaGoogleSheetColumn col : listColToRemove) {
                    GoogleOdaDataSetPage.this.listCol.add(col.getColName());
                }
                if (GoogleOdaDataSetPage.this.listInputColums.size() == 0) {
                    GoogleOdaDataSetPage.this.setPageComplete(false);
                } else {
                    GoogleOdaDataSetPage.this.setPageComplete(true);
                }
                GoogleOdaDataSetPage.this.changeEnableButtonParam();
                ArrayList<OdaGoogleParameter> listParamToRemove = new ArrayList<OdaGoogleParameter>();
                for (OdaGoogleSheetColumn col : listColToRemove) {
                    for (OdaGoogleParameter param : GoogleOdaDataSetPage.this.listInputParam) {
                        if (!param.getParamColumn().equals(col.getColName())) continue;
                        listParamToRemove.add(param);
                    }
                }
                GoogleOdaDataSetPage.this.listInputParam.removeAll(listParamToRemove);
                GoogleOdaDataSetPage.this.viewerParameters.refresh();
            }
        });
        this.btnRemoveAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GoogleOdaDataSetPage.this.setPageComplete(false);
                GoogleOdaDataSetPage.this.listCol.removeAll();
                GoogleOdaDataSetPage.this.listInputColums.clear();
                GoogleOdaDataSetPage.this.viewerColSelected.refresh();
                for (OdaGoogleSheetColumn currentNameCol : GoogleOdaDataSetPage.this.sheetSelected.getSheetListCol()) {
                    GoogleOdaDataSetPage.this.listCol.add(currentNameCol.getColName());
                }
                GoogleOdaDataSetPage.this.changeEnableButtonParam();
                GoogleOdaDataSetPage.this.listInputParam.clear();
                GoogleOdaDataSetPage.this.viewerParameters.refresh();
            }
        });
    }

    protected void refreshListCol(OdaGoogleSheet sheetSelected2) {
        this.listCol.removeAll();
        for (OdaGoogleSheetColumn col : sheetSelected2.getSheetListCol()) {
            this.listCol.add(col.getColName());
        }
    }

    protected OdaGoogleSheetColumn findColumnSheet(String colName) {
        OdaGoogleSheetColumn tempCol = null;
        for (OdaGoogleSheetColumn col : this.sheetSelected.getSheetListCol()) {
            if (!col.equals(colName)) continue;
            tempCol = col;
        }
        return tempCol;
    }

    protected void changeEnableButtonParam() {
        if (this.listInputColums.size() == 0) {
            this.btnAddParam.setEnabled(false);
            this.btnDelParam.setEnabled(false);
        } else {
            this.btnAddParam.setEnabled(true);
            this.btnDelParam.setEnabled(true);
        }
    }

    protected String[] getTabColumnSelected() {
        String[] tabColSel = new String[this.listInputColums.size()];
        int i = 0;
        while (i < this.listInputColums.size()) {
            tabColSel[i] = this.listInputColums.get(i).getColName();
            ++i;
        }
        return tabColSel;
    }

    private void initWidgetWithDataset(DataSetDesign dataSetDesigned) {
        String queryDataset = dataSetDesigned.getQueryText();
        String[] tabElementsQuery = queryDataset.split("]");
        for (OdaGoogleSheet currentSheet : this.listDataSetSheets) {
            if (!currentSheet.getSheetName().equals(tabElementsQuery[0])) continue;
            this.sheetSelected = currentSheet;
            this.sheetNameSelected = currentSheet.getSheetName();
        }
        this.comboSheets.setText(this.sheetNameSelected);
        String rowSkipped = tabElementsQuery[1];
        this.btnSkip.setEnabled(true);
        if (rowSkipped.equals("Skip true")) {
            this.btnSkip.setSelection(true);
        } else {
            this.btnSkip.setSelection(false);
        }
        String queryColSelected = tabElementsQuery[2];
        String[] listColsSelected = queryColSelected.split("!");
        this.listInputColums.clear();
        this.listCol.removeAll();
        for (OdaGoogleSheetColumn col : this.sheetSelected.getSheetListCol()) {
            boolean colIsSelected = false;
            String[] stringArray = listColsSelected;
            int n = listColsSelected.length;
            int n2 = 0;
            while (n2 < n) {
                String nameColSelected = stringArray[n2];
                if (nameColSelected.equals(col.getColName())) {
                    colIsSelected = true;
                }
                ++n2;
            }
            if (colIsSelected) {
                this.listInputColums.add(col);
            } else {
                this.listCol.add(col.getColName());
            }
            this.viewerColSelected.refresh();
        }
        String queryColSelectedLabel = tabElementsQuery[3];
        String[] listColsSelectedLabels = queryColSelectedLabel.split("!");
        int indexLabel = 0;
        for (OdaGoogleSheetColumn currentCol : this.listInputColums) {
            currentCol.setColLabelName(listColsSelectedLabels[indexLabel]);
            ++indexLabel;
        }
        this.viewerColSelected.refresh();
        String queryParameters = tabElementsQuery[5];
        if (!queryParameters.equals("++No Parameter++")) {
            String[] listParameters;
            String[] stringArray = listParameters = queryParameters.split(";");
            int n = listParameters.length;
            int n3 = 0;
            while (n3 < n) {
                String currentDetailsParam = stringArray[n3];
                String[] detailsParam = currentDetailsParam.split("!");
                this.listInputParam.add(new OdaGoogleParameter(detailsParam[0], detailsParam[1]));
                ++n3;
            }
            this.viewerParameters.refresh();
            this.btnDelParam.setEnabled(true);
        } else {
            this.btnDelParam.setEnabled(false);
        }
        this.btnAddParam.setEnabled(true);
    }

    public DataSetDesign collectDataSetDesign(DataSetDesign dataSetDesign) {
        String queryText = this.getQueryText(dataSetDesign);
        dataSetDesign.setQueryText(queryText);
        if (this.conn == null) {
            dataSetDesign.setParameters(null);
        } else {
            DataSetParameters dataSetParameter = null;
            try {
                IQuery query = this.conn.newQuery(null);
                query.prepare(queryText);
                IParameterMetaData pMd = query.getParameterMetaData();
                dataSetParameter = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)pMd, (ParameterMode)ParameterMode.IN_LITERAL);
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
            dataSetDesign.setParameters(dataSetParameter);
        }
        dataSetDesign.setResultSets(null);
        return dataSetDesign;
    }

    private String getQueryText(DataSetDesign dataSetDesign) {
        String query = "";
        if (this.btnSkip != null) {
            if (this.sheetNameSelected != null) {
                query = String.valueOf(query) + this.sheetNameSelected;
            }
            query = String.valueOf(query) + "]";
            query = this.btnSkip.getSelection() ? String.valueOf(query) + "Skip true" : String.valueOf(query) + "Skip false";
            query = String.valueOf(query) + "]";
            for (OdaGoogleSheetColumn col : this.listInputColums) {
                query = String.valueOf(query) + col.getColName() + "!";
            }
            query = String.valueOf(query) + "]";
            for (OdaGoogleSheetColumn col : this.listInputColums) {
                query = String.valueOf(query) + col.getColLabelName() + "!";
            }
            query = String.valueOf(query) + "]";
            if (dataSetDesign == null || dataSetDesign.getQueryText() == null || dataSetDesign.getQueryText().trim().equals("")) {
                query = String.valueOf(query) + "++No filter++]";
            } else {
                String dataSetQuery = dataSetDesign.getQueryText();
                String[] tabQueryColAndFilter = dataSetQuery.split("]");
                String strQueryFilter = tabQueryColAndFilter[4];
                query = String.valueOf(query) + strQueryFilter + "]";
            }
            if (this.listInputParam.isEmpty()) {
                query = String.valueOf(query) + "++No Parameter++";
            } else {
                for (OdaGoogleParameter currentParam : this.listInputParam) {
                    query = String.valueOf(query) + currentParam.getParamColumn() + "!";
                    query = String.valueOf(query) + currentParam.getParamOperator();
                    query = String.valueOf(query) + "!;";
                }
            }
            query = String.valueOf(query) + "]";
        } else {
            query = dataSetDesign.getQueryText();
        }
        return query;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isPageComplete() {
        return true;
    }

    private class ComboEditingSupport
    extends EditingSupport {
        private CellEditor editor;
        private Viewer myViewer;
        private String[] tabParamOperators;
        private int typeCombo;

        public ComboEditingSupport(TableViewer viewer, int type) {
            super((ColumnViewer)viewer);
            this.myViewer = viewer;
            this.typeCombo = type;
            this.tabParamOperators = GoogleOdaFilterPage.OPERATORS_TAB;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            this.editor = this.typeCombo == 1 ? new ComboBoxCellEditor((Composite)this.myViewer.getControl(), GoogleOdaDataSetPage.this.getTabColumnSelected()) : new ComboBoxCellEditor((Composite)this.myViewer.getControl(), this.tabParamOperators);
            return this.editor;
        }

        protected Object getValue(Object element) {
            return new Integer(0);
        }

        protected void setValue(Object element, Object value) {
            OdaGoogleParameter current = (OdaGoogleParameter)element;
            int indexCombo = Integer.valueOf(value.toString());
            if (this.typeCombo == 1) {
                current.setParamColumn(GoogleOdaDataSetPage.this.getTabColumnSelected()[indexCombo]);
            } else {
                current.setParamOperator(this.tabParamOperators[indexCombo]);
            }
            this.myViewer.refresh();
        }
    }

    static class MyEditingSupport
    extends EditingSupport {
        private CellEditor editor;
        private Viewer myViewer;

        public MyEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.myViewer = viewer;
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            OdaGoogleSheetColumn current = (OdaGoogleSheetColumn)element;
            return current.getColLabelName();
        }

        protected void setValue(Object element, Object value) {
            OdaGoogleSheetColumn current = (OdaGoogleSheetColumn)element;
            current.setColLabelName((String)value);
            this.myViewer.refresh();
        }
    }
}

