/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.spreadsheet.oda.driver.ui.impl.dataset;

import bpm.google.spreadsheet.oda.driver.ui.impl.dataset.FilterDescription;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class FilterTableViewer
extends CheckboxTableViewer {
    private ArrayList<FilterDescription> listInput;
    private ArrayList<FilterDescription> listFilterToRemoved;

    public static CheckboxTableViewer newCheckList(Composite parent, int style) {
        Table table = new Table(parent, 0x20 | style);
        return new FilterTableViewer(table);
    }

    public FilterTableViewer(Table pTable) {
        super(pTable);
        this.setContentProvider((IContentProvider)new MyStructuredContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new MyTableLabelProvider());
        if (this.getInput() == null) {
            this.listInput = new ArrayList();
        } else {
            this.listInput = new ArrayList();
            this.listInput = (ArrayList)this.getInput();
        }
        this.listFilterToRemoved = new ArrayList();
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FilterDescription currentFilter = (FilterDescription)event.getElement();
                if (event.getChecked()) {
                    FilterTableViewer.this.listFilterToRemoved.add(currentFilter);
                } else {
                    FilterTableViewer.this.listFilterToRemoved.remove(currentFilter);
                }
            }
        });
        this.setInput(this.listInput);
        this.refresh();
    }

    public ArrayList<FilterDescription> getListFilterToRemoved() {
        return this.listFilterToRemoved;
    }

    static class MyStructuredContentProvider
    implements IStructuredContentProvider {
        MyStructuredContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList localInputElement = (ArrayList)inputElement;
            return localInputElement.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class MyTableLabelProvider
    implements ITableLabelProvider {
        MyTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            FilterDescription currentFilter = (FilterDescription)element;
            String strReturned = "";
            switch (columnIndex) {
                case 0: {
                    strReturned = currentFilter.getFilterName();
                    break;
                }
                case 1: {
                    strReturned = currentFilter.getFilterOperator();
                    break;
                }
                case 2: {
                    strReturned = currentFilter.getFilterValue1();
                    break;
                }
                case 3: {
                    strReturned = currentFilter.getFilterValue2();
                    break;
                }
                case 4: {
                    strReturned = currentFilter.getFilterLogicalOperator();
                    break;
                }
                default: {
                    strReturned = "";
                }
            }
            return strReturned;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

