/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.okhttp.v3_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.trino.jdbc.$internal.okhttp3.Interceptor;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpClientResend;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.okhttp.v3_0.TracingCallFactory;
import java.io.IOException;

final class ContextInterceptor
implements Interceptor {
    ContextInterceptor() {
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Context parentContext = TracingCallFactory.getCallingContextForRequest(request);
        if (parentContext == null) {
            parentContext = Context.current();
        }
        Context context = HttpClientResend.initialize(parentContext);
        try (Scope ignored = context.makeCurrent();){
            Response response = chain.proceed(request);
            return response;
        }
    }
}

