/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.trino.jdbc.$internal.opentelemetry.extension.incubator.metrics.ExtendedDoubleHistogramBuilder;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.SemconvStability;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

final class HttpMetricsUtil {
    static final boolean emitNewSemconvMetrics = SemconvStability.emitStableHttpSemconv() && !SemconvStability.emitOldHttpSemconv();
    static final List<Double> DURATION_SECONDS_BUCKETS = Collections.unmodifiableList(Arrays.asList(0.0, 0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0));
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final double NANOS_PER_S = TimeUnit.SECONDS.toNanos(1L);

    static DoubleHistogram createDurationHistogram(Meter meter, String name, String description) {
        DoubleHistogramBuilder durationBuilder = meter.histogramBuilder(name).setUnit(emitNewSemconvMetrics ? "s" : "ms").setDescription(description);
        if (emitNewSemconvMetrics && durationBuilder instanceof ExtendedDoubleHistogramBuilder) {
            ((ExtendedDoubleHistogramBuilder)durationBuilder).setAdvice(advice -> advice.setExplicitBucketBoundaries(DURATION_SECONDS_BUCKETS));
        }
        return durationBuilder.build();
    }

    static double nanosToUnit(long durationNanos) {
        return (double)durationNanos / (emitNewSemconvMetrics ? NANOS_PER_S : NANOS_PER_MS);
    }

    private HttpMetricsUtil() {
    }
}

