/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.airlift.units.Duration;
import io.trino.jdbc.$internal.client.ClientSelectedRole;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import io.trino.jdbc.$internal.guava.collect.ImmutableSet;
import java.net.URI;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ClientSession {
    private final URI server;
    private final Optional<String> principal;
    private final Optional<String> user;
    private final String source;
    private final Optional<String> traceToken;
    private final Set<String> clientTags;
    private final String clientInfo;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final String path;
    private final ZoneId timeZone;
    private final Locale locale;
    private final Map<String, String> resourceEstimates;
    private final Map<String, String> properties;
    private final Map<String, String> preparedStatements;
    private final Map<String, ClientSelectedRole> roles;
    private final Map<String, String> extraCredentials;
    private final String transactionId;
    private final Duration clientRequestTimeout;
    private final boolean compressionDisabled;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClientSession clientSession) {
        return new Builder(clientSession);
    }

    public static ClientSession stripTransactionId(ClientSession session) {
        return ClientSession.builder(session).transactionId(null).build();
    }

    private ClientSession(URI server, Optional<String> principal, Optional<String> user, String source2, Optional<String> traceToken, Set<String> clientTags, String clientInfo, Optional<String> catalog, Optional<String> schema, String path, ZoneId timeZone, Locale locale, Map<String, String> resourceEstimates, Map<String, String> properties, Map<String, String> preparedStatements, Map<String, ClientSelectedRole> roles, Map<String, String> extraCredentials, String transactionId, Duration clientRequestTimeout, boolean compressionDisabled) {
        this.server = Objects.requireNonNull(server, "server is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.user = Objects.requireNonNull(user, "user is null");
        this.source = source2;
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
        this.clientTags = ImmutableSet.copyOf((Collection)Objects.requireNonNull(clientTags, "clientTags is null"));
        this.clientInfo = clientInfo;
        this.catalog = catalog;
        this.schema = schema;
        this.path = path;
        this.locale = locale;
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.transactionId = transactionId;
        this.resourceEstimates = ImmutableMap.copyOf(Objects.requireNonNull(resourceEstimates, "resourceEstimates is null"));
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.preparedStatements = ImmutableMap.copyOf(Objects.requireNonNull(preparedStatements, "preparedStatements is null"));
        this.roles = ImmutableMap.copyOf(Objects.requireNonNull(roles, "roles is null"));
        this.extraCredentials = ImmutableMap.copyOf(Objects.requireNonNull(extraCredentials, "extraCredentials is null"));
        this.clientRequestTimeout = clientRequestTimeout;
        this.compressionDisabled = compressionDisabled;
        for (String clientTag : clientTags) {
            Preconditions.checkArgument(!clientTag.contains(","), "client tag cannot contain ','");
        }
        CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
        for (Map.Entry<String, String> entry : resourceEstimates.entrySet()) {
            Preconditions.checkArgument(!entry.getKey().isEmpty(), "Resource name is empty");
            Preconditions.checkArgument(entry.getKey().indexOf(61) < 0, "Resource name must not contain '=': %s", (Object)entry.getKey());
            Preconditions.checkArgument(charsetEncoder.canEncode(entry.getKey()), "Resource name is not US_ASCII: %s", (Object)entry.getKey());
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Preconditions.checkArgument(!entry.getKey().isEmpty(), "Session property name is empty");
            Preconditions.checkArgument(entry.getKey().indexOf(61) < 0, "Session property name must not contain '=': %s", (Object)entry.getKey());
            Preconditions.checkArgument(charsetEncoder.canEncode(entry.getKey()), "Session property name is not US_ASCII: %s", (Object)entry.getKey());
            Preconditions.checkArgument(charsetEncoder.canEncode(entry.getValue()), "Session property value is not US_ASCII: %s", (Object)entry.getValue());
        }
        for (Map.Entry<String, String> entry : extraCredentials.entrySet()) {
            Preconditions.checkArgument(!entry.getKey().isEmpty(), "Credential name is empty");
            Preconditions.checkArgument(entry.getKey().indexOf(61) < 0, "Credential name must not contain '=': %s", (Object)entry.getKey());
            Preconditions.checkArgument(charsetEncoder.canEncode(entry.getKey()), "Credential name is not US_ASCII: %s", (Object)entry.getKey());
            Preconditions.checkArgument(charsetEncoder.canEncode(entry.getValue()), "Credential value is not US_ASCII: %s", (Object)entry.getValue());
        }
    }

    public URI getServer() {
        return this.server;
    }

    public Optional<String> getPrincipal() {
        return this.principal;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public String getSource() {
        return this.source;
    }

    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public String getPath() {
        return this.path;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Map<String, String> getResourceEstimates() {
        return this.resourceEstimates;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    public Map<String, ClientSelectedRole> getRoles() {
        return this.roles;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public boolean isDebug() {
        return false;
    }

    public Duration getClientRequestTimeout() {
        return this.clientRequestTimeout;
    }

    public boolean isCompressionDisabled() {
        return this.compressionDisabled;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("server", this.server).add("principal", this.principal).add("user", this.user).add("clientTags", this.clientTags).add("clientInfo", this.clientInfo).add("catalog", this.catalog).add("schema", this.schema).add("path", this.path).add("traceToken", this.traceToken.orElse(null)).add("timeZone", this.timeZone).add("locale", this.locale).add("properties", this.properties).add("transactionId", this.transactionId).omitNullValues().toString();
    }

    public static final class Builder {
        private URI server;
        private Optional<String> principal = Optional.empty();
        private Optional<String> user = Optional.empty();
        private String source;
        private Optional<String> traceToken = Optional.empty();
        private Set<String> clientTags = ImmutableSet.of();
        private String clientInfo;
        private String catalog;
        private String schema;
        private String path;
        private ZoneId timeZone;
        private Locale locale;
        private Map<String, String> resourceEstimates = ImmutableMap.of();
        private Map<String, String> properties = ImmutableMap.of();
        private Map<String, String> preparedStatements = ImmutableMap.of();
        private Map<String, ClientSelectedRole> roles = ImmutableMap.of();
        private Map<String, String> credentials = ImmutableMap.of();
        private String transactionId;
        private Duration clientRequestTimeout;
        private boolean compressionDisabled;

        private Builder() {
        }

        private Builder(ClientSession clientSession) {
            Objects.requireNonNull(clientSession, "clientSession is null");
            this.server = clientSession.getServer();
            this.principal = clientSession.getPrincipal();
            this.user = clientSession.getUser();
            this.source = clientSession.getSource();
            this.traceToken = clientSession.getTraceToken();
            this.clientTags = clientSession.getClientTags();
            this.clientInfo = clientSession.getClientInfo();
            this.catalog = clientSession.getCatalog().orElse(null);
            this.schema = clientSession.getSchema().orElse(null);
            this.path = clientSession.getPath();
            this.timeZone = clientSession.getTimeZone();
            this.locale = clientSession.getLocale();
            this.resourceEstimates = clientSession.getResourceEstimates();
            this.properties = clientSession.getProperties();
            this.preparedStatements = clientSession.getPreparedStatements();
            this.roles = clientSession.getRoles();
            this.credentials = clientSession.getExtraCredentials();
            this.transactionId = clientSession.getTransactionId();
            this.clientRequestTimeout = clientSession.getClientRequestTimeout();
            this.compressionDisabled = clientSession.isCompressionDisabled();
        }

        public Builder server(URI server) {
            this.server = server;
            return this;
        }

        public Builder user(Optional<String> user) {
            this.user = user;
            return this;
        }

        public Builder principal(Optional<String> principal) {
            this.principal = principal;
            return this;
        }

        public Builder source(String source2) {
            this.source = source2;
            return this;
        }

        public Builder traceToken(Optional<String> traceToken) {
            this.traceToken = traceToken;
            return this;
        }

        public Builder clientTags(Set<String> clientTags) {
            this.clientTags = clientTags;
            return this;
        }

        public Builder clientInfo(String clientInfo) {
            this.clientInfo = clientInfo;
            return this;
        }

        public Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder timeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder resourceEstimates(Map<String, String> resourceEstimates) {
            this.resourceEstimates = resourceEstimates;
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder roles(Map<String, ClientSelectedRole> roles) {
            this.roles = roles;
            return this;
        }

        public Builder credentials(Map<String, String> credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder preparedStatements(Map<String, String> preparedStatements) {
            this.preparedStatements = preparedStatements;
            return this;
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder clientRequestTimeout(Duration clientRequestTimeout) {
            this.clientRequestTimeout = clientRequestTimeout;
            return this;
        }

        public Builder compressionDisabled(boolean compressionDisabled) {
            this.compressionDisabled = compressionDisabled;
            return this;
        }

        public ClientSession build() {
            return new ClientSession(this.server, this.principal, this.user, this.source, this.traceToken, this.clientTags, this.clientInfo, Optional.ofNullable(this.catalog), Optional.ofNullable(this.schema), this.path, this.timeZone, this.locale, this.resourceEstimates, this.properties, this.preparedStatements, this.roles, this.credentials, this.transactionId, this.clientRequestTimeout, this.compressionDisabled);
        }
    }
}

