/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.xmla;

import java.util.ArrayList;
import java.util.List;
import org.fasd.olap.FAModel;
import org.fasd.olap.ICube;
import org.fasd.xmla.ISchema;
import org.fasd.xmla.XMLACube;
import org.fasd.xmla.XMLADataSourceConnection;

public class XMLASchema
implements ISchema {
    private List<ICube> cubes = new ArrayList<ICube>();
    private XMLADataSourceConnection con = new XMLADataSourceConnection();
    private FAModel model;

    public XMLADataSourceConnection getConnection() {
        return this.con;
    }

    public void setConnection(XMLADataSourceConnection con) {
        this.con = con;
    }

    public void addCube(XMLACube cube) {
        boolean exists = false;
        for (ICube c : this.cubes) {
            if (!((XMLACube)c).getName().equals(cube.getName())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.cubes.add(cube);
            cube.setParent(this);
        }
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("    <xmla>\n");
        buf.append(this.con.getFAXML());
        for (ICube cube : this.cubes) {
            buf.append(cube.getFAXML());
        }
        buf.append("    </xmla>\n");
        return buf.toString();
    }

    @Override
    public List<ICube> getICubes() {
        return this.cubes;
    }

    @Override
    public ISchema.SchemaType getSchemaType() {
        return ISchema.SchemaType.XMLA;
    }

    @Override
    public FAModel getParent() {
        return this.model;
    }
}

