/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.utils.trees;

import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataObjectItem;
import org.fasd.utils.trees.TreeColumn;
import org.fasd.utils.trees.TreeParent;

public class TreeTable
extends TreeParent {
    private boolean childrenLoaded = false;
    DataObject tab;

    public void setLoaded() {
        this.childrenLoaded = true;
    }

    @Override
    public boolean hasChildren() {
        if (!this.childrenLoaded) {
            return true;
        }
        return super.hasChildren();
    }

    public TreeTable(DataObject tab) {
        super(tab.getName());
        this.tab = tab;
    }

    public DataObject getTable() {
        return this.tab;
    }

    @Override
    public Object[] getChildren() {
        if (!this.childrenLoaded) {
            try {
                for (DataObjectItem o : this.tab.getColumns()) {
                    TreeColumn tt = new TreeColumn(o);
                    this.addChild(tt);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.childrenLoaded = true;
        }
        return super.getChildren();
    }
}

