/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.utils.trees;

import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataSourceConnection;
import org.fasd.utils.trees.TreeParent;
import org.fasd.utils.trees.TreeTable;

public class TreeSchema
extends TreeParent {
    private boolean childrenLoaded = false;
    private DataSourceConnection dataSourceConnection;

    protected DataSourceConnection getConnection() {
        return this.dataSourceConnection;
    }

    public TreeSchema(DataSourceConnection dataSourceConnection, String name) {
        super(name);
        this.dataSourceConnection = dataSourceConnection;
    }

    @Override
    public boolean hasChildren() {
        if (!this.childrenLoaded) {
            return true;
        }
        return super.hasChildren();
    }

    @Override
    public Object[] getChildren() {
        if (!this.childrenLoaded) {
            try {
                for (DataObject o : this.dataSourceConnection.getTables(this.getName())) {
                    TreeTable tt = new TreeTable(o);
                    this.addChild(tt);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.childrenLoaded = true;
        }
        return super.getChildren();
    }
}

