/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.utils.trees;

import bpm.connection.manager.connection.ConnectionManager;
import bpm.connection.manager.connection.jdbc.VanillaJdbcConnection;
import bpm.connection.manager.connection.jdbc.VanillaPreparedStatement;
import java.io.FileNotFoundException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.fasd.datasource.DataSourceConnection;
import org.fasd.olap.OLAPDimension;
import org.fasd.olap.OLAPHierarchy;
import org.fasd.olap.OLAPLevel;
import org.fasd.utils.trees.TreeDim;
import org.fasd.utils.trees.TreeHierarchy;
import org.fasd.utils.trees.TreeParent;
import xmldesigner.internal.DimensionTree;
import xmldesigner.parse.XMLParser;
import xmldesigner.parse.item.DataXML;
import xmldesigner.xpath.Xpath;

public class TreeMember
extends TreeParent {
    private OLAPLevel lvl;

    public TreeMember(String name, OLAPLevel lvl) {
        super(name);
        this.lvl = lvl;
    }

    public OLAPLevel getLevel() {
        return this.lvl;
    }

    public String getWhere() {
        if (this.lvl.getItem().getParent().getDataSource().getDriver().getType().equals("XML")) {
            String s = "where ($i//" + this.lvl.getItem().getOrigin() + "=\"" + this.getName() + "\")";
            TreeParent tp = this.getParent();
            while (tp instanceof TreeMember) {
                s = String.valueOf(s) + " and ($i//" + ((TreeMember)tp).getLevel().getItem().getOrigin();
                s = String.valueOf(s) + "=\"" + tp.getName() + "\")";
                tp = tp.getParent();
            }
            return String.valueOf(s) + "\n";
        }
        String s = " WHERE " + this.lvl.getItem().getOrigin() + "='" + this.getName().replace("'", "''") + "'";
        TreeParent tp = this.getParent();
        while (tp instanceof TreeMember) {
            s = String.valueOf(s) + " AND " + ((TreeMember)tp).getLevel().getItem().getOrigin();
            s = String.valueOf(s) + "='" + tp.getName() + "'";
            tp = tp.getParent();
        }
        return s;
    }

    public List<String> getValues(String sql) {
        ArrayList<String> result;
        block12: {
            System.out.println(sql);
            result = new ArrayList<String>();
            try {
                if (this.lvl.getItem().getParent().getDataSource().getDriver().getType().equals("XML")) {
                    DataSourceConnection sock = this.lvl.getItem().getParent().getDataSource().getDriver();
                    String url = "file:///" + sock.getTransUrl();
                    XMLParser parser = new XMLParser(url);
                    parser.parser();
                    DataXML dtd = parser.getDataXML();
                    Xpath xpath = new Xpath(sock.getTransUrl(), dtd.getRoot().getElement(0).getName());
                    DimensionTree model = new DimensionTree(dtd);
                    xmldesigner.internal.TreeParent rr = model.createModel();
                    xpath.setListHiera(this.createHiera(rr));
                    for (OLAPLevel l : this.lvl.getParent().getLevels()) {
                        if (l.getNb() > this.lvl.getNb() + 1) continue;
                        xpath.addCol(l.getItem().getOrigin());
                    }
                    try {
                        System.out.println("TREEMEMBER :\n" + sql);
                        xpath.executeXquery(sql);
                        xpath.modifieSortie();
                        XMLParser pars = new XMLParser("Temp/sortie.xml");
                        pars.parser();
                        DataXML dtd2 = pars.getDataXML();
                        ArrayList buf = xpath.listXquery(dtd2.getRoot());
                        int i = 1;
                        while (i <= buf.size()) {
                            if (i % (this.lvl.getNb() + 2) == 0) {
                                boolean contained = false;
                                for (String s : result) {
                                    if (!s.equals(buf.get(i - 1))) continue;
                                    contained = true;
                                    break;
                                }
                                if (!contained) {
                                    result.add((String)buf.get(i - 1));
                                }
                            }
                            ++i;
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
                this.lvl.getItem().getParent().getDataSource().getDriver().connectAll();
                VanillaJdbcConnection con = this.lvl.getItem().getParent().getDataSource().getDriver().getConnection().getConnection();
                VanillaPreparedStatement stmt = con.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    if (rs.getString(1) == null) continue;
                    result.add(rs.getString(1));
                }
                rs.close();
                stmt.close();
                ConnectionManager.getInstance().returnJdbcConnection(con);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void createChilds() {
        block10: {
            block9: {
                DataXML dtd;
                XMLParser parser;
                String url;
                DataSourceConnection sock;
                if (this.lvl.getNb() >= this.lvl.getParent().getLevels().size() - 1) break block9;
                OLAPLevel next = this.lvl.getParent().getLevels().get(this.lvl.getNb() + 1);
                String where = this.getWhere();
                String sql = "";
                if (next.getItem() != null) {
                    if (next.getItem().getParent().getDataSource().getDriver().getType().equals("XML")) {
                        sock = next.getItem().getParent().getDataSource().getDriver();
                        url = "file:///" + sock.getTransUrl();
                        parser = new XMLParser(url);
                        parser.parser();
                        dtd = parser.getDataXML();
                        sql = "for $i in doc('" + sock.getTransUrl().replace("\\", "/") + "')//" + dtd.getRoot().getElement(0).getName() + "\n";
                        sql = String.valueOf(sql) + this.getWhere();
                        sql = String.valueOf(sql) + "return\n";
                        sql = String.valueOf(sql) + "<" + dtd.getRoot().getElement(0).getName() + ">\n";
                        sql = String.valueOf(sql) + "{$i//" + next.getItem().getOrigin() + "}\n";
                        sql = String.valueOf(sql) + "</" + dtd.getRoot().getElement(0).getName() + ">\n";
                    } else {
                        sql = "SELECT DISTINCT " + next.getItem().getOrigin() + " FROM " + next.getItem().getParent().getPhysicalName();
                        if (!where.endsWith(" WHERE ")) {
                            sql = String.valueOf(sql) + where;
                        }
                    }
                } else if (next.getItem().getParent().getDataSource().getDriver().getType().equals("XML")) {
                    sock = next.getItem().getParent().getDataSource().getDriver();
                    url = "file:///" + sock.getTransUrl();
                    parser = new XMLParser(url);
                    parser.parser();
                    dtd = parser.getDataXML();
                    sql = "for $i in doc('" + sock.getTransUrl().replace("\\", "/") + "')//" + next.getItem().getOrigin() + "\n";
                    sql = String.valueOf(sql) + "return\n";
                    sql = String.valueOf(sql) + "<" + dtd.getRoot().getElement(0).getName() + ">\n";
                    sql = String.valueOf(sql) + "{$i}\n";
                    sql = String.valueOf(sql) + "</" + dtd.getRoot().getElement(0).getName() + ">\n";
                } else {
                    sql = "SELECT DISTINCT " + next.getSql() + " FROM " + next.getTableId();
                }
                for (String s : this.getValues(sql)) {
                    System.out.println(s);
                    TreeMember tm = new TreeMember(s, next);
                    this.addChild(tm);
                    tm.createChilds();
                }
                break block10;
            }
            if (!this.lvl.isClosureNeeded()) break block10;
            String sql = "SELECT DISTINCT " + this.lvl.getItem().getOrigin() + " FROM " + this.lvl.getItem().getParent().getPhysicalName();
            sql = String.valueOf(sql) + " WHERE " + this.lvl.getClosureParentCol().getName() + "=" + this.getName();
            for (String s : this.getValues(sql)) {
                System.out.println(s);
                TreeMember tm = new TreeMember(s, this.lvl);
                this.addChild(tm);
                tm.createChilds();
            }
        }
    }

    public static TreeParent createModel(OLAPDimension dim) {
        TreeParent root = new TreeParent("");
        TreeDim td = new TreeDim(dim);
        for (OLAPHierarchy h : dim.getHierarchies()) {
            TreeHierarchy th = new TreeHierarchy(h);
            if (h.getLevels().size() > 0) {
                OLAPLevel l0 = h.getLevels().get(0);
                ArrayList<String> list = new ArrayList<String>();
                try {
                    l0.getItem().getParent().getDataSource().getDriver().connectAll();
                    VanillaJdbcConnection con = l0.getItem().getParent().getDataSource().getDriver().getConnection().getConnection();
                    VanillaPreparedStatement stmt = con.createStatement();
                    ResultSet rs = stmt.executeQuery("SELECT DISTINCT " + l0.getItem().getOrigin() + " FROM " + l0.getItem().getParent().getPhysicalName());
                    while (rs.next()) {
                        if (rs.getString(1) == null) continue;
                        list.add(rs.getString(1));
                    }
                    rs.close();
                    stmt.close();
                    ConnectionManager.getInstance().returnJdbcConnection(con);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                for (String s : list) {
                    TreeMember tm = new TreeMember(s, l0);
                    th.addChild(tm);
                    tm.createChilds();
                }
            }
            td.addChild(th);
        }
        root.addChild(td);
        return root;
    }

    private ArrayList<String> createHiera(xmldesigner.internal.TreeParent t) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(t.getName());
        int i = 0;
        while (i < t.getChildren().length) {
            this.add(list, this.createHiera((xmldesigner.internal.TreeParent)t.getChildren(i)));
            ++i;
        }
        return list;
    }

    private List<String> add(List<String> list1, List<String> list2) {
        int i = 0;
        while (i < list2.size()) {
            list1.add(list2.get(i));
            ++i;
        }
        return list1;
    }
}

