/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.utils;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataObjectItem;
import org.fasd.olap.OLAPRelation;

public class Path {
    private ArrayList<OLAPRelation> path = new ArrayList();

    public List<OLAPRelation> getRelations() {
        return this.path;
    }

    public void addRelationship(OLAPRelation rel) {
        this.path.add(rel);
    }

    public void removeRelationship() {
        this.path.remove(this.size() - 1);
    }

    public OLAPRelation getLastRelationship() {
        return this.path.get(this.size() - 1);
    }

    public int size() {
        return this.path.size();
    }

    public int nrTables() {
        return this.getUsedTables().length;
    }

    public OLAPRelation getRelationship(int i) {
        if (this.path.size() == 0 || i >= this.path.size()) {
            return null;
        }
        return this.path.get(i);
    }

    public boolean contains(Path in) {
        if (in.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            int nr = 0;
            while (this.getRelationship(i + nr).equals(in.getRelationship(nr)) && nr < in.size() && i + nr < this.size()) {
                ++nr;
            }
            if (nr == in.size()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(OLAPRelation rel) {
        if (rel == null) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            OLAPRelation check = this.getRelationship(i);
            DataObject from = check.getLeftObject();
            DataObject to = check.getRightObject();
            if (rel.getLeftObject().equals(from) && rel.getRightObject().equals(to) || rel.getLeftObject().equals(to) && rel.getRightObject().equals(from)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(DataObject tab) {
        if (tab == null) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            OLAPRelation check = this.getRelationship(i);
            if (check.isUsingTable(tab)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(DataObject[] tabs) {
        if (tabs == null) {
            return false;
        }
        boolean all = true;
        int i = 0;
        while (i < tabs.length && all) {
            if (!this.contains(tabs[i])) {
                all = false;
            }
            ++i;
        }
        return all;
    }

    public boolean contains(ArrayList<DataObject> tabs) {
        if (tabs == null) {
            return false;
        }
        boolean all = true;
        int i = 0;
        while (i < tabs.size() && all) {
            if (!this.contains(tabs.get(i))) {
                all = false;
            }
            ++i;
        }
        return all;
    }

    public Object clone() {
        Path retval = new Path();
        int i = 0;
        while (i < this.size()) {
            OLAPRelation rel = this.getRelationship(i);
            retval.addRelationship(rel);
            ++i;
        }
        return retval;
    }

    public String toString() {
        String thisPath = "";
        int i = 0;
        while (i < this.size()) {
            OLAPRelation relationship = this.getRelationship(i);
            if (i > 0) {
                thisPath = String.valueOf(thisPath) + ", ";
            }
            thisPath = String.valueOf(thisPath) + "[" + relationship.getLeftObject().getId() + "-" + relationship.getRightObject().getId() + "]";
            ++i;
        }
        return thisPath;
    }

    public int compare(Path thisPath) {
        int diff = this.size() - thisPath.size();
        if (diff < 0) {
            return -1;
        }
        if (diff > 0) {
            return 1;
        }
        return 0;
    }

    public DataObject[] getUsedTables() {
        Hashtable<DataObject, String> hash = new Hashtable<DataObject, String>();
        int i = 0;
        while (i < this.size()) {
            OLAPRelation rel = this.getRelationship(i);
            hash.put(rel.getLeftObject(), "OK");
            hash.put(rel.getRightObject(), "OK");
            ++i;
        }
        return hash.keySet().toArray(new DataObject[hash.keySet().size()]);
    }

    public List<DataObjectItem> getUsedItems() {
        Hashtable<DataObjectItem, String> hash = new Hashtable<DataObjectItem, String>();
        int i = 0;
        while (i < this.size()) {
            OLAPRelation rel = this.getRelationship(i);
            hash.put(rel.getLeftObjectItem(), "OK");
            hash.put(rel.getRightObjectItem(), "OK");
            ++i;
        }
        ArrayList<DataObjectItem> l = new ArrayList<DataObjectItem>();
        for (DataObjectItem i2 : hash.keySet()) {
            l.add(i2);
        }
        return l;
    }

    public OLAPRelation[] getUsedRelationships() {
        ArrayList<OLAPRelation> list = new ArrayList<OLAPRelation>();
        int i = 0;
        while (i < this.size()) {
            OLAPRelation rel = this.getRelationship(i);
            boolean exists = false;
            int j = 0;
            while (j < list.size() && !exists) {
                OLAPRelation check = (OLAPRelation)list.get(j);
                if (check.isUsingTable(rel.getLeftObject()) && check.isUsingTable(rel.getRightObject())) {
                    exists = true;
                }
                ++j;
            }
            if (!exists) {
                list.add(rel);
            }
            ++i;
        }
        OLAPRelation[] rels = new OLAPRelation[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            rels[i2] = (OLAPRelation)list.get(i2);
            ++i2;
        }
        return rels;
    }
}

