/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.utils;

import java.util.ArrayList;
import java.util.List;
import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataSource;
import org.fasd.olap.FAModel;
import org.fasd.olap.OLAPRelation;
import org.fasd.utils.Path;

public class ActionGetPath {
    private DataObject[] datas;
    private FAModel model;
    Path path;

    public ActionGetPath(FAModel model, DataObject[] datas) {
        this.model = model;
        this.datas = datas;
    }

    public Path getPath() {
        return this.path;
    }

    public void run() {
        this.path = this.getShortestPathBetween(this.datas);
    }

    private Path getShortestPathBetween(DataObject[] tabs) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (tabs.length < 2) {
            return null;
        }
        ArrayList<DataObject> selectedTables = new ArrayList<DataObject>();
        int i = 0;
        while (i < tabs.length) {
            selectedTables.add(tabs[i]);
            ++i;
        }
        boolean allUsed = tabs.length == 0;
        while (!allUsed) {
            List<DataObject> notSelectedTables = this.getNonSelectedTables(selectedTables);
            Path path = new Path();
            int i2 = 0;
            while (i2 < selectedTables.size()) {
                int j = i2 + 1;
                while (j < selectedTables.size()) {
                    DataObject two;
                    DataObject one;
                    OLAPRelation relationship;
                    if (i2 != j && (relationship = this.findRelationshipUsing(one = (DataObject)selectedTables.get(i2), two = (DataObject)selectedTables.get(j))) != null && !path.contains(relationship)) {
                        path.addRelationship(relationship);
                    }
                    ++j;
                }
                if (this.isPathCorrect(path, tabs[0], tabs[1])) {
                    paths.add(path);
                    allUsed = true;
                }
                ++i2;
            }
            if (allUsed) continue;
            if (notSelectedTables.size() > 0) {
                DataObject businessTable = notSelectedTables.get(0);
                notSelectedTables.remove(0);
                selectedTables.add(businessTable);
                continue;
            }
            allUsed = true;
        }
        if (paths.isEmpty()) {
            return null;
        }
        Path minPath = (Path)paths.get(0);
        int i3 = 1;
        while (i3 < paths.size()) {
            Path path1 = (Path)paths.get(i3);
            if (path1.size() < minPath.size()) {
                minPath = path1;
            }
            ++i3;
        }
        return minPath;
    }

    private List<DataObject> getNonSelectedTables(List<DataObject> selectedTables) {
        ArrayList<DataObject> l = new ArrayList<DataObject>();
        for (DataSource ds : this.model.getDataSources()) {
            for (DataObject t : ds.getDataObjects()) {
                if (selectedTables.contains(t)) continue;
                l.add(t);
            }
        }
        return l;
    }

    private OLAPRelation findRelationshipUsing(DataObject one, DataObject two) {
        int i = 0;
        while (i < this.model.getRelations().size()) {
            OLAPRelation relationship = this.model.getRelations().get(i);
            if (relationship.isUsingTable(one) && relationship.isUsingTable(two)) {
                return this.model.getRelations().get(i);
            }
            ++i;
        }
        return null;
    }

    private boolean isPathCorrect(Path path, DataObject one, DataObject two) {
        boolean findOne = false;
        boolean findTwo = false;
        for (OLAPRelation r : path.getRelations()) {
            if (r.getRightObject() == one || r.getLeftObject() == one) {
                findOne = true;
            }
            if (r.getRightObject() != two && r.getLeftObject() != two) continue;
            findTwo = true;
        }
        return findOne && findTwo;
    }
}

