/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.sql;

import bpm.connection.manager.connection.ConnectionManager;
import bpm.connection.manager.connection.jdbc.VanillaJdbcConnection;
import bpm.studio.jdbc.management.model.ListDriver;
import bpm.vanilla.platform.core.config.ConfigurationManager;
import java.io.FileNotFoundException;

public class SQLConnection {
    private String url;
    private String user;
    private String pass;
    private String driverFile;
    private String driverName;
    private String type;
    private String schemaName;

    public SQLConnection() {
    }

    public void setDriverFile(String driverFile) {
        this.driverFile = driverFile;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public SQLConnection(String url, String user, String pass, String driverFile, String driverName, String dbName, String type) {
        this.url = url;
        this.user = user;
        this.pass = pass;
        this.driverFile = driverFile;
        this.driverName = driverName;
        this.schemaName = dbName;
        this.type = type;
    }

    public VanillaJdbcConnection getConnection() throws FileNotFoundException, Exception {
        String jdbcXml = ConfigurationManager.getInstance().getVanillaConfiguration().getProperty("bpm.vanilla.platform.jdbcDriverXmlFile");
        String driverClass = ListDriver.getInstance((String)jdbcXml).getInfo(this.driverName).getClassName();
        if (this.user.equals("")) {
            return ConnectionManager.getInstance().getJdbcConnection(this.url, null, null, driverClass);
        }
        try {
            return ConnectionManager.getInstance().getJdbcConnection(this.url, this.user, this.pass, driverClass);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (this.url.startsWith("jdbc:oracle") && this.url.contains("/")) {
                return ConnectionManager.getInstance().getJdbcConnection(this.url.replace("/", ":"), this.user, this.pass, driverClass);
            }
            throw ex;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPass() {
        return this.pass;
    }

    public String getDriverFile() {
        return this.driverFile;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }
}

