/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.security;

import java.util.ArrayList;
import java.util.List;
import org.fasd.olap.OLAPElement;
import org.fasd.olap.OLAPHierarchy;
import org.fasd.security.SecurityDim;
import org.fasd.security.SecurityGroup;

public class View
extends OLAPElement {
    private static int counter = 0;
    private String desc = "";
    private String securityGroupId = "";
    private boolean allowAccess = false;
    private boolean allowFullAccess = false;
    private List<String> restrictItems = new ArrayList<String>();
    private SecurityGroup group;
    private SecurityDim parent;
    private OLAPHierarchy hiera;
    private String hierarchyId;

    public View(OLAPHierarchy hiera) {
        super("");
        this.setId("z" + String.valueOf(++counter));
        this.hiera = hiera;
    }

    public View() {
        super("");
        this.setId("z" + String.valueOf(++counter));
    }

    public void setId(String id) {
        this.id = id;
        int i = Integer.parseInt(id.substring(1));
        if (i > counter) {
            counter = i + 1;
        }
    }

    public void setHierarchyId(String id) {
        this.hierarchyId = id;
    }

    public String getHierarchyId() {
        return this.hierarchyId;
    }

    public void setHierarchy(OLAPHierarchy h) {
        this.hiera = h;
    }

    public View(String name) {
        super(name);
        this.setId("z" + String.valueOf(++counter));
    }

    public SecurityDim getParent() {
        return this.parent;
    }

    public void setParent(SecurityDim sd) {
        this.parent = sd;
    }

    public boolean isAllowAccess() {
        return this.allowAccess;
    }

    public void setAllowAccess(boolean allowAccess) {
        this.allowAccess = allowAccess;
    }

    public void setAllowAccess(String allowAccess) {
        this.allowAccess = Boolean.parseBoolean(allowAccess);
    }

    public boolean isAllowFullAccess() {
        return this.allowFullAccess;
    }

    public void setAllowFullAccess(boolean allowFullAccess) {
        this.allowFullAccess = allowFullAccess;
    }

    public void setAllowFullAccess(String allowFullAccess) {
        this.allowFullAccess = Boolean.parseBoolean(allowFullAccess);
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    public void setSecurityGroupId(String securityGroupId) {
        this.securityGroupId = securityGroupId;
    }

    public SecurityGroup getGroup() {
        return this.group;
    }

    public void setGroup(SecurityGroup group) {
        if (group != null) {
            group.removeView(this);
        }
        if (group != null) {
            this.setSecurityGroupId(group.getId());
            this.group = group;
        } else {
            this.setSecurityGroupId("");
            group = null;
        }
        if (group != null) {
            group.addView(this);
        }
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("        <groupdefinition-item>\n");
        buf.append("            <id>" + this.getId() + "</id>\n");
        buf.append("            <name>" + this.getName() + "</name>\n");
        buf.append("            <description>" + this.getDesc() + "</description>\n");
        buf.append("            <securitygroup-id>" + this.securityGroupId + "</securitygroup-id>\n");
        buf.append("            <hierarchy-id>" + this.hiera.getId() + "</hierarchy-id>\n");
        buf.append("            <AllowAcces>" + this.allowAccess + "</AllowAcces>\n");
        buf.append("            <AllowFullAcces>" + this.allowFullAccess + "</AllowFullAcces>\n");
        for (String i : this.restrictItems) {
            buf.append("            <RestrictionMemberList>" + i + "</RestrictionMemberList>\n");
        }
        buf.append("        </groupdefinition-item>\n");
        return buf.toString();
    }

    public void addMember(String member) {
        this.restrictItems.add(member);
    }

    public List<String> getMembers() {
        return this.restrictItems;
    }

    public void removeMember(String s) {
        for (String m : this.restrictItems) {
            if (!m.equals(s)) continue;
            this.restrictItems.remove(m);
            break;
        }
    }

    public String getXML() {
        StringBuffer buf = new StringBuffer();
        if (this.allowFullAccess) {
            if (this.restrictItems.size() > 0) {
                if (!this.hiera.getName().trim().equals("")) {
                    buf.append("                 <HierarchyGrant hierarchy=\"[" + this.hiera.getParent().getName() + "].[" + this.hiera.getName() + "]\" access=\"custom\" topLevel=\"" + this.hiera.getLevels().get(0).getName() + "\">\n");
                } else {
                    buf.append("                 <HierarchyGrant hierarchy=\"" + this.hiera.getParent().getName() + "\" access=\"custom\" topLevel=\"" + this.hiera.getLevels().get(0).getName() + "\" bottomLevel=\"" + this.hiera.getLevels().get(this.hiera.getLevels().size() - 1).getName() + "\">\n");
                }
                for (String s : this.restrictItems) {
                    buf.append("                     <MemberGrant member=\"" + s + "\" access=\"none\"/>\n");
                }
                buf.append("                 </HierarchyGrant>\n");
            } else if (!this.hiera.getName().trim().equals("")) {
                buf.append("                 <HierarchyGrant hierarchy=\"[" + this.hiera.getParent().getName() + "].[" + this.hiera.getName() + "]\" access=\"all\"/>\n");
            } else {
                buf.append("                 <HierarchyGrant hierarchy=\"" + this.hiera.getParent().getName() + "\" access=\"all\"/>\n");
            }
        } else if (this.restrictItems.size() > 0) {
            if (!this.hiera.getName().trim().equals("")) {
                buf.append("                 <HierarchyGrant hierarchy=\"[" + this.hiera.getParent().getName() + "].[" + this.hiera.getName() + "]\" access=\"custom\">\n");
            } else {
                buf.append("                 <HierarchyGrant hierarchy=\"" + this.hiera.getParent().getName() + "\" access=\"custom\">\n");
            }
            for (String s : this.restrictItems) {
                buf.append("                     <MemberGrant member=\"" + s + "\" access=\"all\"/>\n");
            }
            buf.append("                 </HierarchyGrant>\n");
        } else if (!this.hiera.getName().trim().equals("")) {
            buf.append("                 <HierarchyGrant hierarchy=\"[" + this.hiera.getParent().getName() + "].[" + this.hiera.getName() + "]\" access=\"none\"/>\n");
        } else {
            buf.append("                 <HierarchyGrant hierarchy=\"" + this.hiera.getParent().getName() + "\" access=\"none\"/>\n");
        }
        return buf.toString();
    }

    public OLAPHierarchy getHierarchy() {
        return this.hiera;
    }
}

