/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.security;

import java.util.ArrayList;
import java.util.List;
import org.fasd.olap.OLAPElement;
import org.fasd.olap.SecurityProvider;
import org.fasd.olap.ServerConnection;

public class Security
extends OLAPElement {
    private List<SecurityProvider> providers = new ArrayList<SecurityProvider>();
    private List<ServerConnection> servers = new ArrayList<ServerConnection>();

    public Security() {
        super("");
    }

    public ServerConnection findServerConnection(String id) {
        for (ServerConnection s : this.servers) {
            if (!s.getId().equals(id)) continue;
            return s;
        }
        return null;
    }

    public List<SecurityProvider> getSecurityProviders() {
        return this.providers;
    }

    public List<ServerConnection> getServerConnections() {
        return this.servers;
    }

    public void addServerConnection(ServerConnection c) {
        this.servers.add(c);
    }

    public void addSecurityProvider(SecurityProvider p) {
        this.providers.add(p);
    }

    public void removeServerConnection(ServerConnection s) {
        this.servers.remove(s);
    }

    public void removeSecurityProvider(SecurityProvider s) {
        this.providers.remove(s);
    }

    public ServerConnection findServer(String serverId) {
        for (ServerConnection s : this.servers) {
            if (!s.getId().equals(serverId)) continue;
            return s;
        }
        return null;
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<security>\n");
        buf.append("    <server-connection>\n");
        for (ServerConnection serverConnection : this.servers) {
            buf.append(serverConnection.getFAXML());
        }
        buf.append("    </server-connection>\n");
        buf.append("    <security-provider>\n");
        for (SecurityProvider securityProvider : this.providers) {
            buf.append(securityProvider.getFAXML());
        }
        buf.append("    </security-provider>\n");
        buf.append("</security>\n");
        return buf.toString();
    }
}

