/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.palo;

import java.util.ArrayList;
import java.util.List;
import org.fasd.olap.FAModel;
import org.fasd.olap.ICube;
import org.fasd.palo.PALOCube;
import org.fasd.palo.PALODataSourceConnection;
import org.fasd.xmla.ISchema;

public class PALOSchema
implements ISchema {
    private List<ICube> cubes = new ArrayList<ICube>();
    private PALODataSourceConnection con = new PALODataSourceConnection();

    public PALODataSourceConnection getConnection() {
        return this.con;
    }

    public void setConnection(PALODataSourceConnection con) {
        this.con = con;
    }

    public void addCube(PALOCube cube) {
        boolean exists = false;
        for (ICube c : this.cubes) {
            if (!((PALOCube)c).getName().equals(cube.getName())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.cubes.add(cube);
            cube.setParent(this);
        }
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("    <xmla>\n");
        buf.append(this.con.getFAXML());
        for (ICube cube : this.cubes) {
            buf.append(cube.getFAXML());
        }
        buf.append("    </xmla>\n");
        return buf.toString();
    }

    @Override
    public List<ICube> getICubes() {
        return this.cubes;
    }

    @Override
    public ISchema.SchemaType getSchemaType() {
        return ISchema.SchemaType.PALO;
    }

    @Override
    public FAModel getParent() {
        return null;
    }
}

