/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap.virtual;

import org.fasd.olap.OLAPCube;
import org.fasd.olap.OLAPElement;
import org.fasd.olap.OLAPMeasure;

public class VirtualMeasure
extends OLAPElement {
    private String cubeName = "";
    private String measureName = "";
    private OLAPCube cube;
    private OLAPMeasure mes;

    public VirtualMeasure() {
    }

    public VirtualMeasure(OLAPCube c, OLAPMeasure m) {
        this.cube = c;
        this.mes = m;
        this.cubeName = c.getName();
        this.measureName = this.mes.getName();
        this.setName("[" + this.cube.getName() + "].[" + this.mes.getName() + "]");
    }

    public OLAPCube getCube() {
        return this.cube;
    }

    public void setCube(OLAPCube cube) {
        this.cube = cube;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    public String getMeasureName() {
        return this.measureName;
    }

    public void setMeasureName(String measureName) {
        this.measureName = measureName.startsWith("[Measures].[") ? measureName.substring(12, measureName.lastIndexOf("]")) : measureName;
    }

    public OLAPMeasure getMes() {
        return this.mes;
    }

    public void setMes(OLAPMeasure mes) {
        this.mes = mes;
    }

    public String getXML() {
        StringBuffer buf = new StringBuffer();
        if (this.cube == null || this.mes == null) {
            buf.append("            <VirtualCubeMeasure cubeName=\"" + this.cubeName + "\" name=\"[Measures].[" + this.measureName + "]\"/>\n");
        } else {
            buf.append("            <VirtualCubeMeasure cubeName=\"" + this.cube.getName() + "\" name=\"[Measures].[" + this.mes.getName() + "]\"/>\n");
        }
        return buf.toString();
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("            <VirtualMeasure-item>\n");
        if (this.cube != null) {
            buf.append("                 <Cube-id>" + this.cube.getId() + "</Cube-id>\n");
        }
        buf.append("               <Measure-id>" + this.mes.getId() + "</Measure-id>\n");
        buf.append("            </VirtualMeasure-item>\n");
        return buf.toString();
    }

    @Override
    public String getName() {
        if (this.mes != null) {
            return this.mes.getName();
        }
        return this.measureName;
    }
}

