/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap.virtual;

import org.fasd.olap.OLAPDimension;
import org.fasd.olap.OLAPElement;

public class VirtualDimension
extends OLAPElement {
    private String cubeName = "";
    private String dimName = "";
    private boolean visible = true;
    private OLAPDimension dim;

    public VirtualDimension() {
    }

    public VirtualDimension(OLAPDimension d) {
        this.dim = d;
        this.dimName = this.dim.getName();
        this.setName(this.dim.getName());
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    public OLAPDimension getDim() {
        return this.dim;
    }

    public void setDim(OLAPDimension dim) {
        this.dim = dim;
    }

    public String getDimName() {
        return this.dimName;
    }

    public void setDimName(String dimName) {
        this.dimName = dimName;
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("            <VirtualDimension-item>\n");
        buf.append("                <visible>" + this.visible + "</visible>\n");
        buf.append("                <Dimension-id>" + this.dim.getId() + "</Dimension-id>\n");
        buf.append("            </VirtualDimension-item>\n");
        return buf.toString();
    }

    public String getXML() {
        StringBuffer buf = new StringBuffer();
        if (this.dim == null) {
            buf.append("            <VirtualCubeDimension ");
            if (!this.visible) {
                buf.append("visible=\"false\" ");
            }
            buf.append("name=\"" + this.dimName + "\"/>\n");
        } else {
            buf.append("            <VirtualCubeDimension name=\"" + this.dim.getName() + "\"/>\n");
        }
        return buf.toString();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setVisible(String visible) {
        this.visible = Boolean.parseBoolean(visible);
    }
}

