/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap.virtual;

import java.util.ArrayList;
import java.util.List;
import org.fasd.datasource.DataSource;
import org.fasd.datasource.IConnection;
import org.fasd.olap.Drill;
import org.fasd.olap.ICube;
import org.fasd.olap.ICubeView;
import org.fasd.olap.NamedSet;
import org.fasd.olap.OLAPDimension;
import org.fasd.olap.OLAPElement;
import org.fasd.olap.OLAPMeasure;
import org.fasd.olap.list.ListSecurityGroup;
import org.fasd.olap.virtual.VirtualDimension;
import org.fasd.olap.virtual.VirtualMeasure;
import org.fasd.security.SecurityGroup;
import org.fasd.xmla.ISchema;

public class VirtualCube
extends OLAPElement
implements ICube {
    private List<VirtualDimension> virtualDims = new ArrayList<VirtualDimension>();
    private List<VirtualMeasure> virtualMes = new ArrayList<VirtualMeasure>();
    private List<OLAPMeasure> calcMes = new ArrayList<OLAPMeasure>();
    private ListSecurityGroup securityGroups = new ListSecurityGroup();
    private List<String> secuId = new ArrayList<String>();
    private String dataSourceId = "";
    private String description = "";
    private DataSource dataSource;
    private List<NamedSet> namedSet = new ArrayList<NamedSet>();
    private List<String> namedSetId = new ArrayList<String>();
    private String caption = "";
    private boolean enable = true;
    private boolean cache = true;

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public void setCache(String cache) {
        this.cache = Boolean.parseBoolean(cache);
    }

    public void setEnable(String enable) {
        this.enable = Boolean.parseBoolean(enable);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<VirtualDimension> getVirtualDimensions() {
        return this.virtualDims;
    }

    public void addVirtualDimension(VirtualDimension dim) {
        this.virtualDims.add(dim);
    }

    public void removeVirtualDimension(VirtualDimension dim) {
        this.virtualDims.remove(dim);
    }

    public List<VirtualMeasure> getVirtualMeasure() {
        return this.virtualMes;
    }

    public void addVirtualMeasure(VirtualMeasure mes) {
        this.virtualMes.add(mes);
    }

    public void removeVirtualMeasure(VirtualMeasure mes) {
        this.virtualMes.remove(mes);
    }

    public List<OLAPMeasure> getCalcMeasure() {
        return this.calcMes;
    }

    public void addCalcMeasure(OLAPMeasure mes) {
        if (mes.getType().equals("calculated")) {
            this.calcMes.add(mes);
        }
    }

    public void removeCalcMeasure(OLAPMeasure mes) {
        this.calcMes.remove(mes);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("         <VirtualCube-item>\n");
        buf.append("             <id>" + this.getId() + "</id>\n");
        buf.append("             <name>" + this.getName() + "</name>\n");
        buf.append("             <enabled>" + this.enable + "</enabled>\n");
        buf.append("             <cached>" + this.cache + "</cached>\n");
        buf.append("             <caption>" + this.caption + "</caption>\n");
        buf.append("             <description>" + this.description + "</description>\n");
        buf.append("             <datasource-id>" + this.dataSource.getId() + "</datasource-id>\n");
        for (VirtualDimension v : this.virtualDims) {
            buf.append(v.getFAXML());
        }
        for (VirtualMeasure m : this.virtualMes) {
            buf.append(m.getFAXML());
        }
        for (SecurityGroup g : this.securityGroups.getList()) {
            buf.append("        <security-group-item-id>" + g.getId() + "</security-group-item-id>\n");
        }
        for (NamedSet ns : this.namedSet) {
            buf.append("        <namedSet-id>" + ns.getId() + "</namedSet-id>\n");
        }
        buf.append("        </VirtualCube-item>\n");
        return buf.toString();
    }

    public String getXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("        <VirtualCube name=\"" + this.getName());
        if (!this.caption.trim().equals("")) {
            buf.append("\" caption=\"" + this.caption);
        }
        buf.append("\">\n");
        for (VirtualDimension vd : this.virtualDims) {
            buf.append(vd.getXML());
        }
        for (VirtualMeasure vm : this.virtualMes) {
            buf.append(vm.getXML());
        }
        for (OLAPMeasure m : this.calcMes) {
            buf.append(m.getXML(null));
        }
        for (NamedSet ns : this.namedSet) {
            buf.append(ns.getXML());
        }
        buf.append("        </VirtualCube>\n");
        return buf.toString();
    }

    public void addSecurityGroup(SecurityGroup secu) {
        this.securityGroups.add(secu);
    }

    public void removeSecurityGroup(SecurityGroup secu) {
        this.securityGroups.remove(secu);
    }

    public List<SecurityGroup> getSecurityGroups() {
        return this.securityGroups.getList();
    }

    public void addSecurityId(String id) {
        this.secuId.add(id);
    }

    public List<String> getSecurityGroupsId() {
        return this.secuId;
    }

    public void addNamedSetid(String id) {
        this.namedSetId.add(id);
    }

    public void addNamedSet(NamedSet ns) {
        this.namedSet.add(ns);
    }

    public List<String> getNamedSetsId() {
        return this.namedSetId;
    }

    public List<NamedSet> getNamedSets() {
        return this.namedSet;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    @Override
    public IConnection getConnection() {
        if (this.getDataSource() != null) {
            return this.getDataSource().getDriver();
        }
        return null;
    }

    public boolean containsDimension(OLAPDimension d) {
        for (VirtualDimension vd : this.virtualDims) {
            if (vd.getDim() != d) continue;
            return true;
        }
        return false;
    }

    public boolean containsMeasure(OLAPMeasure m) {
        for (VirtualMeasure vm : this.virtualMes) {
            if (vm.getMes() != m) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ICubeView> getCubeViews() {
        return null;
    }

    @Override
    public String getFAProvider() {
        return "mondrian";
    }

    @Override
    public String getFAType() {
        return "mondrian";
    }

    @Override
    public List<Drill> getDrills() {
        return new ArrayList<Drill>();
    }

    @Override
    public ISchema getParent() {
        return null;
    }
}

