/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap.aggregate;

import java.util.ArrayList;
import java.util.List;
import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataObjectItem;
import org.fasd.olap.OLAPElement;
import org.fasd.olap.OLAPRelation;
import org.fasd.olap.aggregate.AggLevel;
import org.fasd.olap.aggregate.AggMeasure;
import org.fasd.olap.aggregate.AggPattern;

public class AggregateTable
extends OLAPElement {
    private DataObject table;
    private List<AggMeasure> aggMes = new ArrayList<AggMeasure>();
    private List<AggLevel> aggLvl = new ArrayList<AggLevel>();
    private List<AggPattern> aggPat = new ArrayList<AggPattern>();
    private String tableId;
    private DataObjectItem factCountColumn;
    private String factCountItemId;
    private static int counter = 0;

    public static void resetCounter() {
        counter = 0;
    }

    public AggregateTable() {
        this.id = Integer.toString(++counter);
    }

    public DataObject getTable() {
        return this.table;
    }

    public void setTable(DataObject table) {
        this.table = table;
    }

    public List<AggLevel> getAggLvl() {
        return this.aggLvl;
    }

    public List<AggMeasure> getAggMes() {
        return this.aggMes;
    }

    public void addAggMeasure(AggMeasure aggM) {
        if (!this.aggMes.contains(aggM)) {
            this.aggMes.add(aggM);
        }
    }

    public void removeAggMeasure(AggMeasure aggM) {
        this.aggMes.remove(aggM);
    }

    public void addAggLevel(AggLevel aggL) {
        if (!this.aggLvl.contains(aggL)) {
            this.aggLvl.add(aggL);
        }
    }

    public void removeAggLevel(AggLevel aggL) {
        this.aggLvl.remove(aggL);
    }

    public String getXML(List<OLAPRelation> foreignKeys) {
        StringBuffer buf = new StringBuffer();
        buf.append("            <AggName name=\"" + this.table.getName() + "\">\n");
        buf.append("                <AggFactCount column=\"" + this.factCountColumn.getOrigin() + "\"/>\n");
        for (OLAPRelation r : foreignKeys) {
            if (r.getRightObject() == this.table) {
                buf.append("                <AggForeignKey factColumn=\"" + r.getLeftObjectItem().getOrigin() + "\" aggColumn=\"" + r.getRightObjectItem().getOrigin() + "\"/>\n");
                continue;
            }
            if (r.getLeftObject() != this.table) continue;
            buf.append("                <AggForeignKey factColumn=\"" + r.getRightObjectItem().getOrigin() + "\" aggColumn=\"" + r.getLeftObjectItem().getOrigin() + "\"/>\n");
        }
        for (AggMeasure m : this.aggMes) {
            buf.append("                <AggMeasure name=\"[Measures].[" + m.getMes().getName() + "]\" column=\"" + m.getColumn().getOrigin() + "\"/>\n");
        }
        for (AggLevel l : this.aggLvl) {
            String mondrianName = "[" + l.getLvl().getParent().getParent().getName() + "].[";
            if (!l.getLvl().getParent().getName().trim().equals("")) {
                mondrianName = String.valueOf(mondrianName) + l.getLvl().getParent().getName() + "].[";
            }
            mondrianName = String.valueOf(mondrianName) + l.getLvl().getName() + "]";
            buf.append("                <AggLevel name=\"" + mondrianName + "\" column=\"" + l.getColumn().getOrigin() + "\"/>\n");
        }
        buf.append("            </AggName>\n");
        return buf.toString();
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("        <AggregateTable>\n");
        buf.append("            <id>" + this.getId() + "</id>\n");
        buf.append("            <dataobject-id>" + this.table.getId() + "</dataobject-id>\n");
        buf.append("            <factCountItem-id>" + this.factCountColumn.getId() + "</factCountItem-id>\n");
        for (AggMeasure m : this.aggMes) {
            buf.append("            <AggMeasure>\n");
            buf.append("                <measure-id>" + m.getMes().getId() + "</measure-id>\n");
            buf.append("                <column-id>" + m.getColumn().getId() + "</column-id>\n");
            buf.append("            </AggMeasure>\n");
        }
        for (AggLevel l : this.aggLvl) {
            buf.append("            <AggLevel>\n");
            buf.append("                <level-id>" + l.getLvl().getId() + "</level-id>\n");
            buf.append("                <column-id>" + l.getColumn().getId() + "</column-id>\n");
            buf.append("            </AggLevel>\n");
        }
        buf.append("        </AggregateTable>\n");
        return buf.toString();
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DataObjectItem getFactCountColumn() {
        return this.factCountColumn;
    }

    public void setFactCountColumn(DataObjectItem factCountColumn) {
        this.factCountColumn = factCountColumn;
    }

    public String getFactCountItemId() {
        return this.factCountItemId;
    }

    public void setFactCountItemId(String factCountItemId) {
        this.factCountItemId = factCountItemId;
    }

    public List<AggPattern> getPatterns() {
        return this.aggPat;
    }

    public void addAggPattern(AggPattern p) {
        this.aggPat.add(p);
    }
}

