/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import org.fasd.olap.OLAPElement;
import org.fasd.olap.ServerConnection;

public class SecurityProvider
extends OLAPElement {
    private static int counter = 0;
    private String type = "";
    private String serverId = "";
    private ServerConnection server;
    private String url = "";
    private String user = "";
    private String password = "";
    private String description = "";

    public static void resetCounter() {
        counter = 0;
    }

    public SecurityProvider() {
        super("");
        this.setId("b" + ++counter);
    }

    public void setId(String id) {
        this.id = id;
        try {
            int i = Integer.parseInt(id.substring(1));
            if (i > counter) {
                counter = i + 1;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public SecurityProvider(String name) {
        super(name);
        this.setId("b" + ++counter);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ServerConnection getServer() {
        return this.server;
    }

    public void setServer(ServerConnection server) {
        this.server = server;
        this.serverId = server.getId();
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("        <security-provider-item>\n");
        buf.append("            <name>" + this.getName() + "</name>\n");
        buf.append("            <id>" + this.getId() + "</id>\n");
        buf.append("            <type>" + this.type + "</type>\n");
        buf.append("            <server-id>");
        if (this.server != null) {
            buf.append(this.server.getId());
        }
        buf.append("</server-id>\n");
        buf.append("            <url>" + this.url + "</url>\n");
        buf.append("            <user>" + this.user + "</user>\n");
        buf.append("            <password>" + this.password + "</password>\n");
        buf.append("            <description>" + this.description + "</description>\n");
        buf.append("        </security-provider-item>\n");
        return buf.toString();
    }
}

