/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import org.fasd.datasource.DataObjectItem;
import org.fasd.olap.OLAPElement;

public class Property
extends OLAPElement {
    private String columnId = "";
    private String formatter = "";
    private String type = "";
    private String caption = "";
    private DataObjectItem column;
    private static int counter = 0;
    public static String[] TYPES = new String[]{"String", "Numeric", "Integer", "Boolean", "Date", "Time", "Timestamp"};

    public static void resetCounter() {
        counter = 0;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Property() {
        this.id = Integer.toString(++counter);
    }

    public String getColumnId() {
        return this.columnId;
    }

    public void setColumnId(String columnId) {
        this.columnId = columnId;
    }

    public String getFormatter() {
        return this.formatter;
    }

    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("            <Property>\n");
        buf.append("                <id>" + this.id + "</id>\n");
        buf.append("                <caption>" + this.caption + "</caption>\n");
        buf.append("                <name>" + this.getName() + "</name>\n");
        buf.append("                <dataobjectitem-id>" + this.column.getId() + "</dataobjectitem-id>\n");
        buf.append("                <type>" + this.type + "</type>\n");
        buf.append("                <formatter>" + this.formatter + "</formatter>\n");
        buf.append("            </Property>\n");
        return buf.toString();
    }

    public String getXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("                    <Property name=\"" + this.getName() + "\"");
        if (!this.caption.trim().equals("")) {
            buf.append(" caption=\"" + this.caption + "\"");
        }
        if (this.column != null) {
            buf.append(" column=\"" + this.column.getName() + "\"");
        } else {
            buf.append(" column=\"" + this.columnId + "\"");
        }
        buf.append(" type=\"" + this.type + "\"");
        if (!this.formatter.equals("")) {
            buf.append(" formatter=\"" + this.formatter + "\"/>\n");
        } else {
            buf.append("/>\n");
        }
        return buf.toString();
    }

    public DataObjectItem getColumn() {
        return this.column;
    }

    public void setColumn(DataObjectItem column) {
        this.column = column;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }
}

