/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import java.util.ArrayList;
import java.util.List;
import org.fasd.olap.OLAPMeasure;
import org.fasd.olap.aggregation.IMeasureAggregation;

public class OlapDynamicMeasure
extends OLAPMeasure {
    private List<IMeasureAggregation> aggregations;

    public List<IMeasureAggregation> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<IMeasureAggregation> aggregations) {
        this.aggregations = aggregations;
    }

    public void addAggregation(IMeasureAggregation aggregation) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList<IMeasureAggregation>();
        }
        IMeasureAggregation toRm = null;
        for (IMeasureAggregation aggreg : this.aggregations) {
            if (!aggreg.getLevel().equals(aggregation.getLevel())) continue;
            toRm = aggreg;
            break;
        }
        if (toRm != null) {
            this.aggregations.remove(toRm);
        }
        this.aggregations.add(aggregation);
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("    <Dynamic-Measure-item>\n");
        buf.append("        <id>" + this.getId() + "</id>\n");
        buf.append("        <name>" + this.getName() + "</name>\n");
        buf.append("        <caption>" + this.caption + "</caption>\n");
        buf.append("        <description>" + this.desc + "</description>\n");
        buf.append("        <measure-group-id>" + this.groupId + "</measure-group-id>\n");
        buf.append("        <type>" + this.type + "</type>\n");
        buf.append("        <order>" + this.order + "</order>\n");
        buf.append("        <origin-id>" + this.originId + "</origin-id>\n");
        buf.append("        <formula>" + this.formula + "</formula>\n");
        buf.append("        <label>" + this.labelId + "</label>\n");
        buf.append("        <visible>" + this.visible + "</visible>\n");
        buf.append("        <aggregator>" + this.aggregator + "</aggregator>\n");
        buf.append("        <color-rules><![CDATA[" + this.getColorScript() + "]]></color-rules>\n");
        if (("last".equals(this.aggregator) || "first".equals(this.aggregator)) && this.lastTimeDimensionName != null && !"".equals(this.lastTimeDimensionName)) {
            buf.append("        <lastTimeDimensionName>" + this.lastTimeDimensionName + "</lastTimeDimensionName>\n");
        }
        buf.append("        <formatString>" + this.formatstr + "</formatString>\n");
        for (String s : this.propExpression.keySet()) {
            buf.append("        <property>\n");
            buf.append("            <name>" + s + "</name>\n");
            String expr = ((String)this.propExpression.get(s)).replaceAll("<", "&lt;");
            expr = expr.replaceAll(">", "&gt;");
            buf.append("            <expression>" + expr + "</expression>\n");
            buf.append("        </property>\n");
        }
        if (!this.type.trim().equals("physical")) {
            buf.append("        <dimensionName>" + this.dimensionName + "</dimensionName>\n");
        }
        if (this.aggregations != null) {
            for (IMeasureAggregation agg : this.aggregations) {
                buf.append("\t\t" + agg.getFaXml());
            }
        }
        buf.append("    </Dynamic-Measure-item>\n");
        return buf.toString();
    }
}

