/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import java.util.ArrayList;
import java.util.List;
import org.fasd.inport.mondrian.beans.RoleGrantBean;
import org.fasd.olap.FAModel;
import org.fasd.olap.ICube;
import org.fasd.olap.NamedSet;
import org.fasd.olap.OLAPCube;
import org.fasd.olap.OLAPDimension;
import org.fasd.olap.OLAPDimensionGroup;
import org.fasd.olap.OLAPElement;
import org.fasd.olap.OLAPGroup;
import org.fasd.olap.OLAPHierarchy;
import org.fasd.olap.OLAPLevel;
import org.fasd.olap.OLAPMeasure;
import org.fasd.olap.OLAPMeasureGroup;
import org.fasd.olap.UserDefinedFunction;
import org.fasd.olap.aggregate.AggregateTable;
import org.fasd.olap.list.ListCube;
import org.fasd.olap.list.ListDimGroup;
import org.fasd.olap.list.ListDimension;
import org.fasd.olap.list.ListMeasure;
import org.fasd.olap.list.ListMesGroup;
import org.fasd.olap.list.ListVirtualCube;
import org.fasd.olap.virtual.VirtualCube;
import org.fasd.security.SecurityDim;
import org.fasd.security.SecurityGroup;
import org.fasd.security.View;
import org.fasd.xmla.ISchema;

public class OLAPSchema
extends OLAPElement
implements ISchema {
    private String name = "MySchema";
    private ListCube cubes = new ListCube();
    private ListDimension dims = new ListDimension();
    private ListMeasure mes = new ListMeasure();
    private ArrayList<SecurityDim> dimView = new ArrayList();
    private ListDimGroup dimGrps = new ListDimGroup();
    private ListMesGroup mesGrps = new ListMesGroup();
    private List<SecurityGroup> secGrps = new ArrayList<SecurityGroup>();
    private List<AggregateTable> aggs = new ArrayList<AggregateTable>();
    private ListVirtualCube virtualCubes = new ListVirtualCube();
    private List<NamedSet> namedSets = new ArrayList<NamedSet>();
    private List<UserDefinedFunction> userFunctions = new ArrayList<UserDefinedFunction>();
    private List<RoleGrantBean> mondrianRole = new ArrayList<RoleGrantBean>();
    private String measureCaption = "";
    private String defaultRole = "";
    private FAModel parent;

    public void addCube(OLAPCube cube) {
        this.cubes.add(cube);
        cube.setParent(this);
    }

    @Override
    public FAModel getParent() {
        return this.parent;
    }

    public void setParent(FAModel parent) {
        this.parent = parent;
    }

    public void addVirtualCube(VirtualCube vCube) {
        this.virtualCubes.add(vCube);
    }

    public void removeVirtualCube(VirtualCube vCube) {
        this.virtualCubes.remove(vCube);
    }

    public List<VirtualCube> getVirtualCubes() {
        return this.virtualCubes.getList();
    }

    public void addDimensionGroup(OLAPDimensionGroup g) {
        this.dimGrps.add(g);
    }

    public void removeDimensionGroup(OLAPDimensionGroup element) {
        this.dimGrps.remove(element);
        if (element.getParent() != null) {
            element.getParent().removeChild(element);
        }
        for (OLAPDimension d : element.getDimensions()) {
            d.setGroup(null);
        }
        for (OLAPGroup gg : element.getChilds()) {
            this.removeDimensionGroup((OLAPDimensionGroup)gg);
        }
    }

    public List<OLAPDimensionGroup> getDimensionGroups() {
        return this.dimGrps.getList();
    }

    public List<OLAPMeasureGroup> getMeasureGroups() {
        return this.mesGrps.getList();
    }

    public List<OLAPCube> getCubes() {
        return this.cubes.getList();
    }

    public void addDimension(OLAPDimension dim) {
        this.dims.add(dim);
        dim.setParent(this);
    }

    public List<OLAPDimension> getDimensions() {
        return this.dims.getList();
    }

    public void removeDimension(String name) {
        int i = 0;
        while (i < this.dims.getList().size()) {
            if (this.dims.getList().get(i).getName().equals(name)) {
                System.out.println("removing dimension in OLAPSchema = " + this.dims.getList().get(i).getName());
                this.dims.getList().remove(i);
                break;
            }
            ++i;
        }
    }

    public void removeDimension(OLAPDimension dim) {
        this.dims.remove(dim);
    }

    public void removeCube(String name) {
        int i = 0;
        while (i < this.cubes.getList().size()) {
            if (this.cubes.getList().get(i).getName().equals(name)) {
                System.out.println("removing cube in OLAPSchema = " + this.cubes.getList().get(i).getName());
                this.cubes.getList().remove(i);
                break;
            }
            ++i;
        }
    }

    public void removeCube(OLAPCube cube) {
        this.cubes.remove(cube);
    }

    public String getXML() {
        String buf = "";
        buf = String.valueOf(buf) + "<Schema name=\"" + this.name + "\"";
        if (!this.defaultRole.trim().equals("")) {
            buf = String.valueOf(buf) + "defaultRole=\"" + this.defaultRole + "\"";
        }
        if (!this.measureCaption.trim().equals("")) {
            buf = String.valueOf(buf) + "measureCaption=\"" + this.measureCaption + "\"";
        }
        buf = String.valueOf(buf) + ">\n\n";
        for (UserDefinedFunction f : this.userFunctions) {
            buf = String.valueOf(buf) + f.getXML();
        }
        block1: for (OLAPDimension d : this.dims.getList()) {
            for (OLAPCube c : this.cubes.getList()) {
                if (!c.getDims().contains(d)) continue;
                buf = String.valueOf(buf) + d.getXML(c.getFactDataObject());
                continue block1;
            }
        }
        int i = 0;
        while (i < this.cubes.getList().size()) {
            buf = String.valueOf(buf) + this.cubes.getList().get(i).getXML();
            ++i;
        }
        for (VirtualCube vCube : this.virtualCubes.getList()) {
            buf = String.valueOf(buf) + vCube.getXML();
        }
        for (NamedSet ns : this.namedSets) {
            if (!ns.isGlobal()) continue;
            buf = String.valueOf(buf) + ns.getXML();
        }
        buf = String.valueOf(buf) + "</Schema>\n";
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFAXML() {
        void var5_31;
        void var5_29;
        void var5_27;
        void var5_25;
        String tmp = "<olap>\n\n";
        tmp = String.valueOf(tmp) + "    <defaultRoleName>" + this.defaultRole + "</defaultRoleName>\n";
        tmp = String.valueOf(tmp) + "    <measureCaption>" + this.measureCaption + "</measureCaption>\n";
        tmp = String.valueOf(tmp) + "    <UserDefinedFunctions>\n";
        for (UserDefinedFunction f : this.userFunctions) {
            tmp = String.valueOf(tmp) + f.getFAXML();
        }
        tmp = String.valueOf(tmp) + "    </UserDefinedFunctions>\n";
        tmp = String.valueOf(tmp) + "    <Dimension-group>\n";
        ArrayList<OLAPGroup> lst = new ArrayList<OLAPGroup>();
        for (OLAPDimensionGroup oLAPDimensionGroup : this.dimGrps.getList()) {
            tmp = String.valueOf(tmp) + oLAPDimensionGroup.getFAXML();
            lst.addAll(oLAPDimensionGroup.getChilds());
        }
        for (OLAPGroup oLAPGroup : lst) {
            tmp = String.valueOf(tmp) + oLAPGroup.getFAXML();
            lst.addAll(oLAPGroup.getChilds());
        }
        tmp = String.valueOf(tmp) + "    </Dimension-group>\n";
        tmp = String.valueOf(tmp) + "    <Measure-group>\n";
        ArrayList<OLAPGroup> arrayList = new ArrayList<OLAPGroup>();
        for (OLAPMeasureGroup oLAPMeasureGroup : this.mesGrps.getList()) {
            tmp = String.valueOf(tmp) + oLAPMeasureGroup.getFAXML();
            arrayList.addAll(oLAPMeasureGroup.getChilds());
        }
        for (OLAPGroup oLAPGroup : this.getMeasureGroups()) {
            tmp = String.valueOf(tmp) + oLAPGroup.getFAXML();
            arrayList.addAll(oLAPGroup.getChilds());
        }
        tmp = String.valueOf(tmp) + "    </Measure-group>\n";
        tmp = String.valueOf(tmp) + "    <Security-group>\n";
        ArrayList arrayList2 = new ArrayList();
        for (SecurityGroup securityGroup : this.secGrps) {
            tmp = String.valueOf(tmp) + securityGroup.getFAXML();
            arrayList.addAll(securityGroup.getChilds());
        }
        for (OLAPGroup oLAPGroup : arrayList2) {
            tmp = String.valueOf(tmp) + oLAPGroup.getFAXML();
            arrayList.addAll(oLAPGroup.getChilds());
        }
        tmp = String.valueOf(tmp) + "    </Security-group>\n";
        tmp = String.valueOf(tmp) + "    <Aggregate>\n";
        for (AggregateTable aggregateTable : this.aggs) {
            tmp = String.valueOf(tmp) + aggregateTable.getFAXML();
        }
        tmp = String.valueOf(tmp) + "    </Aggregate>\n";
        tmp = String.valueOf(tmp) + "    <Dimension>\n";
        boolean bl = false;
        while (var5_25 < this.dims.getList().size()) {
            tmp = String.valueOf(tmp) + this.dims.getList().get((int)var5_25).getFAXML();
            ++var5_25;
        }
        tmp = String.valueOf(tmp) + "    </Dimension>\n";
        tmp = String.valueOf(tmp) + "    <Measure>\n";
        boolean bl2 = false;
        while (var5_27 < this.mes.getList().size()) {
            tmp = String.valueOf(tmp) + this.mes.getList().get((int)var5_27).getFAXML();
            ++var5_27;
        }
        tmp = String.valueOf(tmp) + "    </Measure>\n";
        tmp = String.valueOf(tmp) + "    <Cube>\n";
        boolean bl3 = false;
        while (var5_29 < this.cubes.getList().size()) {
            tmp = String.valueOf(tmp) + this.cubes.getList().get((int)var5_29).getFAXML();
            ++var5_29;
        }
        tmp = String.valueOf(tmp) + "    </Cube>\n";
        tmp = String.valueOf(tmp) + "    <VirtualCube>\n";
        boolean bl4 = false;
        while (var5_31 < this.virtualCubes.getList().size()) {
            tmp = String.valueOf(tmp) + this.virtualCubes.getList().get((int)var5_31).getFAXML();
            ++var5_31;
        }
        tmp = String.valueOf(tmp) + "    </VirtualCube>\n";
        tmp = String.valueOf(tmp) + "    <NamedSets>\n";
        for (NamedSet namedSet : this.namedSets) {
            tmp = String.valueOf(tmp) + namedSet.getFAXML();
        }
        tmp = String.valueOf(tmp) + "    </NamedSets>\n";
        tmp = String.valueOf(tmp) + "</olap>\n\n";
        return tmp;
    }

    private boolean inAllCube(NamedSet n) {
        for (OLAPCube c : this.cubes.getList()) {
            if (!c.getNamedSets().contains(n)) continue;
            return false;
        }
        return true;
    }

    public List<OLAPMeasure> getMeasures() {
        return this.mes.getList();
    }

    public void addMeasure(OLAPMeasure measure) {
        this.mes.add(measure);
    }

    public void removeMeasure(OLAPMeasure mes) {
        this.mes.remove(mes);
    }

    public void addMeasureGroup(OLAPMeasureGroup element) {
        this.mesGrps.add(element);
    }

    public void addSecurityGroup(SecurityGroup g) {
        boolean contains = false;
        for (SecurityGroup sg : this.secGrps) {
            if (!sg.getName().equals(g.getName())) continue;
            contains = true;
            break;
        }
        if (!contains) {
            this.secGrps.add(g);
        }
    }

    public void removeSecurityGroup(SecurityGroup g) {
        this.secGrps.remove(g);
        if (g.getParent() != null) {
            g.getParent().removeChild(g);
        }
        for (View m : g.getViews()) {
            m.setGroup(null);
        }
        for (OLAPGroup gg : g.getChilds()) {
            this.removeSecurityGroup((SecurityGroup)gg);
        }
    }

    public void removeMeasureGroup(OLAPMeasureGroup element) {
        this.mesGrps.remove(element);
        if (element.getParent() != null) {
            element.getParent().removeChild(element);
        }
        for (OLAPMeasure m : element.getMeasures()) {
            m.setGroup(null);
        }
        element.getMeasures().clear();
        for (OLAPGroup gg : element.getChilds()) {
            this.removeMeasureGroup((OLAPMeasureGroup)gg);
        }
    }

    public OLAPDimension findDimension(String s) {
        for (OLAPDimension d : this.dims.getList()) {
            if (!d.getId().equals(s)) continue;
            return d;
        }
        return null;
    }

    public OLAPMeasure findMeasure(String s) {
        for (OLAPMeasure m : this.mes.getList()) {
            if (!m.getId().equals(s)) continue;
            return m;
        }
        return null;
    }

    public OLAPMeasureGroup findMeasureGroup(String s) {
        for (OLAPMeasureGroup m : this.mesGrps.getList()) {
            if (!m.getId().equals(s)) continue;
            return m;
        }
        return null;
    }

    public OLAPDimensionGroup findDimensionGroup(String s) {
        for (OLAPDimensionGroup m : this.dimGrps.getList()) {
            if (!m.getId().equals(s)) continue;
            return m;
        }
        return null;
    }

    public List<SecurityDim> getDimViews() {
        return this.dimView;
    }

    public void addDimView(SecurityDim dim) {
        this.dimView.add(dim);
    }

    public void removeDimView(SecurityDim dim) {
        this.dimView.remove(dim);
    }

    public List<SecurityGroup> getSecurityGroups() {
        return this.secGrps;
    }

    public SecurityDim findDimensionView(String dimId) {
        for (SecurityDim d : this.dimView) {
            if (!d.getId().equals(dimId)) continue;
            return d;
        }
        return null;
    }

    public SecurityGroup findSecurityGroup(String parentId) {
        for (SecurityGroup g : this.secGrps) {
            if (!g.getId().equals(parentId)) continue;
            return g;
        }
        return null;
    }

    public View findView(String string) {
        for (SecurityDim d : this.dimView) {
            for (View v : d.getViews()) {
                if (!v.getId().equals(string)) continue;
                return v;
            }
        }
        return null;
    }

    public OLAPDimension findDimensionByName(String s) {
        for (OLAPDimension d : this.dims.getList()) {
            if (!d.getName().equals(s)) continue;
            return d;
        }
        return null;
    }

    public OLAPCube findCube(String id) {
        for (OLAPCube c : this.cubes.getList()) {
            if (!c.getId().equals(id)) continue;
            return c;
        }
        return null;
    }

    public OLAPCube findCubeNamed(String cubeName) {
        for (OLAPCube c : this.cubes.getList()) {
            if (!c.getName().equals(cubeName)) continue;
            return c;
        }
        return null;
    }

    public ListCube getListCube() {
        return this.cubes;
    }

    public ListMeasure getListMeasures() {
        return this.mes;
    }

    public ListMesGroup getListMesGroup() {
        return this.mesGrps;
    }

    public ListDimension getListDimensions() {
        return this.dims;
    }

    public ListDimGroup getListDimGroup() {
        return this.dimGrps;
    }

    public ListVirtualCube getListVirtualCube() {
        return this.virtualCubes;
    }

    public SecurityDim findSecurityDim(OLAPDimension dimension) {
        SecurityDim sd2;
        for (SecurityDim sd2 : this.dimView) {
            if (sd2.getDim() != dimension) continue;
            return sd2;
        }
        sd2 = new SecurityDim();
        sd2.setDim(dimension);
        sd2.setDimId(dimension.getId());
        sd2.setName(String.valueOf(dimension.getName()) + " View");
        this.addDimView(sd2);
        return sd2;
    }

    public List<AggregateTable> getAggregates() {
        return this.aggs;
    }

    public void addAggregate(AggregateTable agg) {
        if (!this.aggs.contains(agg)) {
            this.aggs.add(agg);
        }
    }

    public void removeAggregate(AggregateTable agg) {
        this.aggs.remove(agg);
    }

    public AggregateTable findAggTableById(String s) {
        for (AggregateTable a : this.aggs) {
            if (!a.getId().equals(s)) continue;
            return a;
        }
        return null;
    }

    public OLAPLevel findLevel(String levelId) {
        for (OLAPDimension d : this.dims.getList()) {
            for (OLAPHierarchy h : d.getHierarchies()) {
                for (OLAPLevel l : h.getLevels()) {
                    if (!l.getId().equals(levelId)) continue;
                    return l;
                }
            }
        }
        return null;
    }

    public OLAPLevel findLevelNamed(String levelName) {
        String[] buf = levelName.split("]");
        OLAPDimension d = null;
        OLAPHierarchy h = null;
        block0: for (OLAPDimension dim : this.dims.getList()) {
            if (!dim.getName().equals(buf[0].substring(1, buf[0].length()))) continue;
            d = dim;
            if (buf.length == 2) {
                for (OLAPHierarchy hiera : d.getHierarchies()) {
                    if (!hiera.getName().equals("")) continue;
                    h = hiera;
                    for (OLAPLevel lvl : h.getLevels()) {
                        if (!lvl.getName().equals(buf[1].substring(2, buf[1].length()))) continue;
                        return lvl;
                    }
                    break block0;
                }
            } else {
                for (OLAPHierarchy hiera : d.getHierarchies()) {
                    if (!hiera.getName().equals(buf[1].substring(2, buf[1].length()))) continue;
                    h = hiera;
                    for (OLAPLevel lvl : h.getLevels()) {
                        if (!lvl.getName().equals(buf[2].substring(2, buf[2].length()))) continue;
                        return lvl;
                    }
                    break block0;
                }
            }
            break;
        }
        return null;
    }

    public OLAPMeasure findMeasureNamed(String mesName) throws Exception {
        String[] buf = mesName.split("]");
        String s = "";
        try {
            s = mesName.contains("[") ? buf[1].substring(2) : mesName;
        }
        catch (Exception exception) {
            throw new Exception();
        }
        for (OLAPMeasure m : this.mes.getList()) {
            if (!m.getName().equals(s)) continue;
            return m;
        }
        return null;
    }

    public String getXML(OLAPCube cube) {
        if (!this.cubes.contains(cube)) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<Schema name=\"" + this.name + "\">\n\n");
        for (OLAPDimension d : cube.getDims()) {
            buf.append(d.getXML(cube.getFactDataObject()));
        }
        buf.append(cube.getXML());
        buf.append("</Schema>\n");
        return buf.toString();
    }

    public List<ICube> getCubes(SecurityGroup secu) {
        ArrayList<ICube> result = new ArrayList<ICube>();
        for (VirtualCube c : this.virtualCubes.getList()) {
            if (!c.getSecurityGroups().contains(secu)) continue;
            result.add(c);
        }
        return result;
    }

    @Override
    public List<ICube> getICubes() {
        ArrayList<ICube> result = new ArrayList<ICube>();
        for (OLAPCube oLAPCube : this.cubes.getList()) {
            result.add(oLAPCube);
        }
        for (VirtualCube virtualCube : this.virtualCubes.getList()) {
            result.add(virtualCube);
        }
        return result;
    }

    public void addNamedSet(NamedSet set) {
        this.namedSets.add(set);
    }

    public List<NamedSet> getNamedSets() {
        return this.namedSets;
    }

    public NamedSet findNamedSetById(String id) {
        for (NamedSet ns : this.namedSets) {
            if (!ns.getId().equals(id)) continue;
            return ns;
        }
        return null;
    }

    public void addUserDefinedFunction(UserDefinedFunction func) {
        this.userFunctions.add(func);
    }

    public String getDefaultRole() {
        return this.defaultRole;
    }

    public void setDefaultRole(String defaultRole) {
        this.defaultRole = defaultRole;
    }

    public String getMeasureCaption() {
        return this.measureCaption;
    }

    public void setMeasureCaption(String measureCaption) {
        this.measureCaption = measureCaption;
    }

    public void addMondrianRole(RoleGrantBean bean) {
        this.mondrianRole.add(bean);
    }

    public List<RoleGrantBean> getMondrianRoles() {
        return this.mondrianRole;
    }

    public SecurityGroup findSecurityGroupNamed(String name2) {
        for (SecurityGroup g : this.secGrps) {
            if (!g.getName().equals(name2)) continue;
            return g;
        }
        return null;
    }

    @Override
    public ISchema.SchemaType getSchemaType() {
        for (ICube c : this.getICubes()) {
            if (!c.getFAType().equals("mondrian")) continue;
            return ISchema.SchemaType.MONDRIAN;
        }
        return ISchema.SchemaType.UNITED_OLAP;
    }
}

