/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataObjectItem;
import org.fasd.olap.OLAPElement;

public class OLAPRelation
extends OLAPElement {
    private static int counter = 0;
    private DataObjectItem leftObjectItem;
    private DataObjectItem rightObjectItem;
    private String operator = "=";
    private String leftItemId = "";
    private String rightItemId = "";
    private String leftObjectId = "";
    private String rightObjectId = "";

    public static void resetCounter() {
        counter = 0;
    }

    public OLAPRelation() {
        super("");
        this.id = "l" + String.valueOf(++counter);
    }

    public DataObjectItem getLeftObjectItem() {
        return this.leftObjectItem;
    }

    public void setLeftObjectItem(DataObjectItem leftObjectItem) {
        this.leftObjectItem = leftObjectItem;
    }

    public DataObjectItem getRightObjectItem() {
        return this.rightObjectItem;
    }

    public void setRightObjectItem(DataObjectItem rightObjectItem) {
        this.rightObjectItem = rightObjectItem;
    }

    public DataObject getRightObject() {
        return this.rightObjectItem.getParent();
    }

    public DataObject getLeftObject() {
        return this.leftObjectItem.getParent();
    }

    public void setId(String id) {
        this.id = id;
        int i = Integer.parseInt(id.substring(1));
        if (i > counter) {
            counter = i + 1;
        }
    }

    @Override
    public String getName() {
        if (super.getName().equals("")) {
            return "[" + this.getLeftObject().getName() + "." + this.leftObjectItem.getName() + "] = [" + this.getRightObject().getName() + "." + this.rightObjectItem.getName() + "]";
        }
        return super.getName();
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("        <object-relation-item>\n");
        buf.append("             <id>" + this.getId() + "</id>\n");
        buf.append("             <name>" + this.getName() + "</name>\n");
        buf.append("             <left-object-id>");
        if (this.leftObjectItem != null) {
            buf.append(this.getLeftObject().getId());
        }
        buf.append("</left-object-id>\n");
        buf.append("             <right-object-id>");
        if (this.rightObjectItem != null) {
            buf.append(this.getRightObject().getId());
        }
        buf.append("</right-object-id>\n");
        buf.append("             <relation-formula>\n");
        buf.append("                 <left-object-column-id>");
        if (this.leftObjectItem != null) {
            buf.append(this.leftObjectItem.getId());
        }
        buf.append("</left-object-column-id>\n");
        buf.append("                 <right-object-column-id>");
        if (this.rightObjectItem != null) {
            buf.append(this.rightObjectItem.getId());
        }
        buf.append("</right-object-column-id>\n");
        buf.append("                 <object-columns-relation>" + this.operator + "</object-columns-relation>\n");
        buf.append("             </relation-formula>\n");
        buf.append("        </object-relation-item>\n");
        return buf.toString();
    }

    public String getLeftItemId() {
        return this.leftItemId;
    }

    public void setLeftItemId(String leftItemId) {
        this.leftItemId = leftItemId;
    }

    public String getLeftObjectId() {
        return this.leftObjectId;
    }

    public void setLeftObjectId(String leftObjectId) {
        this.leftObjectId = leftObjectId;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getRightItemId() {
        return this.rightItemId;
    }

    public void setRightItemId(String rightItemId) {
        this.rightItemId = rightItemId;
    }

    public String getRightObjectId() {
        return this.rightObjectId;
    }

    public void setRightObjectId(String rightObjectId) {
        this.rightObjectId = rightObjectId;
    }

    public boolean isUsingTable(DataObject tab) {
        if (this.leftObjectItem == null || this.rightObjectItem == null) {
            return false;
        }
        return this.leftObjectItem.getParent() == tab || this.rightObjectItem.getParent() == tab;
    }

    public boolean isReflexive() {
        if (this.leftObjectItem == null || this.rightObjectItem == null) {
            return false;
        }
        return this.leftObjectItem.getParent() == this.rightObjectItem.getParent();
    }

    public boolean isUsingItem(DataObjectItem item) {
        return this.leftObjectItem == item || this.rightObjectItem == item;
    }
}

