/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import java.util.ArrayList;
import java.util.List;
import org.fasd.olap.OLAPGroup;
import org.fasd.olap.OLAPMeasure;

public class OLAPMeasureGroup
extends OLAPGroup {
    private static int counter = 0;
    private List<OLAPMeasure> mes = new ArrayList<OLAPMeasure>();

    public static void resetCounter() {
        counter = 0;
    }

    public OLAPMeasureGroup() {
        this.setId("f" + String.valueOf(++counter));
    }

    public OLAPMeasureGroup(String n) {
        super(n);
        this.setId("f" + String.valueOf(++counter));
    }

    public void setId(String id) {
        this.id = id;
        int i = Integer.parseInt(id.substring(1));
        if (i > counter) {
            counter = i + 1;
        }
    }

    public void addMeasure(OLAPMeasure m) {
        this.mes.add(m);
    }

    public void removeMes(OLAPMeasure m) {
        this.mes.remove(m);
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("        <Measure-group-item>\n");
        buf.append("            <name>" + this.getName() + "</name>\n");
        buf.append("            <id>" + this.getId() + "</id>\n");
        buf.append("            <description>" + this.getDesc() + "</description>\n");
        buf.append("            <level>" + this.getLevel() + "</level>\n");
        if (this.getParent() != null) {
            buf.append("            <parent-id>" + this.getParent().getId() + "</parent-id>\n");
        } else {
            buf.append("            <parent-id></parent-id>\n");
        }
        buf.append("        </Measure-group-item>\n");
        return buf.toString();
    }

    public List<OLAPMeasure> getMeasures() {
        return this.mes;
    }
}

