/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import bpm.fasd.expressions.api.model.FasdDimension;
import bpm.fasd.expressions.api.model.FasdMeasure;
import bpm.fasd.expressions.api.model.FasdMeasureMdxConverter;
import bpm.fasd.expressions.api.model.FasdParser;
import bpm.studio.expressions.core.measures.impl.Dimension;
import bpm.studio.expressions.core.measures.impl.DimensionLevel;
import bpm.studio.expressions.core.measures.impl.Measure;
import bpm.studio.expressions.core.model.StructureDimension;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.fasd.datasource.DataObjectItem;
import org.fasd.olap.FAModel;
import org.fasd.olap.OLAPDimension;
import org.fasd.olap.OLAPElement;
import org.fasd.olap.OLAPMeasureGroup;

public class OLAPMeasure
extends OLAPElement {
    private static int counter = 0;
    protected String formula = "";
    protected String formatstr = "Standard";
    protected HashMap<String, String> propExpression = new HashMap();
    protected String originId = "";
    protected String columnName = "";
    protected DataObjectItem origin;
    protected DataObjectItem label;
    protected OLAPMeasureGroup group;
    protected String aggregator = "sum";
    protected String desc = "";
    protected String groupId = "";
    protected String type = "physical";
    protected String caption = "";
    protected int order = 0;
    protected boolean visible = true;
    protected String labelId = "";
    protected String dataType = "";
    protected String formatter = "";
    protected String dimensionName = "Measures";
    protected String lastTimeDimensionName;
    protected HashMap<String, String> expression = new HashMap();
    protected String colorScript;

    public static void resetCounter() {
        counter = 0;
    }

    public String getColorScript() {
        return this.colorScript;
    }

    public void setColorScript(String colorScript) {
        this.colorScript = colorScript;
    }

    public String getAggregator() {
        return this.aggregator;
    }

    public void setAggregator(String aggregator) {
        this.aggregator = aggregator;
    }

    public String getLastTimeDimensionName() {
        return this.lastTimeDimensionName;
    }

    public void setLastTimeDimensionName(String lastTimeDimensionName) {
        this.lastTimeDimensionName = lastTimeDimensionName;
    }

    public DataObjectItem getOrigin() {
        return this.origin;
    }

    public void setId(String id) {
        this.id = id;
        int i = Integer.parseInt(id.substring(1));
        if (i > counter) {
            counter = i + 1;
        }
    }

    public void setOrigin(DataObjectItem origin) {
        this.origin = origin;
        if (origin != null) {
            this.originId = origin.getId();
            this.type = "physical";
        } else {
            this.originId = "";
        }
    }

    public String getOriginId() {
        return this.originId;
    }

    public void setOriginId(String originId) {
        this.originId = originId;
        if (!originId.trim().equals("")) {
            this.type = "physical";
        }
    }

    public OLAPMeasure(String name) {
        super(name);
        this.id = "h" + String.valueOf(++counter);
    }

    public OLAPMeasure() {
        super("calculatedMeasure");
        this.id = "h" + String.valueOf(++counter);
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getFormatstr() {
        return this.formatstr;
    }

    public void setFormatstr(String formatstr) {
        this.formatstr = formatstr;
    }

    protected String getXMLForLastAggregator(FAModel faModel, String lastTimeDimensionLevelName) {
        this.aggregator = "sum";
        String baseXml = this.getXML(faModel);
        this.aggregator = "last";
        baseXml = baseXml.replace("visible=\"true\"", "visible=\"false\"").replace(" name=\"" + this.getName(), " name=\"__" + this.getName());
        String buf = String.valueOf(baseXml) + "\n        <CalculatedMember name=\"" + super.getName() + "\" dimension=\"" + this.dimensionName + "\" " + "formula=\"" + "([Measures].[__" + this.getName() + "],ClosingPeriod ( [" + this.lastTimeDimensionName + "].[" + lastTimeDimensionLevelName + "], [" + this.lastTimeDimensionName + "].CurrentMember))";
        buf = !this.caption.trim().equals("") ? String.valueOf(buf) + "\" caption=\"" + this.caption + "\">\n" : String.valueOf(buf) + "\">\n";
        for (String key : this.propExpression.keySet()) {
            String expr = this.propExpression.get(key).replaceAll("<", "&lt;");
            expr = expr.replaceAll(">", "&gt;");
            buf = String.valueOf(buf) + "            <CalculatedMemberProperty name=\"" + key + "\" expression=\"" + expr + "\"" + "/>\n";
        }
        buf = String.valueOf(buf) + "       </CalculatedMember>\n";
        return buf.toString();
    }

    public String getXML(FAModel model) {
        if (this.type.equals("physical")) {
            StringBuffer buf = new StringBuffer();
            buf.append("        <Measure name=\"" + this.getName());
            if (!this.caption.trim().equals("")) {
                buf.append("\" caption=\"" + this.caption);
            }
            if (!this.dataType.trim().equals("")) {
                buf.append("\" datatype=\"" + this.dataType);
            }
            if (!this.formatter.trim().equals("")) {
                buf.append("\" formatter=\"" + this.formatter);
            }
            if (this.origin.getType().equals("physical")) {
                buf.append("\" column=\"");
                if (this.origin != null) {
                    buf.append(this.origin.getOrigin());
                } else {
                    buf.append(this.columnName);
                }
                buf.append("\" aggregator=\"" + this.aggregator);
                buf.append("\" formatString=\"" + this.formatstr);
                if (!this.visible) {
                    buf.append("\" visible=\"false");
                }
                buf.append("\"/>\n");
            } else {
                buf.append("\" aggregator=\"" + this.aggregator);
                buf.append("\" formatString=\"" + this.formatstr);
                if (!this.visible) {
                    buf.append("\" visible=\"false\"");
                }
                if (!this.dataType.trim().equals("")) {
                    buf.append("\" datatype=\"" + this.dataType);
                }
                if (!this.formatter.trim().equals("")) {
                    buf.append("\" formatter=\"" + this.formatter);
                }
                if (!this.visible) {
                    buf.append("\" visible=\"false\"");
                }
                buf.append("\">\n");
                buf.append("            <MeasureExpression>\n");
                buf.append("                <SQL dialect=\"generic\">\n");
                buf.append("                " + this.origin.getOrigin() + "\n");
                buf.append("                </SQL>\n");
                buf.append("            </MeasureExpression>\n");
                for (String key : this.propExpression.keySet()) {
                    String expr = this.propExpression.get(key).replaceAll("<", "&lt;");
                    expr = expr.replaceAll(">", "&gt;");
                    buf.append("            <CalculatedMemberProperty name=\"" + key + "\" expression=\"" + expr + "\"" + "/>\n");
                }
                buf.append("        </Measure>\n");
            }
            return buf.toString();
        }
        String buf = "        <CalculatedMember name=\"" + super.getName() + "\" dimension=\"" + this.dimensionName + "\" " + "formula=\"" + this.formula;
        buf = !this.caption.trim().equals("") ? String.valueOf(buf) + "\" caption=\"" + this.caption + "\">\n" : String.valueOf(buf) + "\">\n";
        for (String key : this.propExpression.keySet()) {
            String expr = this.propExpression.get(key).replaceAll("<", "&lt;");
            expr = expr.replaceAll(">", "&gt;");
            buf = String.valueOf(buf) + "            <CalculatedMemberProperty name=\"" + key + "\" expression=\"" + expr + "\"" + "/>\n";
        }
        if (model != null && this.getColorScript() != null && !this.getColorScript().equals("")) {
            try {
                ArrayList<Dimension> dims = new ArrayList<Dimension>();
                ArrayList<Measure> mes = new ArrayList<Measure>();
                for (OLAPDimension dim : model.getOLAPSchema().getDimensions()) {
                    dims.add(new Dimension((StructureDimension)new FasdDimension(dim)));
                }
                for (OLAPMeasure f : model.getOLAPSchema().getMeasures()) {
                    mes.add(new FasdMeasure(f));
                }
                FasdParser parser = new FasdParser(mes, new ArrayList<DimensionLevel>(), dims);
                ByteArrayInputStream bos = new ByteArrayInputStream(this.getColorScript().getBytes());
                String mdx = FasdMeasureMdxConverter.getOperandMdx(parser.readChunk(bos));
                buf = String.valueOf(buf) + "            <CalculatedMemberProperty name=\"FORMAT_STRING\" expression=\"" + mdx.replace("<", "&lt;").replace(">", "&gt;") + "\"" + "/>\n";
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        buf = String.valueOf(buf) + "       </CalculatedMember>\n";
        return buf;
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("    <Measure-item>\n");
        buf.append("        <id>" + this.getId() + "</id>\n");
        buf.append("        <name>" + this.getName() + "</name>\n");
        buf.append("        <caption>" + this.caption + "</caption>\n");
        buf.append("        <description>" + this.desc + "</description>\n");
        buf.append("        <measure-group-id>" + this.groupId + "</measure-group-id>\n");
        buf.append("        <type>" + this.type + "</type>\n");
        buf.append("        <order>" + this.order + "</order>\n");
        buf.append("        <origin-id>" + this.originId + "</origin-id>\n");
        buf.append("        <formula>" + this.formula + "</formula>\n");
        buf.append("        <label>" + this.labelId + "</label>\n");
        buf.append("        <visible>" + this.visible + "</visible>\n");
        buf.append("        <aggregator>" + this.aggregator + "</aggregator>\n");
        buf.append("        <color-rules><![CDATA[" + this.getColorScript() + "]]></color-rules>\n");
        if (("last".equals(this.aggregator) || "first".equals(this.aggregator)) && this.lastTimeDimensionName != null && !"".equals(this.lastTimeDimensionName)) {
            buf.append("        <lastTimeDimensionName>" + this.lastTimeDimensionName + "</lastTimeDimensionName>\n");
        }
        buf.append("        <formatString>" + this.formatstr + "</formatString>\n");
        for (String s : this.propExpression.keySet()) {
            buf.append("        <property>\n");
            buf.append("            <name>" + s + "</name>\n");
            String expr = this.propExpression.get(s).replaceAll("<", "&lt;");
            expr = expr.replaceAll(">", "&gt;");
            buf.append("            <expression>" + expr + "</expression>\n");
            buf.append("        </property>\n");
        }
        if (!this.type.trim().equals("physical")) {
            buf.append("        <dimensionName>" + this.dimensionName + "</dimensionName>\n");
        }
        buf.append("    </Measure-item>\n");
        return buf.toString();
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getLabelId() {
        return this.labelId;
    }

    public void setLabelId(String labelId) {
        this.labelId = labelId;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        try {
            this.order = Integer.parseInt(order);
        }
        catch (NumberFormatException numberFormatException) {
            this.order = 0;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DataObjectItem getLabel() {
        return this.label;
    }

    public void setLabel(DataObjectItem label) {
        this.label = label;
    }

    public void setGroup(OLAPMeasureGroup g) {
        if (g != null) {
            this.setGroupId(g.getId());
            this.group = g;
        } else {
            this.setGroupId("");
            this.group = null;
        }
        if (this.group != null) {
            this.group.addMeasure(this);
        }
    }

    public OLAPMeasureGroup getGroup() {
        return this.group;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setVisible(String visible) {
        this.visible = Boolean.valueOf(visible);
    }

    public void addExpression(String dialect, String expr) {
        this.expression.put(dialect, expr);
    }

    public HashMap<String, String> getExpressions() {
        return this.expression;
    }

    public HashMap<String, String> getPropertiesExpressions() {
        return this.propExpression;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public void setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    public void addPropExpression(String propName, String propExpression) {
        this.propExpression.put(propName, propExpression);
    }
}

