/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataObjectItem;
import org.fasd.olap.OLAPElement;
import org.fasd.olap.OLAPHierarchy;
import org.fasd.olap.OLAPRelation;
import org.fasd.olap.Property;

public class OLAPLevel
extends OLAPElement {
    public static final String GEOLOCALIZABLE_PROPERTY_NAME = "geolocalizableProperty";
    private static int counter = 0;
    private boolean uniquemb = false;
    private OLAPHierarchy parent;
    private String desc = "";
    private boolean isReal = true;
    private int nb = -1;
    private String columnName = "";
    private String itemId = "";
    private String columnLabelId = "";
    private DataObjectItem item;
    private DataObjectItem label;
    private DataObjectItem itDesc;
    private DataObjectItem sort;
    private DataObject closureTable;
    private DataObjectItem closureParentCol;
    private DataObjectItem closureChildCol;
    private String closureTableId = "";
    private String closureParentId = "";
    private String closureChildId = "";
    private String nullParentValue = "";
    private String tableId = "";
    private String dialect = "";
    private String ordinalColumn = "";
    private DataObjectItem orderItem;
    private String orderItemId;
    private String sql = "";
    private String caption = "";
    private int approxRowCount = 0;
    private String type = "";
    private String levelType = "";
    private String formatter = "";
    private String captionColumn = "";
    private HashMap<String, String> keyExpressions = new HashMap();
    private boolean isOneColumnDate;
    private String dateColumnType;
    private String dateColumnPart;
    private String dateColumnPattern;
    private String dateColumnOrderPart;
    private List<Property> properties = new ArrayList<Property>();

    public static void resetCounter() {
        counter = 0;
    }

    public boolean isOneColumnDate() {
        return this.isOneColumnDate;
    }

    public void setOneColumnDate(boolean isOneColumnDate) {
        this.isOneColumnDate = isOneColumnDate;
    }

    public void setOneColumnDate(String isOneColumnDate) {
        this.isOneColumnDate = Boolean.parseBoolean(isOneColumnDate);
    }

    public String getDateColumnType() {
        return this.dateColumnType;
    }

    public void setDateColumnType(String dateColumnType) {
        this.dateColumnType = dateColumnType;
    }

    public String getDateColumnPart() {
        return this.dateColumnPart;
    }

    public void setDateColumnPart(String dateColumnPart) {
        this.dateColumnPart = dateColumnPart;
    }

    public String getColumnLabelId() {
        if (this.columnLabelId == null && this.label != null) {
            return this.label.getId();
        }
        return this.columnLabelId;
    }

    public void setColumnLabelId(String columnLabelId) {
        this.columnLabelId = columnLabelId;
    }

    public void setId(String id) {
        this.id = id;
        int i = Integer.parseInt(id.substring(1));
        if (i > counter) {
            counter = i + 1;
        }
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getNullParentValue() {
        return this.nullParentValue;
    }

    public void setNullParentValue(String nullParentValue) {
        this.nullParentValue = nullParentValue;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public boolean isReal() {
        return this.isReal;
    }

    public void setReal(boolean isReal) {
        this.isReal = isReal;
    }

    public int getNb() {
        return this.nb;
    }

    public void setNb(int nb) {
        this.nb = nb;
    }

    public void setNb(String nb) {
        this.nb = Integer.parseInt(nb);
    }

    public OLAPHierarchy getParent() {
        return this.parent;
    }

    public void setParent(OLAPHierarchy parent) {
        this.parent = parent;
    }

    public OLAPLevel(String name) {
        super(name);
        this.id = "o" + String.valueOf(++counter);
    }

    public OLAPLevel() {
        super("");
        this.id = "o" + String.valueOf(++counter);
    }

    public boolean isUniquemb() {
        return this.uniquemb;
    }

    public void setUniquemb(boolean uniquemb) {
        this.uniquemb = uniquemb;
    }

    public void setUniquemb(String s) {
        this.uniquemb = Boolean.parseBoolean(s);
    }

    @Override
    public String getFAXML() {
        String buf = "            <Level>\n";
        buf = String.valueOf(buf) + "                <id>" + super.getId() + "</id>\n";
        buf = String.valueOf(buf) + "                <name>" + this.getName() + "</name>\n";
        buf = String.valueOf(buf) + "                <caption>" + this.caption + "</caption>\n";
        if (this.label != null) {
            buf = String.valueOf(buf) + "                <captionColumn>" + this.label.getId() + "</captionColumn>\n";
        } else if (this.captionColumn != null) {
            buf = String.valueOf(buf) + "                <captionColumn>" + this.captionColumn + "</captionColumn>\n";
        }
        buf = String.valueOf(buf) + "                <formatter>" + this.formatter + "</formatter>\n";
        buf = String.valueOf(buf) + "                <type>" + this.type + "</type>\n";
        buf = String.valueOf(buf) + "                <levelType>" + this.levelType + "</levelType>\n";
        if (this.orderItem != null) {
            buf = String.valueOf(buf) + "                <ordinalItemId>" + this.orderItem.getId() + "</ordinalItemId>\n";
        }
        buf = String.valueOf(buf) + "                <ordinalColumn>" + this.ordinalColumn + "</ordinalColumn>\n";
        buf = String.valueOf(buf) + "                <level-nb>" + this.nb + "</level-nb>\n";
        if (this.approxRowCount > 0) {
            buf = String.valueOf(buf) + "                <approxRowCount>" + this.approxRowCount + "</approxRowCount>\n";
        }
        buf = String.valueOf(buf) + "                <hierarchy-parent-id>";
        if (this.parent != null) {
            buf = String.valueOf(buf) + this.parent.getId();
        }
        buf = String.valueOf(buf) + "</hierarchy-parent-id>\n";
        buf = String.valueOf(buf) + "                <description>" + this.desc + "</description>\n";
        buf = String.valueOf(buf) + "                <uniqueMembers>" + this.uniquemb + "</uniqueMembers>\n";
        buf = String.valueOf(buf) + "                <dataobjectitem-code-id>";
        if (this.item != null) {
            buf = String.valueOf(buf) + this.item.getId();
        }
        buf = String.valueOf(buf) + "</dataobjectitem-code-id>\n";
        buf = String.valueOf(buf) + "                <closure-dataobject-id>";
        if (this.closureTable != null) {
            buf = String.valueOf(buf) + this.closureTable.getId();
        }
        buf = String.valueOf(buf) + "</closure-dataobject-id>\n";
        buf = String.valueOf(buf) + "                <closure-parent-dataobjectitem-id>";
        if (this.closureParentCol != null) {
            buf = String.valueOf(buf) + this.closureParentCol.getId();
        }
        buf = String.valueOf(buf) + "</closure-parent-dataobjectitem-id>\n";
        buf = String.valueOf(buf) + "                <closure-child-dataobjectitem-id>";
        if (this.closureChildCol != null) {
            buf = String.valueOf(buf) + this.closureChildCol.getId();
        }
        buf = String.valueOf(buf) + "</closure-child-dataobjectitem-id>\n";
        buf = String.valueOf(buf) + "                <null-parent-value>" + this.nullParentValue + "</null-parent-value>\n";
        for (Property p : this.properties) {
            if (p == null) continue;
            buf = String.valueOf(buf) + p.getFAXML();
        }
        if (this.isOneColumnDate) {
            buf = String.valueOf(buf) + "\t\t\t\t<isOneColumnDate>" + this.isOneColumnDate + "</isOneColumnDate>\n";
            buf = String.valueOf(buf) + "\t\t\t\t<dateColumnType>" + this.dateColumnType + "</dateColumnType>\n";
            buf = String.valueOf(buf) + "\t\t\t\t<dateColumnPart>" + this.dateColumnPart + "</dateColumnPart>\n";
            if (this.dateColumnPattern != null && !this.dateColumnPattern.equals("")) {
                buf = String.valueOf(buf) + "\t\t\t\t<dateColumnPattern>" + this.dateColumnPattern + "</dateColumnPattern>\n";
            }
            if (this.dateColumnOrderPart != null) {
                buf = String.valueOf(buf) + "\t\t\t\t<dateColumnOrderPart>" + this.dateColumnOrderPart + "</dateColumnOrderPart>\n";
            }
        }
        buf = String.valueOf(buf) + "            </Level>\n";
        return buf;
    }

    public String getXML() {
        String buf = "                <Level name=\"" + this.getName() + "\"";
        if (!this.caption.trim().equals("")) {
            buf = String.valueOf(buf) + " caption=\"" + this.caption + "\"";
        }
        if (!this.captionColumn.trim().equals("")) {
            buf = String.valueOf(buf) + " captionColumn=\"" + this.captionColumn + "\"";
        } else if (this.label != null) {
            buf = String.valueOf(buf) + " captionColumn=\"" + this.label.getOrigin() + "\"";
        }
        if (!this.formatter.trim().equals("")) {
            buf = String.valueOf(buf) + " formatter=\"" + this.formatter + "\"";
        }
        if (!this.ordinalColumn.trim().equals("")) {
            buf = String.valueOf(buf) + " ordinalColumn=\"" + this.ordinalColumn + "\"";
        } else if (this.orderItem != null) {
            buf = String.valueOf(buf) + " ordinalColumn=\"" + this.orderItem.getOrigin() + "\"";
        }
        if (!this.type.trim().equals("")) {
            buf = String.valueOf(buf) + " type=\"" + this.type + "\"";
        }
        if (!this.levelType.trim().equals("")) {
            buf = String.valueOf(buf) + " levelType=\"" + this.levelType + "\"";
        }
        if (this.item != null) {
            buf = String.valueOf(buf) + " table=\"" + this.item.getParent().getPhysicalName().substring(this.item.getParent().getPhysicalName().indexOf(".") + 1);
            if (this.item.getParent().getDataSource().getDriver().getSchemaName() != null && !this.item.getParent().getDataSource().getDriver().getSchemaName().trim().equals("")) {
                buf = String.valueOf(buf) + "\" schema=\"" + this.item.getParent().getDataSource().getDriver().getSchemaName();
            }
            if (this.approxRowCount > 0) {
                buf = String.valueOf(buf) + "\" approxRowCount=\"" + this.approxRowCount;
            }
            if (this.item.getType().equals("physical")) {
                buf = String.valueOf(buf) + "\" column=\"" + this.item.getOrigin() + "\" uniqueMembers=\"" + this.uniquemb;
            }
            if (this.item.getType().equals("calculated")) {
                buf = String.valueOf(buf) + "\" uniqueMembers=\"" + this.uniquemb + "\">\n";
                buf = String.valueOf(buf) + "                    <KeyExpression>\n";
                buf = String.valueOf(buf) + "                        <SQL dialect=\"generic\">" + this.item.getOrigin();
                buf = String.valueOf(buf) + "</SQL>\n";
                buf = String.valueOf(buf) + "                    </KeyExpression>\n";
                for (Property p : this.properties) {
                    buf = String.valueOf(buf) + p.getXML();
                }
                buf = String.valueOf(buf) + "                </Level>\n";
            }
        } else {
            buf = String.valueOf(buf) + this.parent.getTableName();
            if (!this.columnName.equals("")) {
                buf = String.valueOf(buf) + " table=\"" + this.parent.getTableName() + "\" column=\"" + this.columnName + "\" uniqueMembers=\"" + this.uniquemb;
            } else {
                buf = String.valueOf(buf) + "\" uniqueMembers=\"" + this.uniquemb + "\">\n";
                buf = String.valueOf(buf) + "                    <KeyExpression>\n";
                for (String s : this.keyExpressions.keySet()) {
                    buf = String.valueOf(buf) + "                        <SQL dialect=\"" + s + "\">" + this.keyExpressions.get(s);
                    buf = String.valueOf(buf) + "</SQL>\n";
                }
                buf = String.valueOf(buf) + "                    </KeyExpression>\n";
                for (Property p : this.properties) {
                    buf = String.valueOf(buf) + p.getXML();
                }
                buf = String.valueOf(buf) + "                </Level>\n";
            }
        }
        if (this.isClosureNeeded()) {
            buf = String.valueOf(buf) + "\" nullParentValue =\"" + this.nullParentValue + "\">\n";
            if (this.closureTable != null) {
                buf = String.valueOf(buf) + "                    <Closure parentColumn=\"";
                if (this.closureParentCol != null) {
                    buf = String.valueOf(buf) + this.closureParentCol.getOrigin();
                }
                buf = String.valueOf(buf) + "\" childColumn=\"";
                if (this.closureChildCol != null) {
                    buf = String.valueOf(buf) + this.closureChildCol.getOrigin();
                }
                buf = String.valueOf(buf) + "\">\n";
                buf = String.valueOf(buf) + "                        <Table name=\"";
                buf = String.valueOf(buf) + this.closureTable.getPhysicalName();
                buf = String.valueOf(buf) + "\"/>\n";
                buf = String.valueOf(buf) + "                     </Closure>\n";
                for (Property p : this.properties) {
                    buf = String.valueOf(buf) + p.getXML();
                }
            }
            buf = String.valueOf(buf) + "                   </Level>\n";
        } else if (this.item != null && this.item.getType().equals("physical")) {
            if (this.properties.size() < 1) {
                buf = String.valueOf(buf) + "\"/>\n";
            } else {
                buf = String.valueOf(buf) + "\">\n";
                for (Property p : this.properties) {
                    buf = String.valueOf(buf) + p.getXML();
                }
                buf = String.valueOf(buf) + "                   </Level>\n";
            }
        }
        return buf;
    }

    public DataObjectItem getItDesc() {
        return this.itDesc;
    }

    public void setItDesc(DataObjectItem itDesc) {
        this.itDesc = itDesc;
    }

    public DataObjectItem getItem() {
        return this.item;
    }

    public void setItem(DataObjectItem item) {
        this.item = item;
        if (item != null) {
            this.itemId = item.getId();
        }
    }

    public DataObjectItem getLabel() {
        return this.label;
    }

    public void setLabel(DataObjectItem label) {
        this.label = label;
    }

    public Property getGeolocalizableProperty() {
        for (Property prop : this.properties) {
            if (!prop.getName().equals(GEOLOCALIZABLE_PROPERTY_NAME)) continue;
            return prop;
        }
        return null;
    }

    public void setGeolocalizableProperty(Property geolocalizableProperty) {
        Property prop = this.getGeolocalizableProperty();
        if (prop != null) {
            this.removeProperty(prop);
        }
        this.addProperty(geolocalizableProperty);
    }

    public DataObjectItem getSort() {
        return this.sort;
    }

    public void setSort(DataObjectItem sort) {
        this.sort = sort;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isClosureNeeded() {
        try {
            OLAPRelation r;
            Iterator<OLAPRelation> iterator = this.getParent().getParent().getParent().getParent().getRelations().iterator();
            do {
                if (iterator.hasNext()) continue;
                if (!this.closureTableId.trim().equals("")) return true;
                return false;
            } while (!(r = iterator.next()).isUsingItem(this.item) || !r.isReflexive());
            return true;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return false;
        }
    }

    public DataObjectItem getClosureChildCol() {
        return this.closureChildCol;
    }

    public void setClosureChildCol(DataObjectItem closureChildCol) {
        this.closureChildCol = closureChildCol;
        this.closureChildId = closureChildCol != null ? closureChildCol.getId() : "";
    }

    public DataObjectItem getClosureParentCol() {
        return this.closureParentCol;
    }

    public void setClosureParentCol(DataObjectItem closureParentCol) {
        this.closureParentCol = closureParentCol;
        this.closureParentId = closureParentCol != null ? closureParentCol.getId() : "";
    }

    public DataObject getClosureTable() {
        return this.closureTable;
    }

    public void setClosureTable(DataObject closureTable) {
        this.closureTable = closureTable;
        this.closureTableId = closureTable != null ? closureTable.getId() : "";
    }

    public String getClosureChildId() {
        return this.closureChildId;
    }

    public void setClosureChildId(String closureChildId) {
        this.closureChildId = closureChildId;
    }

    public String getClosureParentId() {
        return this.closureParentId;
    }

    public void setClosureParentId(String closureParentColId) {
        this.closureParentId = closureParentColId;
    }

    public String getClosureTableId() {
        return this.closureTableId;
    }

    public void setClosureTableId(String closureTableId) {
        this.closureTableId = closureTableId;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void addKeyExpression(String dialect, String sql) {
        this.keyExpressions.put(dialect, sql);
        if (dialect.equals("generic")) {
            this.setSql(sql);
        }
    }

    public HashMap<String, String> getKeyExpressions() {
        return this.keyExpressions;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void addProperty(Property p) {
        if (p != null && !this.properties.contains(p)) {
            this.properties.add(p);
        }
    }

    public void removeProperty(Property p) {
        this.properties.remove(p);
    }

    public int getApproxRowCount() {
        return this.approxRowCount;
    }

    public void setApproxRowCount(int approxRowCount) {
        this.approxRowCount = approxRowCount;
    }

    public void setApproxRowCount(String approxRowCount) {
        this.approxRowCount = Integer.parseInt(approxRowCount);
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getOrdinalColumn() {
        return this.ordinalColumn;
    }

    public void setOrdinalColumn(String ordinalColumn) {
        this.ordinalColumn = ordinalColumn;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    public String getCaptionColumn() {
        return this.captionColumn;
    }

    public void setCaptionColumn(String captionColumn) {
        this.captionColumn = captionColumn;
    }

    public String getFormatter() {
        return this.formatter;
    }

    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public DataObjectItem getOrderItem() {
        return this.orderItem;
    }

    public void setOrderItem(DataObjectItem orderItem) {
        this.orderItem = orderItem;
    }

    public String getOrderItemId() {
        if (this.orderItemId == null && this.orderItem != null) {
            return this.orderItem.getId();
        }
        return this.orderItemId;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
    }

    public void setDateColumnPattern(String dateColumnPattern) {
        this.dateColumnPattern = dateColumnPattern;
    }

    public String getDateColumnPattern() {
        return this.dateColumnPattern;
    }

    public void setDateColumnOrderPart(String dateColumnOrderPart) {
        this.dateColumnOrderPart = dateColumnOrderPart;
    }

    public String getDateColumnOrderPart() {
        return this.dateColumnOrderPart;
    }
}

