/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import java.util.ArrayList;
import java.util.List;
import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataObjectItem;
import org.fasd.datasource.DataView;
import org.fasd.inport.mondrian.beans.InlineBean;
import org.fasd.olap.FAModel;
import org.fasd.olap.Joint;
import org.fasd.olap.OLAPDimension;
import org.fasd.olap.OLAPElement;
import org.fasd.olap.OLAPLevel;
import org.fasd.olap.OLAPRelation;
import org.fasd.olap.Parameter;
import org.fasd.olap.exceptions.HierarchyException;
import org.fasd.utils.ActionGetPath;
import org.fasd.utils.Path;

public class OLAPHierarchy
extends OLAPElement {
    private static int counter = 0;
    private int nbLevel = 0;
    private String allMember = "All";
    private String table = "";
    private String desc = "";
    private String primaryKey = "";
    private String primaryKeyTable = "";
    private String tableName = "";
    private DataObjectItem primaryKeyTableCol;
    private OLAPDimension parent;
    private String caption = "";
    private String allMemberCaption = "";
    private String memberReaderClass = "";
    private InlineBean inlineBean;
    private DataView view;
    private List<Joint> joints = new ArrayList<Joint>();
    private ArrayList<OLAPLevel> lvls = new ArrayList();
    private List<Parameter> params = new ArrayList<Parameter>();

    public static void resetCounter() {
        counter = 0;
    }

    public OLAPHierarchy(String name) {
        super(name);
        this.table = name;
        this.id = "n" + String.valueOf(++counter);
    }

    public OLAPHierarchy() {
        super("");
        this.table = "";
        this.id = "n" + String.valueOf(++counter);
    }

    public void setId(String id) {
        this.id = id;
        int i = Integer.parseInt(id.substring(1));
        if (i > counter) {
            counter = i + 1;
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public void addLevel(OLAPLevel lvl) throws HierarchyException {
        if (this.lvls.size() > 0 && this.lvls.get(0).getClosureTable() != null || this.lvls.size() > 0 && lvl.getClosureChildCol() != null) {
            throw new HierarchyException("Parent Child hierarchy can only hav one level");
        }
        this.lvls.add(lvl);
        if (lvl.getNb() == -1) {
            lvl.setNb(this.nbLevel);
        }
        lvl.setParent(this);
        ++this.nbLevel;
    }

    public void addLevel(int i, OLAPLevel lvl) throws HierarchyException {
        if (this.lvls.size() > 0 && this.lvls.get(0).getClosureChildCol() != null || this.lvls.size() > 0 && lvl.getClosureParentCol() != null) {
            throw new HierarchyException("Parent Child hierarchy can only hav one level");
        }
        if (lvl.getNb() == -1) {
            lvl.setNb(this.nbLevel);
        }
        lvl.setParent(this);
        ++this.nbLevel;
        this.lvls.add(i, lvl);
        int j = i + 1;
        while (j < this.lvls.size()) {
            this.lvls.get(j).setNb(this.lvls.get(j).getNb() + 1);
            ++j;
        }
    }

    public ArrayList<OLAPLevel> getLevels() {
        return this.lvls;
    }

    public String getAllMember() {
        if (this.allMember != null && (this.allMember.isEmpty() || this.allMember.equals("All"))) {
            this.allMember = "All " + this.parent.getName();
        }
        return this.allMember;
    }

    public void setAllMember(String allMember) {
        this.allMember = allMember;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void removeLevel(OLAPLevel level) {
        int i = level.getNb() + 1;
        while (i < this.lvls.size()) {
            OLAPLevel curentL = this.lvls.get(i);
            curentL.setNb(curentL.getNb() - 1);
            ++i;
        }
        --this.nbLevel;
        this.lvls.remove(level);
    }

    @Override
    public String getFAXML() {
        String buf = "        <Hierarchy>\n";
        buf = String.valueOf(buf) + "            <id>" + super.getId() + "</id>\n";
        buf = String.valueOf(buf) + "            <name>" + this.getName() + "</name>\n";
        buf = String.valueOf(buf) + "            <caption>" + this.caption + "</caption>\n";
        buf = String.valueOf(buf) + "            <memberReaderClass>" + this.memberReaderClass + "</memberReaderClass>\n";
        buf = String.valueOf(buf) + "            <allMemberCaption>" + this.allMemberCaption + "</allMemberCaption>\n";
        buf = String.valueOf(buf) + "            <desc>" + this.desc + "</desc>\n";
        buf = String.valueOf(buf) + "            <dimension-id>";
        if (this.parent != null) {
            buf = String.valueOf(buf) + this.parent.getId();
        }
        buf = String.valueOf(buf) + "</dimension-id>\n";
        buf = String.valueOf(buf) + "            <allMember>" + this.allMember + "</allMember>\n";
        int i = 0;
        while (i < this.lvls.size()) {
            buf = String.valueOf(buf) + this.lvls.get(i).getFAXML();
            ++i;
        }
        for (Parameter p : this.params) {
            buf = String.valueOf(buf) + p.getFAXML();
        }
        buf = String.valueOf(buf) + "        </Hierarchy>\n";
        return buf;
    }

    public String buildJoins(Path path, int i) {
        StringBuffer buf = new StringBuffer();
        if (i >= path.size()) {
            return "";
        }
        if (i == path.size() - 1) {
            buf.append("<Join leftKey=\"" + path.getRelationship(i).getLeftObjectItem().getName() + "\" ");
            buf.append("rightKey=\"" + path.getRelationship(i).getRightObjectItem().getName() + "\">\n");
            String tableName = path.getRelationship(0).getLeftObject().getPhysicalName();
            if (tableName.contains(".")) {
                buf.append("                <Table name=\"" + tableName.substring(tableName.indexOf(".") + 1) + "\"");
                buf.append(" schema=\"" + tableName.substring(0, tableName.indexOf(".")) + "\" ");
            } else {
                buf.append("                <Table name=\"" + tableName + "\"");
            }
            buf.append("/>");
            tableName = path.getRelationship(0).getRightObject().getPhysicalName();
            if (tableName.contains(".")) {
                buf.append("                <Table name=\"" + tableName.substring(tableName.indexOf(".") + 1) + "\"");
                buf.append(" schema=\"" + tableName.substring(0, tableName.indexOf(".")) + "\" ");
            } else {
                buf.append("                <Table name=\"" + tableName + "\"");
            }
            buf.append("/>");
            buf.append("</Join>\n");
            return buf.toString();
        }
        buf.append("<Join leftKey=\"" + path.getRelationship(i).getLeftObjectItem().getName() + "\" ");
        buf.append("rightKey=\"" + path.getRelationship(i).getRightObjectItem().getName() + "\" ");
        buf.append("rightAlias=\"" + path.getRelationship(i).getRightObject().getName() + "\">\n");
        String tableName = path.getRelationship(0).getLeftObject().getPhysicalName();
        if (tableName.contains(".")) {
            buf.append("                <Table name=\"" + tableName.substring(tableName.indexOf(".") + 1) + "\"");
            buf.append(" schema=\"" + tableName.substring(0, tableName.indexOf(".")) + "\" ");
        } else {
            buf.append("                <Table name=\"" + tableName + "\"");
        }
        buf.append("/>");
        buf.append(this.buildJoins(path, i + 1));
        buf.append("</Join>\n");
        return buf.toString();
    }

    protected DataObjectItem getForeignKey(DataObject factObject) {
        ArrayList<DataObject> list = new ArrayList<DataObject>();
        list.add(factObject);
        for (OLAPLevel l : this.lvls) {
            if (l.getItem() == null || list.contains(l.getItem().getParent())) continue;
            list.add(l.getItem().getParent());
        }
        if (list.size() > 0) {
            ActionGetPath a = new ActionGetPath(this.getParent().getParent().getParent(), list.toArray(new DataObject[list.size()]));
            a.run();
            Path path = a.getPath();
            if (path.size() > 0) {
                return path.getRelationship(0).getLeftObjectItem();
            }
        }
        return null;
    }

    public String getXML(DataObject factObject) {
        ArrayList<DataObject> list = new ArrayList<DataObject>();
        list.add(factObject);
        for (OLAPLevel l : this.lvls) {
            if (l.getItem() == null || l.getItem().getParent() == null || list.contains(l.getItem().getParent())) continue;
            list.add(l.getItem().getParent());
        }
        ActionGetPath a = new ActionGetPath(this.getParent().getParent().getParent(), list.toArray(new DataObject[list.size()]));
        a.run();
        Path path = null;
        if (list.size() > 1) {
            path = a.getPath();
        }
        String buf = "";
        buf = String.valueOf(buf) + "            <Hierarchy";
        if (!this.getName().trim().equals("")) {
            buf = String.valueOf(buf) + " name=\"" + this.getName() + "\"";
        }
        if (!this.caption.trim().equals("")) {
            buf = String.valueOf(buf) + " caption=\"" + this.caption + "\"";
        }
        if (!this.allMemberCaption.trim().equals("")) {
            buf = String.valueOf(buf) + " allMemberCaption=\"" + this.allMemberCaption + "\"";
        }
        if (!this.memberReaderClass.trim().equals("")) {
            buf = String.valueOf(buf) + " memberReaderClass=\"" + this.memberReaderClass + "\"";
        }
        if (path != null && path.size() > 0 && path.getRelationship(0).getRightObjectItem() != null) {
            buf = String.valueOf(buf) + " primaryKey=\"" + path.getRelationship(0).getRightObjectItem().getOrigin() + "\"";
        } else if (!this.primaryKey.equals("")) {
            buf = String.valueOf(buf) + " primaryKey=\"" + this.primaryKey + "\"";
        }
        if (path != null && path.size() > 1) {
            buf = String.valueOf(buf) + " primaryKeyTable=\"";
            if (path.getRelationship(0).getRightObjectItem() != null) {
                buf = String.valueOf(buf) + path.getRelationship(0).getRightObject().getShortName();
            }
            buf = String.valueOf(buf) + "\">\n";
            buf = String.valueOf(buf) + this.buildJoins(path, 1);
        } else {
            buf = String.valueOf(buf) + ">\n";
            if (path != null && path.size() > 0 && path.getRelationship(0).getRightObject() != null) {
                String tableName;
                if (path.getRelationship(0).getRightObject() == this.getLevels().get(0).getItem().getParent()) {
                    if (!path.getRelationship(0).getRightObject().isInline()) {
                        if (path.getRelationship(0).getRightObject() instanceof DataView) {
                            buf = String.valueOf(buf) + ((DataView)path.getRelationship(0).getRightObject()).getXML();
                        } else {
                            tableName = path.getRelationship(0).getRightObject().getPhysicalName();
                            if (tableName.contains(".")) {
                                buf = String.valueOf(buf) + "                <Table name=\"" + tableName.substring(tableName.indexOf(".") + 1) + "\"";
                                buf = String.valueOf(buf) + " schema=\"" + tableName.substring(0, tableName.indexOf(".")) + "\" ";
                            } else {
                                buf = String.valueOf(buf) + "                <Table name=\"" + tableName + "\"";
                            }
                            buf = String.valueOf(buf) + "/>";
                        }
                    } else {
                        buf = String.valueOf(buf) + path.getRelationship(0).getRightObject().getDatas().getXML();
                    }
                } else if (!path.getRelationship(0).getLeftObject().isInline()) {
                    if (path.getRelationship(0).getLeftObject() instanceof DataView) {
                        buf = String.valueOf(buf) + ((DataView)path.getRelationship(0).getLeftObject()).getXML();
                    } else {
                        tableName = path.getRelationship(0).getLeftObject().getPhysicalName();
                        if (tableName.contains(".")) {
                            buf = String.valueOf(buf) + "                <Table name=\"" + tableName.substring(tableName.indexOf(".") + 1) + "\"";
                            buf = String.valueOf(buf) + " schema=\"" + tableName.substring(0, tableName.indexOf(".")) + "\" ";
                        } else {
                            buf = String.valueOf(buf) + "                <Table name=\"" + tableName + "\"";
                        }
                        buf = String.valueOf(buf) + "/>";
                    }
                } else {
                    buf = String.valueOf(buf) + path.getRelationship(0).getLeftObject().getDatas().getXML();
                }
            } else if (!this.tableName.equals("")) {
                buf = String.valueOf(buf) + "                <Table name=\"" + this.tableName + "\"/>";
            } else if (this.parent.isDegenerated(factObject)) {
                String tname = factObject.getPhysicalName();
                if (tname.contains(".")) {
                    buf = String.valueOf(buf) + "                <Table name=\"" + tname.substring(tname.indexOf(".") + 1) + "\"";
                    buf = String.valueOf(buf) + " schema=\"" + factObject.getPhysicalName().substring(0, factObject.getPhysicalName().indexOf(".")) + "\" ";
                } else {
                    buf = String.valueOf(buf) + "                <Table name=\"" + tname + "\"";
                }
                buf = String.valueOf(buf) + "/>";
            }
            buf = String.valueOf(buf) + "\n";
        }
        int i = 0;
        while (i < this.lvls.size()) {
            buf = String.valueOf(buf) + this.lvls.get(i).getXML();
            ++i;
        }
        for (Parameter p : this.params) {
            buf = String.valueOf(buf) + p.getXML();
        }
        buf = String.valueOf(buf) + "            </Hierarchy>\n";
        return buf;
    }

    public OLAPDimension getParent() {
        return this.parent;
    }

    public void setParent(OLAPDimension parent) {
        this.parent = parent;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<Joint> getJoints() {
        return this.joints;
    }

    public void addJoint(Joint j) {
        this.joints.add(j);
        System.out.println("hiera >> addJoint");
    }

    public String getPrimaryKeyTable() {
        return this.primaryKeyTable;
    }

    public void setPrimaryKeyTable(String primaryKeyTable) {
        this.primaryKeyTable = primaryKeyTable;
    }

    public DataObjectItem getPrimaryKeyTableCol() {
        return this.primaryKeyTableCol;
    }

    public void setPrimaryKeyTableCol(DataObjectItem primaryKeyTableCol) {
        this.primaryKeyTableCol = primaryKeyTableCol;
    }

    public boolean isSnowFlakes() {
        DataObject table = null;
        for (OLAPLevel l : this.lvls) {
            if (table == null) {
                table = l.getItem().getParent();
            }
            if (l.getItem() == null) {
                return false;
            }
            if (l.getItem().getParent() == table) continue;
            return true;
        }
        return false;
    }

    public InlineBean getInlineBean() {
        return this.inlineBean;
    }

    public void setInlineBean(InlineBean inlineBean) {
        this.inlineBean = inlineBean;
    }

    public void setView(DataView view) {
        this.view = view;
    }

    public DataView getView() {
        return this.view;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getAllMemberCaption() {
        return this.allMemberCaption;
    }

    public void setAllMemberCaption(String allMemberCaption) {
        this.allMemberCaption = allMemberCaption;
    }

    public List<Parameter> getParams() {
        return this.params;
    }

    public void addParameter(Parameter p) {
        this.params.add(p);
    }

    public List<OLAPRelation> getPCRelations() {
        ArrayList<OLAPRelation> rel = new ArrayList<OLAPRelation>();
        FAModel model = this.getParent().getParent().getParent();
        for (OLAPLevel l : this.lvls) {
            for (OLAPRelation r : model.getRelations()) {
                if (!r.isReflexive() || !r.isUsingItem(l.getItem())) continue;
                boolean inside = false;
                for (OLAPLevel ll : this.lvls) {
                    if (r.getLeftObjectItem() == l.getItem()) {
                        if (ll.getItem() != r.getRightObjectItem()) continue;
                        inside = true;
                        break;
                    }
                    if (ll.getItem() != r.getLeftObjectItem()) continue;
                    inside = true;
                    break;
                }
                if (!inside) continue;
                rel.add(r);
            }
        }
        return rel;
    }

    public void swapLevels(OLAPLevel l1, OLAPLevel l2) {
        if (this.lvls.contains(l1) && this.lvls.contains(l2)) {
            int i1 = this.lvls.indexOf(l1);
            int i2 = this.lvls.indexOf(l2);
            OLAPLevel tmp = this.lvls.get(i1);
            this.lvls.set(i1, l2);
            this.lvls.set(i2, tmp);
        }
    }

    public String getUniqueName() {
        return "[" + this.parent.getName() + "." + this.getName() + "]";
    }
}

