/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import java.util.ArrayList;
import java.util.List;
import org.fasd.olap.OLAPDimension;
import org.fasd.olap.OLAPGroup;

public class OLAPDimensionGroup
extends OLAPGroup {
    private static int counter = 0;
    private List<OLAPDimension> dim = new ArrayList<OLAPDimension>();

    public static void resetCounter() {
        counter = 0;
    }

    public OLAPDimensionGroup() {
        this.setId("e" + String.valueOf(++counter));
    }

    public OLAPDimensionGroup(String n) {
        super(n);
        this.setId("e" + String.valueOf(++counter));
    }

    public void setId(String id) {
        this.id = id;
        int i = Integer.parseInt(id.substring(1));
        if (i > counter) {
            counter = i + 1;
        }
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("        <Dimension-group-item>\n");
        buf.append("            <name>" + this.getName() + "</name>\n");
        buf.append("            <id>" + this.getId() + "</id>\n");
        buf.append("            <description>" + this.getDesc() + "</description>\n");
        buf.append("            <level>" + this.getLevel() + "</level>\n");
        if (this.getParent() != null) {
            buf.append("            <parent-id>" + this.getParent().getId() + "</parent-id>\n");
        } else {
            buf.append("            <parent-id></parent-id>\n");
        }
        buf.append("        </Dimension-group-item>\n");
        return buf.toString();
    }

    public List<OLAPDimension> getDimensions() {
        return this.dim;
    }

    public void addDimension(OLAPDimension m) {
        this.dim.add(m);
    }

    public void removeDim(OLAPDimension m) {
        this.dim.remove(m);
    }
}

