/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import bpm.connection.manager.connection.ConnectionManager;
import bpm.connection.manager.connection.jdbc.VanillaJdbcConnection;
import bpm.connection.manager.connection.jdbc.VanillaPreparedStatement;
import java.io.FileNotFoundException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataObjectItem;
import org.fasd.datasource.DataSourceConnection;
import org.fasd.olap.OLAPDimensionGroup;
import org.fasd.olap.OLAPElement;
import org.fasd.olap.OLAPHierarchy;
import org.fasd.olap.OLAPLevel;
import org.fasd.olap.OLAPSchema;
import org.fasd.utils.trees.TreeDim;
import org.fasd.utils.trees.TreeHierarchy;
import org.fasd.utils.trees.TreeMember;
import org.fasd.utils.trees.TreeParent;
import xmldesigner.internal.DimensionTree;
import xmldesigner.parse.XMLParser;
import xmldesigner.parse.item.DataXML;
import xmldesigner.xpath.Xpath;

public class OLAPDimension
extends OLAPElement {
    private static int counter = 0;
    public static final String[] LOADING_METHOD = new String[]{"cube_startup", "server_startup", "cube_open", "on_demand"};
    public static int CUBE_STARTUP = 0;
    public static int SERVER_STARTUP = 1;
    public static int CUBE_OPEN = 2;
    public static int ON_DEMAND = 3;
    private ArrayList<OLAPHierarchy> hieras = new ArrayList();
    private String desc = "";
    private String groupId = "";
    private boolean date = false;
    private String loadMethod = "cube_startup";
    private String order = "";
    private String properties = "";
    private String caption = "";
    private String foreignKey = "";
    private boolean geolocalisable = false;
    private OLAPDimensionGroup group;
    private OLAPSchema parent;
    private boolean isOneColumnDate;

    public static void resetCounter() {
        counter = 0;
    }

    public OLAPSchema getParent() {
        return this.parent;
    }

    public void setParent(OLAPSchema parent) {
        this.parent = parent;
    }

    public OLAPDimension() {
        super("");
        this.id = "g" + String.valueOf(++counter);
    }

    public OLAPDimension(String name) {
        super(name);
        this.id = "g" + String.valueOf(++counter);
    }

    public boolean isGeolocalisable() {
        return this.geolocalisable;
    }

    public void setGeolocalisable(boolean geolocalisable) {
        this.geolocalisable = geolocalisable;
    }

    public void setGeolocalisable(String geolocalisable) {
        try {
            this.geolocalisable = Boolean.parseBoolean(geolocalisable);
        }
        catch (Exception exception) {}
    }

    public void addHierarchy(OLAPHierarchy hiera) {
        this.hieras.add(hiera);
        hiera.setParent(this);
    }

    public ArrayList<OLAPHierarchy> getHierarchies() {
        return this.hieras;
    }

    public void removeHierarchy(String name) {
        int i = 0;
        while (i < this.hieras.size()) {
            if (this.hieras.get(i).getName().equals(name)) {
                this.hieras.remove(i);
                break;
            }
            ++i;
        }
    }

    public void setId(String id) {
        this.id = id;
        int i = Integer.parseInt(id.substring(1));
        if (i > counter) {
            counter = i + 1;
        }
    }

    public void removeHierarchy(OLAPHierarchy hiera) {
        this.hieras.remove(hiera);
    }

    public String getXML(DataObject factObject) {
        String buf = "";
        buf = String.valueOf(buf) + "        <Dimension name=\"" + this.getName() + "\"";
        if (!this.caption.trim().equals("")) {
            buf = String.valueOf(buf) + " caption=\"" + this.caption + "\"";
        }
        buf = String.valueOf(buf) + ">\n";
        int i = 0;
        while (i < this.hieras.size()) {
            buf = String.valueOf(buf) + this.hieras.get(i).getXML(factObject);
            ++i;
        }
        buf = String.valueOf(buf) + "        </Dimension>\n";
        return buf;
    }

    public String getUsageXML(DataObject factObject) {
        String buf = "";
        buf = String.valueOf(buf) + "        <DimensionUsage name=\"" + this.getName() + "\" source=\"" + this.getName() + "\"";
        if (this.hieras.get(0) != null && this.hieras.get(0).getForeignKey(factObject) != null) {
            buf = String.valueOf(buf) + " foreignKey=\"" + this.hieras.get(0).getForeignKey(factObject).getOrigin() + "\"";
        } else if (!this.foreignKey.trim().equals("")) {
            buf = String.valueOf(buf) + " foreignKey=\"" + this.foreignKey + "\"";
        } else if (this.isDegenerated(factObject)) {
            buf = String.valueOf(buf) + " foreignKey=\"" + this.hieras.get(0).getLevels().get(0).getItem().getOrigin() + "\"";
        }
        if (!this.caption.trim().equals("")) {
            buf = String.valueOf(buf) + " caption=\"" + this.caption + "\"";
        }
        buf = String.valueOf(buf) + "/>\n";
        return buf;
    }

    public boolean isDegenerated(DataObject factObject) {
        for (OLAPHierarchy h : this.hieras) {
            for (OLAPLevel l : h.getLevels()) {
                if (l.getItem() == null || l.getItem().getParent() == factObject) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getFAXML() {
        String buf = "    <Dimension-item>\n";
        buf = String.valueOf(buf) + "        <id>" + super.getId() + "</id>\n";
        buf = String.valueOf(buf) + "        <name>" + this.getName() + "</name>\n";
        buf = String.valueOf(buf) + "        <caption>" + this.caption + "</caption>\n";
        buf = String.valueOf(buf) + "        <description>" + this.desc + "</description>\n";
        buf = String.valueOf(buf) + "        <dimension-group-id>" + this.groupId + "</dimension-group-id>\n";
        buf = String.valueOf(buf) + "        <IsDate>" + this.date + "</IsDate>\n";
        buf = String.valueOf(buf) + "        <LoadMethod>" + this.loadMethod + "</LoadMethod>\n";
        buf = String.valueOf(buf) + "        <order>" + this.order + "</order>\n";
        buf = String.valueOf(buf) + "        <properties>" + this.properties + "</properties>\n";
        buf = String.valueOf(buf) + "        <geolicalisable>" + this.isGeolocalisable() + "</geolicalisable>\n";
        buf = String.valueOf(buf) + "\t\t<isOneColumnDate>" + this.isOneColumnDate + "</isOneColumnDate>\n";
        int i = 0;
        while (i < this.hieras.size()) {
            buf = String.valueOf(buf) + this.hieras.get(i).getFAXML();
            ++i;
        }
        buf = String.valueOf(buf) + "    </Dimension-item>\n";
        return buf;
    }

    public boolean isDate() {
        return this.date;
    }

    public void setDate(boolean date) {
        this.date = date;
    }

    public void setDate(String isDate) {
        this.date = isDate.contains("Time") ? true : (isDate.contains("Standard") ? false : Boolean.valueOf(isDate));
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getLoadMethod() {
        return this.loadMethod;
    }

    public void setLoadMethod(String loadMethod) {
        this.loadMethod = loadMethod;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void removeFromGroup() {
        this.groupId = "";
    }

    public void setGroup(OLAPDimensionGroup g) {
        if (this.group != null) {
            this.group.removeDim(this);
        }
        if (g != null) {
            this.setGroupId(g.getId());
            this.group = g;
        } else {
            this.setGroupId("");
            this.group = null;
        }
        if (this.group != null) {
            this.group.addDimension(this);
        }
    }

    public OLAPDimensionGroup getGroup() {
        return this.group;
    }

    public String getForeignKey() {
        return this.foreignKey;
    }

    public void setForeignKey(String foreignKey) {
        this.foreignKey = foreignKey;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public TreeParent createModel() {
        TreeParent root = new TreeParent("");
        TreeDim td = new TreeDim(this);
        for (OLAPHierarchy h : this.getHierarchies()) {
            if (h.isSnowFlakes()) {
                return null;
            }
            TreeHierarchy th = new TreeHierarchy(h);
            if (h.getLevels().size() > 0) {
                OLAPLevel l0 = h.getLevels().get(0);
                ArrayList list = new ArrayList();
                try {
                    if (l0.getItem().getParent().getDataSource().getDriver().getType().equals("XML")) {
                        DataSourceConnection sock = l0.getItem().getParent().getDataSource().getDriver();
                        DataObjectItem item = l0.getItem();
                        String url = "file:///" + sock.getTransUrl();
                        XMLParser parser = new XMLParser(url);
                        parser.parser();
                        DataXML dtd = parser.getDataXML();
                        Xpath xpath = new Xpath(sock.getTransUrl(), dtd.getRoot().getElement(0).getName());
                        DimensionTree model = new DimensionTree(dtd);
                        xmldesigner.internal.TreeParent rr = model.createModel();
                        xpath.setListHiera(this.createHiera(rr));
                        xpath.addCol(item.getOrigin());
                        String distinctQuery = "for $i in distinct-values(doc('" + sock.getTransUrl().replace("\\", "/") + "')//" + item.getOrigin() + ")\n";
                        distinctQuery = String.valueOf(distinctQuery) + "return\n";
                        distinctQuery = String.valueOf(distinctQuery) + "<" + dtd.getRoot().getElement(0).getName() + ">\n";
                        distinctQuery = String.valueOf(distinctQuery) + "<" + item.getOrigin() + ">\n";
                        distinctQuery = String.valueOf(distinctQuery) + "{$i}\n";
                        distinctQuery = String.valueOf(distinctQuery) + "</" + item.getOrigin() + ">\n";
                        distinctQuery = String.valueOf(distinctQuery) + "</" + dtd.getRoot().getElement(0).getName() + ">\n";
                        try {
                            xpath.executeXquery(distinctQuery);
                            xpath.modifieSortie();
                            XMLParser pars = new XMLParser("Temp/sortie.xml");
                            pars.parser();
                            DataXML dtd2 = pars.getDataXML();
                            list = xpath.listXquery(dtd2.getRoot());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        String request = "";
                        if (!l0.isClosureNeeded()) {
                            request = "SELECT DISTINCT " + l0.getItem().getOrigin() + " FROM " + l0.getItem().getParent().getPhysicalName();
                        } else {
                            request = "SELECT DISTINCT " + l0.getItem().getOrigin() + " FROM " + l0.getItem().getParent().getPhysicalName();
                            request = String.valueOf(request) + " WHERE " + l0.getClosureParentCol().getName() + "=" + l0.getNullParentValue();
                        }
                        l0.getItem().getParent().getDataSource().getDriver().connectAll();
                        VanillaJdbcConnection con = l0.getItem().getParent().getDataSource().getDriver().getConnection().getConnection();
                        VanillaPreparedStatement stmt = con.createStatement();
                        ResultSet rs = stmt.executeQuery(request);
                        while (rs.next()) {
                            if (rs.getString(1) == null) continue;
                            list.add(rs.getString(1));
                        }
                        rs.close();
                        stmt.close();
                        ConnectionManager.getInstance().returnJdbcConnection(con);
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                for (String s : list) {
                    TreeMember tm = new TreeMember(s, l0);
                    th.addChild(tm);
                    tm.createChilds();
                }
            }
            td.addChild(th);
        }
        root.addChild(td);
        return root;
    }

    private ArrayList<String> createHiera(xmldesigner.internal.TreeParent t) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(t.getName());
        int i = 0;
        while (i < t.getChildren().length) {
            this.add(list, this.createHiera((xmldesigner.internal.TreeParent)t.getChildren(i)));
            ++i;
        }
        return list;
    }

    private List<String> add(List<String> list1, List<String> list2) {
        int i = 0;
        while (i < list2.size()) {
            list1.add(list2.get(i));
            ++i;
        }
        return list1;
    }

    public void setOneColumnDate(boolean isOneColumnDate) {
        this.isOneColumnDate = isOneColumnDate;
    }

    public boolean isOneColumnDate() {
        return this.isOneColumnDate;
    }

    public void setOneColumnDate(String isOneColumnDate) {
        this.isOneColumnDate = Boolean.parseBoolean(isOneColumnDate);
    }
}

