/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataObjectItem;
import org.fasd.datasource.DataSource;
import org.fasd.datasource.DatasourceOda;
import org.fasd.datasource.IConnection;
import org.fasd.olap.CubeView;
import org.fasd.olap.DimUsage;
import org.fasd.olap.Drill;
import org.fasd.olap.ICube;
import org.fasd.olap.ICubeView;
import org.fasd.olap.NamedSet;
import org.fasd.olap.OLAPDimension;
import org.fasd.olap.OLAPDimensionGroup;
import org.fasd.olap.OLAPElement;
import org.fasd.olap.OLAPHierarchy;
import org.fasd.olap.OLAPLevel;
import org.fasd.olap.OLAPMeasure;
import org.fasd.olap.OLAPMeasureGroup;
import org.fasd.olap.OLAPRelation;
import org.fasd.olap.OLAPSchema;
import org.fasd.olap.aggregate.AggPattern;
import org.fasd.olap.aggregate.AggregateTable;
import org.fasd.olap.aggregate.MondrianAgg;
import org.fasd.olap.list.ListDimension;
import org.fasd.olap.list.ListMeasure;
import org.fasd.olap.list.ListSecurityGroup;
import org.fasd.security.SecurityGroup;
import org.fasd.utils.ActionGetPath;
import org.fasd.utils.Path;

public class OLAPCube
extends OLAPElement
implements ICube {
    private static int counter = 0;
    private DataSource dataSource;
    private String factDataObjectId = "";
    private DataObject factDataObject;
    private String description = "";
    private String type = "Rolap";
    private String dataSourceId;
    private String tableName = "";
    private String defaultMeasure = "";
    private boolean enable = true;
    private boolean cache = true;
    private OLAPSchema parent;
    private List<DataObjectItem> listIndex = new ArrayList<DataObjectItem>();
    private List<String> dimIdList = new ArrayList<String>();
    private List<String> mesIdList = new ArrayList<String>();
    private List<String> secuIdList = new ArrayList<String>();
    private List<DimUsage> dimUsages = new ArrayList<DimUsage>();
    private ListSecurityGroup secuList = new ListSecurityGroup();
    private ListMeasure mes = new ListMeasure();
    private ListDimension dims = new ListDimension();
    private HashMap<String, OLAPDimensionGroup> dimGroups = new HashMap();
    private HashMap<String, OLAPMeasureGroup> mesGroups = new HashMap();
    private List<AggregateTable> aggTables = new ArrayList<AggregateTable>();
    private List<String> aggTablesId = new ArrayList<String>();
    private List<MondrianAgg> mondrianAgg = new ArrayList<MondrianAgg>();
    private List<AggPattern> aggPattern = new ArrayList<AggPattern>();
    private List<String> namedSetId = new ArrayList<String>();
    private List<NamedSet> namedSet = new ArrayList<NamedSet>();
    private List<CubeView> cubeViews = new ArrayList<CubeView>();
    private List<Drill> drills = new ArrayList<Drill>();
    private List<String> openedDimensions = new ArrayList<String>();

    public static void resetCounter() {
        counter = 0;
    }

    public OLAPCube(String name, String table) {
        super(name);
        this.factDataObjectId = table;
        this.id = "i" + String.valueOf(++counter);
    }

    public void addOpenedDimension(String dimName) {
        this.openedDimensions.add(dimName);
    }

    public void removeOpenedDimension(String dimName) {
        this.openedDimensions.remove(dimName);
    }

    public void swapDimensions(OLAPDimension d1, OLAPDimension d2) {
        this.dims.swap(d1, d2);
        Integer i1 = null;
        Integer i2 = null;
        int i = 0;
        for (String s : this.openedDimensions) {
            if (s.equals(d1.getName())) {
                i1 = i;
            }
            if (s.equals(d2.getName())) {
                i2 = i;
            }
            ++i;
        }
        if (i1 != null && i2 != null) {
            this.openedDimensions.set(i1, d2.getName());
            this.openedDimensions.set(i2, d1.getName());
        }
    }

    public void addDimUsage(DimUsage du) {
        this.dimUsages.add(du);
    }

    public List<DimUsage> getDimUsages() {
        return this.dimUsages;
    }

    @Override
    public List<Drill> getDrills() {
        return this.drills;
    }

    public void addDrill(Drill d) {
        this.drills.add(d);
    }

    public void removeDrill(Drill d) {
        this.drills.remove(d);
    }

    public OLAPCube() {
        super("");
        this.id = "i" + String.valueOf(++counter);
    }

    public DataObject getFactDataObject() {
        return this.factDataObject;
    }

    public void setId(String id) {
        this.id = id;
        int i = Integer.parseInt(id.substring(1));
        if (i > counter) {
            counter = i + 1;
        }
    }

    public void setFactDataObject(DataObject factTable) {
        this.factDataObject = factTable;
        if (this.factDataObject != null) {
            this.factDataObjectId = factTable.getId();
            this.dataSource = factTable.getDataSource();
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description != null ? description : "";
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type != null ? type : "Rolap";
        if (type.equals("Rolap")) {
            this.dataSource = null;
        }
    }

    public void addDim(OLAPDimension d) {
        if (d != null) {
            this.dims.add(d);
        }
    }

    public List<OLAPDimension> getStartupDimensions() {
        ArrayList<OLAPDimension> l = new ArrayList<OLAPDimension>();
        for (String s : this.openedDimensions) {
            for (OLAPDimension d : this.getDims()) {
                if (!d.getName().equals(s)) continue;
                l.add(d);
            }
        }
        return l;
    }

    public void removeDim(OLAPDimension d) {
        this.dims.remove(d);
        for (String s : this.openedDimensions) {
            if (!d.getName().equals(s)) continue;
            this.openedDimensions.remove(s);
            break;
        }
    }

    public void addDimId(String s) {
        this.dimIdList.add(s);
    }

    public void addSecuId(String s) {
        this.secuIdList.add(s);
    }

    public void addMes(OLAPMeasure m) {
        this.mes.add(m);
    }

    public void removeMes(OLAPMeasure m) {
        this.mes.remove(m);
    }

    public void addMesId(String s) {
        this.mesIdList.add(s);
    }

    public String getXML() {
        ArrayList<OLAPRelation> fk;
        String buf = "    <Cube name=\"" + super.getName() + "\"";
        if (!this.cache) {
            buf = String.valueOf(buf) + " cache=\"false\"";
        }
        if (!this.enable) {
            buf = String.valueOf(buf) + " enable=\"false\"";
        }
        if (!this.defaultMeasure.trim().equals("")) {
            buf = String.valueOf(buf) + " defaultMeasure=\"" + this.defaultMeasure + "\"";
        }
        buf = String.valueOf(buf) + ">\n";
        if (this.factDataObject != null) {
            if (this.factDataObject.isView()) {
                if (this.factDataObject.isView()) {
                    buf = String.valueOf(buf) + "        <View alias=\"" + this.factDataObject.getName() + "\" >\n";
                    buf = String.valueOf(buf) + "            <SQL dialect=\"generic\" >\n";
                    buf = String.valueOf(buf) + "            " + this.factDataObject.getSelectStatement().replace("<", "&lt;") + " \n";
                    buf = String.valueOf(buf) + "            </SQL>\n";
                    buf = String.valueOf(buf) + "        </View>\n";
                }
            } else if (this.aggTables.size() > 0) {
                String string = this.factDataObject.getPhysicalName();
                if (string.contains(".")) {
                    buf = String.valueOf(buf) + "        <Table name=\"" + string.substring(string.indexOf(".") + 1) + "\"";
                    buf = String.valueOf(buf) + " schema=\"" + string.substring(0, string.indexOf(".")) + "\" ";
                } else {
                    buf = String.valueOf(buf) + "        <Table name=\"" + string + "\"";
                }
                buf = String.valueOf(buf) + ">\n";
                for (AggregateTable a : this.aggTables) {
                    fk = new ArrayList();
                    for (OLAPRelation r : this.getParent().getParent().getRelations()) {
                        if (!r.isUsingTable(a.getTable()) || !r.isUsingTable(this.factDataObject)) continue;
                        fk.add(r);
                    }
                    buf = String.valueOf(buf) + a.getXML(fk);
                }
                for (AggPattern p : this.aggPattern) {
                    p.getXML();
                }
                buf = String.valueOf(buf) + "        </Table>\n";
            } else {
                String string = this.factDataObject.getPhysicalName();
                if (string.contains(".")) {
                    buf = String.valueOf(buf) + "        <Table name=\"" + string.substring(string.indexOf(".") + 1) + "\"";
                    buf = String.valueOf(buf) + " schema=\"" + string.substring(0, string.indexOf(".")) + "\" ";
                } else {
                    buf = String.valueOf(buf) + "        <Table name=\"" + string + "\"";
                }
                buf = String.valueOf(buf) + "/>\n";
            }
        } else if (this.aggTables.size() > 0) {
            String string = this.factDataObject.getPhysicalName();
            if (string.contains(".")) {
                buf = String.valueOf(buf) + "        <Table name=\"" + string.substring(string.indexOf(".") + 1) + "\"";
                buf = String.valueOf(buf) + " schema=\"" + string.substring(0, string.indexOf(".")) + "\" ";
            } else {
                buf = String.valueOf(buf) + "        <Table name=\"" + string + "\"";
            }
            buf = String.valueOf(buf) + "/>\n";
            for (AggregateTable a : this.aggTables) {
                fk = new ArrayList<OLAPRelation>();
                for (OLAPRelation r : this.getParent().getParent().getRelations()) {
                    if (!r.isUsingTable(a.getTable()) || !r.isUsingTable(this.factDataObject)) continue;
                    fk.add(r);
                }
                buf = String.valueOf(buf) + a.getXML(fk);
            }
            for (AggPattern p : this.aggPattern) {
                p.getXML();
            }
            buf = String.valueOf(buf) + "        </Table>\n";
        } else {
            buf = String.valueOf(buf) + "        <Table name=\"" + this.tableName + "\"/>\n";
        }
        for (OLAPDimension oLAPDimension : this.dims.getList()) {
            buf = !oLAPDimension.isDegenerated(this.factDataObject) ? String.valueOf(buf) + oLAPDimension.getUsageXML(this.factDataObject) : String.valueOf(buf) + oLAPDimension.getXML(this.factDataObject);
        }
        for (OLAPDimensionGroup oLAPDimensionGroup : this.dimGroups.values()) {
            for (OLAPDimension d : oLAPDimensionGroup.getDimensions()) {
                if (this.isInDimUsage(d)) continue;
                buf = !d.isDegenerated(this.factDataObject) ? String.valueOf(buf) + d.getUsageXML(this.factDataObject) : String.valueOf(buf) + d.getXML(this.factDataObject);
            }
        }
        block13: for (OLAPMeasure oLAPMeasure : this.mes.getList()) {
            if (!oLAPMeasure.getType().equals("physical")) continue;
            if ("last".equals(oLAPMeasure.getAggregator())) {
                for (OLAPDimension d : this.getDims()) {
                    try {
                        if (!d.getName().equals(oLAPMeasure.getLastTimeDimensionName())) continue;
                        OLAPLevel l = d.getHierarchies().get(0).getLevels().get(d.getHierarchies().get(0).getLevels().size() - 1);
                        buf = String.valueOf(buf) + oLAPMeasure.getXMLForLastAggregator(this.getParent().getParent(), l.getName());
                        continue block13;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                continue;
            }
            buf = String.valueOf(buf) + oLAPMeasure.getXML(this.getParent().getParent());
        }
        for (OLAPMeasureGroup oLAPMeasureGroup : this.mesGroups.values()) {
            block16: for (OLAPMeasure m : oLAPMeasureGroup.getMeasures()) {
                if (!m.getType().equals("physical")) continue;
                if ("last".equals(m.getAggregator())) {
                    for (OLAPDimension d : this.getDims()) {
                        try {
                            if (!d.getName().equals(m.getLastTimeDimensionName())) continue;
                            OLAPLevel l = d.getHierarchies().get(0).getLevels().get(d.getHierarchies().get(0).getLevels().size() - 1);
                            buf = String.valueOf(buf) + m.getXMLForLastAggregator(this.getParent().getParent(), l.getName());
                            continue block16;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    continue;
                }
                buf = String.valueOf(buf) + m.getXML(this.getParent().getParent());
            }
        }
        for (OLAPMeasure oLAPMeasure : this.mes.getList()) {
            if (!oLAPMeasure.getType().equals("calculated")) continue;
            buf = String.valueOf(buf) + oLAPMeasure.getXML(this.getParent().getParent());
        }
        for (OLAPMeasureGroup oLAPMeasureGroup : this.mesGroups.values()) {
            for (OLAPMeasure m : oLAPMeasureGroup.getMeasures()) {
                if (!m.getType().equals("calculated")) continue;
                buf = String.valueOf(buf) + m.getXML(this.getParent().getParent());
            }
        }
        for (NamedSet namedSet : this.namedSet) {
            if (namedSet.isGlobal()) continue;
            buf = String.valueOf(buf) + namedSet.getXML();
        }
        buf = String.valueOf(buf) + "    </Cube>\n";
        return buf;
    }

    @Override
    public String getFAXML() {
        String buf = "    <Cube-item>\n";
        buf = String.valueOf(buf) + "        <id>" + super.getId() + "</id>\n";
        buf = String.valueOf(buf) + "        <name>" + super.getName() + "</name>\n";
        buf = String.valueOf(buf) + "        <defaultMeasure>" + this.defaultMeasure + "</defaultMeasure>\n";
        buf = String.valueOf(buf) + "        <enabled>" + this.enable + "</enabled>\n";
        buf = String.valueOf(buf) + "        <cached>" + this.cache + "</cached>\n";
        buf = String.valueOf(buf) + "        <description>" + this.description + "</description>\n";
        buf = String.valueOf(buf) + "        <type>" + this.type + "</type>\n";
        buf = String.valueOf(buf) + "        <fact-dataobject-id>" + this.factDataObjectId + "</fact-dataobject-id>\n";
        buf = String.valueOf(buf) + "        <datasource-id>";
        if (this.dataSource != null) {
            buf = String.valueOf(buf) + this.dataSource.getId();
        }
        buf = String.valueOf(buf) + "</datasource-id>\n";
        for (OLAPDimensionGroup oLAPDimensionGroup : this.dimGroups.values()) {
            buf = String.valueOf(buf) + "        <dimension-group-id>" + oLAPDimensionGroup.getId() + "</dimension-group-id>\n";
        }
        for (OLAPMeasureGroup oLAPMeasureGroup : this.mesGroups.values()) {
            buf = String.valueOf(buf) + "        <measure-group-id>" + oLAPMeasureGroup.getId() + "</measure-group-id>\n";
        }
        for (OLAPDimension oLAPDimension : this.dims.getList()) {
            buf = String.valueOf(buf) + "        <dimension-item-id>" + oLAPDimension.getId() + "</dimension-item-id>\n";
        }
        for (OLAPMeasure oLAPMeasure : this.mes.getList()) {
            buf = String.valueOf(buf) + "        <measure-item-id>" + oLAPMeasure.getId() + "</measure-item-id>\n";
        }
        for (SecurityGroup securityGroup : this.secuList.getList()) {
            buf = String.valueOf(buf) + "        <security-group-item-id>" + securityGroup.getId() + "</security-group-item-id>\n";
        }
        for (AggregateTable aggregateTable : this.aggTables) {
            buf = String.valueOf(buf) + "        <aggregate-item-id>" + aggregateTable.getId() + "</aggregate-item-id>\n";
        }
        for (AggPattern aggPattern : this.aggPattern) {
            aggPattern.getFAXML();
        }
        for (NamedSet namedSet : this.namedSet) {
            buf = String.valueOf(buf) + "        <namedSet-id>" + namedSet.getId() + "</namedSet-id>\n";
        }
        for (CubeView cubeView : this.cubeViews) {
            buf = String.valueOf(buf) + cubeView.getXml();
        }
        for (Drill drill : this.drills) {
            buf = String.valueOf(buf) + drill.getXml();
        }
        for (String string : this.openedDimensions) {
            buf = String.valueOf(buf) + "        <startupDimension>" + string + "</startupDimension>\n";
        }
        if (this.defaultMeasure != null && !"".equals(this.defaultMeasure)) {
            buf = String.valueOf(buf) + "        <defaultMeasure>" + this.defaultMeasure + "</defaultMeasure>\n";
        }
        buf = String.valueOf(buf) + "    </Cube-item>\n";
        return buf;
    }

    public boolean isInDimUsage(OLAPDimension d) {
        for (DimUsage u : this.dimUsages) {
            if (!u.getSource().equals(d.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isInDimId(OLAPDimension d) {
        for (String s : this.dimIdList) {
            if (!s.equals(d.getName())) continue;
            return true;
        }
        return false;
    }

    public List<String> getDimIdList() {
        return this.dimIdList;
    }

    public List<String> getSecuIdList() {
        return this.secuIdList;
    }

    public List<OLAPDimension> getDims() {
        return this.dims.getList();
    }

    public List<OLAPMeasure> getMes() {
        return this.mes.getList();
    }

    public List<String> getMesIdList() {
        return this.mesIdList;
    }

    public String getFactDataObjectId() {
        return this.factDataObjectId;
    }

    public void setFactDataObjectId(String id) {
        this.factDataObjectId = id;
    }

    public void addDimGroup(OLAPDimensionGroup dg) {
        this.dimGroups.put(dg.getId(), dg);
    }

    public void addDimGroup(String gId) {
        this.dimGroups.put(gId, null);
    }

    public void removeDimGroup(OLAPDimensionGroup dg) {
        this.dimGroups.remove(dg.getId());
    }

    public void addMesGroup(OLAPMeasureGroup dg) {
        this.mesGroups.put(dg.getId(), dg);
    }

    public void addMesGroup(String gId) {
        this.mesGroups.put(gId, null);
    }

    public void removeMesGroup(OLAPMeasureGroup dg) {
        this.mesGroups.remove(dg.getId());
    }

    public Set<String> getDimGroupId() {
        return this.dimGroups.keySet();
    }

    public Set<String> getMesGroupId() {
        return this.mesGroups.keySet();
    }

    public Collection<OLAPDimensionGroup> getDimGroups() {
        return this.dimGroups.values();
    }

    public Collection<OLAPMeasureGroup> getMesGroups() {
        return this.mesGroups.values();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public OLAPSchema getParent() {
        return this.parent;
    }

    public void setParent(OLAPSchema parent) {
        this.parent = parent;
    }

    public DataSource getDataSource() {
        if (this.type.equals("Rolap") && this.factDataObject != null) {
            return this.factDataObject.getDataSource();
        }
        if (this.type.equals("Molap")) {
            return this.dataSource;
        }
        return null;
    }

    private HashMap<DataObject, List<DataObjectItem>> findItems() {
        HashMap<DataObject, List<DataObjectItem>> sources = new HashMap<DataObject, List<DataObjectItem>>();
        ArrayList<DataObjectItem> l = new ArrayList<DataObjectItem>();
        for (OLAPMeasure i : this.getMes()) {
            if (i.getOrigin() == null) continue;
            l.add(i.getOrigin());
        }
        sources.put(this.getFactDataObject(), l);
        ArrayList<DataObject> objects = new ArrayList<DataObject>();
        objects.add(this.getFactDataObject());
        for (OLAPDimension d : this.getDims()) {
            for (OLAPHierarchy h : d.getHierarchies()) {
                for (OLAPLevel lvl : h.getLevels()) {
                    if (!objects.contains(lvl.getItem().getParent())) {
                        objects.add(lvl.getItem().getParent());
                    }
                    if (l.contains(lvl.getItem())) continue;
                    l.add(lvl.getItem());
                }
            }
        }
        ActionGetPath a = new ActionGetPath(this.getParent().getParent(), objects.toArray(new DataObject[objects.size()]));
        a.run();
        Path path = a.getPath();
        for (DataObjectItem i : path.getUsedItems()) {
            if (!l.contains(i)) {
                l.add(i);
            }
            if (objects.contains(i.getParent())) continue;
            objects.add(i.getParent());
        }
        for (DataObject o : objects) {
            sources.put(o, new ArrayList());
        }
        for (DataObjectItem i : l) {
            sources.get(i.getParent()).add(i);
            this.listIndex.add(i);
        }
        return sources;
    }

    public void setDataSource(DataSource molapDataSource) {
        this.dataSource = molapDataSource;
        this.dataSourceId = this.dataSource == null ? "" : molapDataSource.getId();
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public void addAggTable(AggregateTable agg) {
        if (!this.aggTables.contains(agg)) {
            this.aggTables.add(agg);
        }
    }

    public void removeAggTable(AggregateTable agg) {
        this.aggTables.remove(agg);
    }

    public List<AggregateTable> getAggTables() {
        return this.aggTables;
    }

    public void addAggtableId(String id) {
        this.aggTablesId.add(id);
    }

    public List<String> getAggTableId() {
        return this.aggTablesId;
    }

    public void addMondrianAgg(MondrianAgg agg) {
        this.mondrianAgg.add(agg);
    }

    public List<MondrianAgg> getMondrianAgg() {
        return this.mondrianAgg;
    }

    public void addNamedSetId(String id) {
        this.namedSetId.add(id);
    }

    public void addNamedSet(NamedSet ns) {
        if (ns != null) {
            this.namedSet.add(ns);
        }
    }

    public List<NamedSet> getNamedSets() {
        return this.namedSet;
    }

    public List<String> getNamedSetsId() {
        return this.namedSetId;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public String getDefaultMeasure() {
        return this.defaultMeasure;
    }

    public void setDefaultMeasure(String defaultMeasure) {
        this.defaultMeasure = defaultMeasure;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setCache(String cache) {
        this.cache = Boolean.parseBoolean(cache);
    }

    public void setEnable(String enable) {
        this.enable = Boolean.parseBoolean(enable);
    }

    public List<AggPattern> getAggPattern() {
        return this.aggPattern;
    }

    public void addAggPattern(AggPattern agg) {
        this.aggPattern.add(agg);
    }

    public OLAPHierarchy findHierarchyNamed(String hiera) {
        for (OLAPDimension d : this.dims.getList()) {
            if (d.getName().equals(hiera) && d.getHierarchies().size() > 0) {
                return d.getHierarchies().get(0);
            }
            for (OLAPHierarchy h : d.getHierarchies()) {
                if (!h.getName().equals(hiera)) continue;
                return h;
            }
        }
        return null;
    }

    @Override
    public IConnection getConnection() {
        if (this.getDataSource() != null) {
            return this.getDataSource().getDriver();
        }
        return null;
    }

    @Override
    public List<ICubeView> getCubeViews() {
        return this.cubeViews;
    }

    public void addCubeView(CubeView view) {
        this.cubeViews.add(view);
    }

    public void removeCubeView(CubeView view) {
        this.cubeViews.remove(view);
    }

    @Override
    public String getFAProvider() {
        return "mondrian";
    }

    @Override
    public String getFAType() {
        if (this.parent.getParent().getDataSources().get(0) instanceof DatasourceOda) {
            return "utdolap";
        }
        return "mondrian";
    }

    public void clearDims() {
        this.dims.clear();
    }
}

