/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import java.util.ArrayList;
import java.util.List;
import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataObjectItem;
import org.fasd.olap.OLAPRelation;

public class Joint {
    private String leftKey = "";
    private String rightKey = "";
    private String rightAlias = "";
    private String leftAlias = "";
    private String tableName = "";
    private DataObjectItem leftCol;
    private DataObjectItem rightCol;
    private DataObject table = new DataObject();
    public static List<DataObject> list = new ArrayList<DataObject>();
    public static List<OLAPRelation> rels = new ArrayList<OLAPRelation>();
    private List<Joint> childs = new ArrayList<Joint>();

    public Joint() {
        System.out.println(">>create Join");
    }

    public String getLeftAlias() {
        return this.leftAlias;
    }

    public void setLeftAlias(String leftAlias) {
        this.leftAlias = leftAlias;
    }

    public void addChild(Joint j) {
        this.childs.add(j);
        System.out.println("Joint >>addChild");
    }

    public String getLeftKey() {
        return this.leftKey;
    }

    public void setLeftKey(String leftKey) {
        this.leftKey = leftKey;
    }

    public String getRightAlias() {
        return this.rightAlias;
    }

    public void setRightAlias(String rightAlias) {
        this.rightAlias = rightAlias;
    }

    public List<Joint> getChilds() {
        return this.childs;
    }

    public String getRightKey() {
        return this.rightKey;
    }

    public void setRightKey(String rightKey) {
        this.rightKey = rightKey;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void buildTables() {
        if (!this.tableName.equals("")) {
            this.table.setName(this.tableName);
            this.table.setDataObjectType("dimension");
            list.add(this.table);
        } else {
            this.leftCol = new DataObjectItem();
            this.leftCol.setOrigin(this.leftKey);
            this.leftCol.setName(this.leftKey);
            this.childs.get((int)0).table.addDataObjectItem(this.leftCol);
            this.childs.get(0).buildTables();
            this.rightCol = new DataObjectItem();
            this.rightCol.setOrigin(this.rightKey);
            this.rightCol.setName(this.rightKey);
            this.childs.get((int)1).table.addDataObjectItem(this.rightCol);
            this.childs.get(1).buildTables();
            if (!this.rightAlias.equals("")) {
                DataObject tr = this.findTable(this.rightAlias);
                if (tr == null) {
                    tr = new DataObject();
                    tr.setDataObjectType("dimension");
                    tr.setName(this.rightAlias);
                    list.add(tr);
                }
                tr.addDataObjectItem(this.rightCol);
            }
            if (!this.leftAlias.equals("")) {
                DataObject tl = this.findTable(this.leftAlias);
                if (tl == null) {
                    tl = new DataObject();
                    tl.setDataObjectType("dimension");
                    tl.setName(this.leftAlias);
                    list.add(tl);
                }
                tl.addDataObjectItem(this.leftCol);
            }
        }
    }

    public void buildAllRelations() {
        this.buildRelation();
        for (Joint j : this.childs) {
            j.buildRelation();
        }
    }

    private void buildRelation() {
        if (!this.tableName.equals("")) {
            return;
        }
        if (this.leftAlias.equals("") && this.rightAlias.equals("")) {
            OLAPRelation r = new OLAPRelation();
            r.setLeftObjectItem(this.findItem(this.childs.get((int)0).table, this.leftKey));
            r.setRightObjectItem(this.findItem(this.childs.get((int)1).table, this.rightKey));
            rels.add(r);
        } else {
            OLAPRelation r;
            if (this.leftAlias.equals("")) {
                r = new OLAPRelation();
                r.setLeftObjectItem(this.findItem(this.childs.get((int)0).table, this.leftKey));
                r.setRightObjectItem(this.findItem(this.findTable(this.rightAlias), this.rightKey));
                rels.add(r);
            }
            if (this.rightAlias.equals("")) {
                r = new OLAPRelation();
                r.setLeftObjectItem(this.findItem(this.childs.get((int)1).table, this.rightKey));
                r.setRightObjectItem(this.findItem(this.findTable(this.leftAlias), this.leftKey));
                rels.add(r);
            }
        }
    }

    public DataObject findTable(String name) {
        for (DataObject o : list) {
            if (!o.getName().equals(name)) continue;
            return o;
        }
        return null;
    }

    private DataObjectItem findItem(DataObject o, String name) {
        for (DataObjectItem i : o.getColumns()) {
            if (!i.getName().equals(name)) continue;
            return i;
        }
        return null;
    }
}

