/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataObjectItem;
import org.fasd.datasource.DataSource;
import org.fasd.datasource.list.ListDataSource;
import org.fasd.datasource.list.ListRelation;
import org.fasd.olap.DocumentProperties;
import org.fasd.olap.ICube;
import org.fasd.olap.OLAPRelation;
import org.fasd.olap.OLAPSchema;
import org.fasd.olap.PreloadConfig;
import org.fasd.security.Security;
import org.fasd.security.SecurityGroup;
import org.fasd.xmla.ISchema;
import org.fasd.xmla.XMLASchema;

public class FAModel
extends Observable {
    private static final String SCHEMA_VERSION = "4.0";
    private ISchema schema;
    private String uuid;
    private DocumentProperties documentProperties = new DocumentProperties();
    private ListDataSource drivers = new ListDataSource();
    private ListRelation relations = new ListRelation();
    private Security security = new Security();
    private String name;
    private int id;
    private boolean isSynchronized = false;
    private List<String> dependancies = new ArrayList<String>();
    private PreloadConfig preloadConfig;

    public void addDependancies(String directoryItemId) {
        this.dependancies.add(directoryItemId);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setId(String id) {
        this.id = Integer.parseInt(id);
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public void setSynchronized(boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }

    public void setSynchronized(String isSynchronized) {
        this.isSynchronized = Boolean.parseBoolean(isSynchronized);
    }

    public FAModel(OLAPSchema schema, String name) throws Exception {
        this.schema = schema;
        this.name = name;
        schema.setParent(this);
    }

    public FAModel() throws Exception {
    }

    public List<DataSource> getDataSources() {
        return this.drivers.getList();
    }

    public void addDataSource(DataSource d) {
        this.drivers.add(d);
    }

    public void removeSQLDriver(String name) {
    }

    public void removeSQLDriver(DataSource d) {
        System.out.println("going to remove...");
        this.drivers.remove(d);
    }

    public OLAPSchema getOLAPSchema() {
        if (this.schema instanceof OLAPSchema) {
            return (OLAPSchema)this.schema;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOLAPSchema(OLAPSchema sch) {
        this.schema = sch;
        ((OLAPSchema)this.schema).setParent(this);
    }

    public DocumentProperties getDocumentProperties() {
        return this.documentProperties;
    }

    public void setDocumentProperties(DocumentProperties docProp) {
        this.documentProperties = docProp;
    }

    public String getFAXML() {
        String tmp = "<freeanalysis-schema>\n";
        tmp = String.valueOf(tmp) + "    <version>4.0</version>\n";
        tmp = String.valueOf(tmp) + "    <id>" + this.id + "</id>\n";
        tmp = String.valueOf(tmp) + "    <isSynchronized>" + this.isSynchronized + "</isSynchronized>\n";
        tmp = String.valueOf(tmp) + this.documentProperties.getFAXML();
        for (String s : this.dependancies) {
            tmp = String.valueOf(tmp) + "    <dependsOf>" + s + "</dependsOf>";
        }
        tmp = String.valueOf(tmp) + "    <datasources>\n";
        int i = 0;
        while (i < this.drivers.getList().size()) {
            tmp = String.valueOf(tmp) + this.drivers.getList().get(i).getFAXML();
            ++i;
        }
        tmp = String.valueOf(tmp) + "    </datasources>\n";
        tmp = String.valueOf(tmp) + "    <object-relation>\n";
        for (OLAPRelation r : this.relations.getList()) {
            tmp = String.valueOf(tmp) + r.getFAXML();
        }
        tmp = String.valueOf(tmp) + "    </object-relation>\n";
        if (this.security != null) {
            tmp = String.valueOf(tmp) + this.security.getFAXML();
        }
        if (this.preloadConfig != null) {
            tmp = String.valueOf(tmp) + this.preloadConfig.getXml();
        }
        tmp = String.valueOf(tmp) + this.schema.getFAXML();
        tmp = String.valueOf(tmp) + "</freeanalysis-schema>\n\n";
        return tmp;
    }

    @Override
    public synchronized void setChanged() {
        super.setChanged();
        this.notifyObservers();
    }

    public DataObjectItem findDataObjectItem(String id) {
        for (DataSource ds : this.drivers.getList()) {
            for (DataObject o : ds.getDataObjects()) {
                for (DataObjectItem i : o.getColumns()) {
                    if (!i.getId().equals(id)) continue;
                    return i;
                }
            }
        }
        return null;
    }

    public DataObject findDataObject(String id) {
        for (DataSource d : this.drivers.getList()) {
            for (DataObject o : d.getDataObjects()) {
                if (!o.getId().equals(id)) continue;
                return o;
            }
        }
        return null;
    }

    public void addRelation(OLAPRelation rel) {
        this.relations.add(rel);
    }

    public void removeRelation(OLAPRelation rel) {
        this.relations.remove(rel);
    }

    public List<OLAPRelation> getRelations() {
        return this.relations.getList();
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public DataSource findDataSource(String id) {
        for (DataSource d : this.drivers.getList()) {
            if (!d.getId().equals(id)) continue;
            return d;
        }
        return null;
    }

    public Security getSecurity() {
        return this.security;
    }

    public ListDataSource getListDataSource() {
        return this.drivers;
    }

    public ListRelation getListRelations() {
        return this.relations;
    }

    public String exportToMondrian() {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\n");
        buf.append(((OLAPSchema)this.schema).getXML());
        return buf.toString();
    }

    public List<ICube> getCubes() {
        return this.schema.getICubes();
    }

    public List<ICube> getCubes(SecurityGroup secu) {
        return ((OLAPSchema)this.schema).getCubes(secu);
    }

    public XMLASchema getXMLASchema() {
        if (this.schema instanceof XMLASchema) {
            return (XMLASchema)this.schema;
        }
        return null;
    }

    public void setXMLASchema(XMLASchema sch) {
        this.schema = sch;
    }

    public ISchema getSchema() {
        return this.schema;
    }

    public void setPreloadConfig(PreloadConfig preloadConfig) {
        this.preloadConfig = preloadConfig;
    }

    public PreloadConfig getPreloadConfig() {
        return this.preloadConfig;
    }
}

