/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import java.util.ArrayList;
import java.util.List;
import org.fasd.olap.Drill;
import org.fasd.olap.DrillReportParameter;

public class DrillReport
extends Drill {
    private String name;
    private int itemId;
    private List<DrillReportParameter> parameters;

    public DrillReport() {
    }

    public DrillReport(int itemId, String name) {
        this.itemId = itemId;
        this.name = name;
    }

    public DrillReport(int itemId, String name, List<DrillReportParameter> parameters) {
        this.itemId = itemId;
        this.name = name;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getItemId() {
        return this.itemId;
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    public List<DrillReportParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<DrillReportParameter>();
        }
        return this.parameters;
    }

    public void setParameters(List<DrillReportParameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(DrillReportParameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<DrillReportParameter>();
        }
        this.parameters.add(parameter);
    }

    @Override
    public String getXml() {
        StringBuilder buf = new StringBuilder();
        buf.append("<drillreport>\n");
        buf.append("\t<name>" + this.drillName + "</name>\n");
        buf.append("\t<item>" + this.itemId + "</item>\n");
        buf.append("\t<reportname>" + this.name + "</reportname>\n");
        buf.append("\t<parameters>\n");
        try {
            for (DrillReportParameter dim : this.parameters) {
                buf.append("\t<parameter>\n");
                buf.append("\t\t<name>" + dim.getName() + "</name>\n");
                buf.append("\t\t<dimension>" + dim.getDimension() + "</dimension>\n");
                buf.append("\t\t<level>" + dim.getLevel() + "</level>\n");
                buf.append("\t</parameter>\n");
            }
        }
        catch (Exception exception) {}
        buf.append("\t</parameters>\n");
        buf.append("</drillreport>\n");
        return buf.toString();
    }

    public void setItemId(String id) {
        this.itemId = Integer.parseInt(id);
    }
}

