/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.olap;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.fasd.olap.OLAPElement;

public class DocumentProperties
extends OLAPElement {
    private String author = "";
    private String description = "";
    private Date creation = new Date();
    private Date modification = new Date();
    private String version = "";

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getCreation() {
        return this.creation;
    }

    public void setCreation(String creation) throws ParseException {
        if (!creation.equals("")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            this.creation = sdf.parse(creation);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getModification() {
        return this.modification;
    }

    public void setModification(String modification) throws ParseException {
        if (!modification.equals("")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            this.modification = sdf.parse(modification);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Deprecated
    public void setFlyOverIconPath(String flyOverIconPath) {
    }

    @Deprecated
    public void setIconPath(String iconPath) {
    }

    @Override
    public String getFAXML() {
        String tmp = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        tmp = String.valueOf(tmp) + "    <document-properties>\n        <name>" + this.getName() + "</name>\n" + "        <author>" + this.author + "</author>\n" + "        <description>" + this.description + "</description>\n" + "        <creation-date>" + sdf.format(this.creation) + "</creation-date>\n" + "        <modification-date>" + sdf.format(this.modification) + "</modification-date>\n" + "        <version>" + this.version + "</version>\n" + "    </document-properties>\n\n";
        return tmp;
    }
}

