/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.inport;

import bpm.studio.jdbc.management.config.IConstants;
import bpm.studio.jdbc.management.model.DriverInfo;
import bpm.studio.jdbc.management.model.ListDriver;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import org.fasd.sql.SQLConnection;

public class ParserPentahoJDBCFile {
    private ArrayList<SQLConnection> listConnection = new ArrayList();
    private String path;
    private boolean parsed = false;

    public ParserPentahoJDBCFile(String path) {
        this.path = path;
    }

    public ArrayList<SQLConnection> getListConnection() throws Exception {
        if (!this.parsed) {
            this.parse();
        }
        return this.listConnection;
    }

    private void parse() throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(this.path));
        String fileDriver = "";
        String dbname = "";
        String type = "";
        String driver = "";
        String url = "";
        String user = "";
        String pwd = "";
        block0: while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") && !line.startsWith(" ")) continue;
            type = line.substring(line.indexOf("/type=") + 6);
            line = reader.readLine();
            fileDriver = line.substring(line.indexOf("/driverFile=") + 12);
            line = reader.readLine();
            driver = line.substring(line.indexOf("/driver=") + 8);
            line = reader.readLine();
            url = line.substring(line.indexOf("/url=") + 5);
            line = reader.readLine();
            user = line.substring(line.indexOf("/user=") + 6);
            line = reader.readLine();
            pwd = line.substring(line.indexOf("/password=") + 10);
            dbname = line.substring(0, line.indexOf("/password="));
            for (DriverInfo d : ListDriver.getInstance((String)IConstants.getJdbcDriverXmlFile()).getDriversInfo()) {
                if (!driver.equals(d.getClassName())) continue;
                fileDriver = d.getFile();
                this.listConnection.add(new SQLConnection(url, user, pwd, fileDriver, driver, dbname, type));
                continue block0;
            }
        }
        reader.close();
    }

    public static void main(String[] arg) throws Exception {
        ParserPentahoJDBCFile parser = new ParserPentahoJDBCFile("c:\\jdbc.properties");
        for (SQLConnection c : parser.getListConnection()) {
            System.out.println("driver " + c.getDriverName());
            System.out.println("driverFile " + c.getDriverFile());
            System.out.println("user " + c.getUser());
            System.out.println("pass " + c.getPass());
            System.out.println("url " + c.getUrl());
            System.out.println("========");
        }
    }
}

