/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.datasource;

import java.util.Map;
import java.util.Properties;
import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataSource;
import org.fasd.datasource.DataSourceConnection;

public class DatasourceOda
extends DataSource {
    private Properties publicProperties = new Properties();
    private Properties privateProperties = new Properties();
    private String odaExtensionId;
    private String odaDatasourceExtensionId;

    public DatasourceOda() {
        DataSourceConnection con = new DataSourceConnection();
        con.setType("oda");
        this.addConnection(con);
    }

    public Properties getPublicProperties() {
        return this.publicProperties;
    }

    public void setPublicProperties(Properties publicProperties) {
        this.publicProperties = publicProperties;
    }

    public Properties getPrivateProperties() {
        return this.privateProperties;
    }

    public void setPrivateProperties(Properties privateProperties) {
        this.privateProperties = privateProperties;
    }

    public String getOdaExtensionId() {
        return this.odaExtensionId;
    }

    public void setOdaExtensionId(String odaExtensionId) {
        this.odaExtensionId = odaExtensionId;
    }

    public String getOdaDatasourceExtensionId() {
        return this.odaDatasourceExtensionId;
    }

    public void setOdaDatasourceExtensionId(String odaDatasourceExtensionId) {
        this.odaDatasourceExtensionId = odaDatasourceExtensionId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("\t<datasource-oda>\n");
        buf.append("\t\t<name>" + this.name + "</name>\n");
        buf.append("\t\t<id>" + this.id + "</id>\n");
        buf.append("\t\t<odadatasourceextensionid>" + this.odaDatasourceExtensionId + "</odadatasourceextensionid>\n");
        buf.append("\t\t<odaextensionid>" + this.odaExtensionId + "</odaextensionid>\n");
        buf.append("\t\t<public-properties>\n");
        for (Object obj : this.publicProperties.keySet()) {
            buf.append("\t\t\t<property><name>" + obj + "</name><value>" + this.publicProperties.get(obj) + "</value></property>\n");
        }
        buf.append("\t\t</public-properties>\n");
        buf.append("\t\t<private-properties>\n");
        for (Object obj : this.privateProperties.keySet()) {
            buf.append("\t\t\t<property><name>" + obj + "</name><value>" + this.privateProperties.get(obj) + "</value></property>\n");
        }
        buf.append("\t\t</private-properties>\n");
        for (Object obj : this.dataObjects) {
            buf.append("\t\t" + ((DataObject)obj).getFAXML());
        }
        buf.append("\t</datasource-oda>\n");
        return buf.toString();
    }

    public void addPublicProperty(String name, String value) {
        if (this.publicProperties == null) {
            this.publicProperties = new Properties();
        }
        this.publicProperties.put(name, value);
    }

    public void addPrivateProperty(String name, String value) {
        if (this.privateProperties == null) {
            this.privateProperties = new Properties();
        }
        this.privateProperties.put(name, value);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (this.publicProperties != null) {
            props.putAll((Map<?, ?>)this.publicProperties);
        }
        if (this.privateProperties != null) {
            props.putAll((Map<?, ?>)this.privateProperties);
        }
        return props;
    }
}

