/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.datasource;

import bpm.connection.manager.connection.ConnectionManager;
import bpm.connection.manager.connection.jdbc.VanillaJdbcConnection;
import bpm.connection.manager.connection.jdbc.VanillaPreparedStatement;
import bpm.studio.jdbc.management.config.IConstants;
import bpm.studio.jdbc.management.model.DriverInfo;
import bpm.studio.jdbc.management.model.ListDriver;
import java.io.FileNotFoundException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataObjectItem;
import org.fasd.datasource.DataSource;
import org.fasd.datasource.IConnection;
import org.fasd.olap.ServerConnection;
import org.fasd.sql.SQLConnection;

public class DataSourceConnection
implements IConnection {
    private static int counter = 0;
    private String id;
    private String name = "";
    private SQLConnection con;
    private VanillaJdbcConnection sock = null;
    private String url = "";
    private String user = "";
    private String pass = "";
    private String driver = "";
    private String driverFile = "";
    private String type = "";
    private String dataSourceLocation = "";
    private String serverId = "";
    private ServerConnection server;
    private String fileLocation = "";
    private String transUrl = "";
    private String description = "";
    private String schemaName = "";
    private DataSource parent;
    private String repositoryUrl = null;
    private String directoryItemId = null;
    private String repositoryDsId = null;

    public static void resetCounter() {
        counter = 0;
    }

    public String getDirectoryItemId() {
        return this.directoryItemId;
    }

    public void setDirectoryItemId(String id) {
        try {
            Integer.parseInt(id);
            this.directoryItemId = id;
        }
        catch (Exception exception) {
            this.directoryItemId = null;
        }
    }

    public DataSource getParent() {
        return this.parent;
    }

    public void setParent(DataSource parent) {
        this.parent = parent;
    }

    public String getDataSourceLocation() {
        return this.dataSourceLocation;
    }

    public void setDataSourceLocation(String dataSourcerLocation) {
        this.dataSourceLocation = dataSourcerLocation;
    }

    public String getDesc() {
        return this.description;
    }

    public void setDesc(String desc) {
        this.description = desc;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public ServerConnection getServer() {
        return this.server;
    }

    public void setServer(ServerConnection server) {
        this.server = server;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getTransUrl() {
        return this.transUrl;
    }

    public void setTransUrl(String transUrl) {
        this.transUrl = transUrl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DataSourceConnection(String name, SQLConnection c) throws ClassNotFoundException {
        this.name = name;
        this.con = c;
        this.id = "a" + String.valueOf(++counter);
    }

    public DataSourceConnection() {
        this.id = "a" + String.valueOf(++counter);
    }

    public void connectAll() throws FileNotFoundException, Exception {
        if (this.driverFile == "" || this.driverFile == null) {
            for (DriverInfo d : ListDriver.getInstance((String)IConstants.getJdbcDriverXmlFile()).getDriversInfo()) {
                if (!d.getClassName().equals(this.driver)) continue;
                this.driverFile = d.getFile();
                break;
            }
        }
        this.con = new SQLConnection(this.url, this.user, this.pass, this.driverFile, this.driver, this.schemaName, "");
        this.sock = this.con.getConnection();
    }

    public void connect() throws FileNotFoundException, Exception {
        this.sock = this.con.getConnection();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SQLConnection getConnection() {
        return this.con;
    }

    public ArrayList<String> getSchemas() throws Exception {
        ArrayList<String> buf = new ArrayList<String>();
        if (this.sock == null) {
            try {
                this.connectAll();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Exception(" Unable to connect to database : " + ex.getMessage(), ex);
            }
        }
        if (this.sock.isClosed()) {
            try {
                this.sock = this.con.getConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(" Unable to connect to database : " + e.getMessage(), e);
            }
        }
        DatabaseMetaData dmd = this.sock.getMetaData();
        ResultSet rs = dmd.getSchemas();
        while (rs.next()) {
            String sName = rs.getString(1);
            if (this.getConnection().getUrl().toLowerCase().contains("jdbc:oracle") && (sName.equalsIgnoreCase("SYS") || sName.equalsIgnoreCase("SYSTEM"))) continue;
            buf.add(sName);
        }
        rs.close();
        return buf;
    }

    public ArrayList<DataObject> getTables(String schemaName) throws FileNotFoundException, Exception {
        ArrayList<DataObject> buf = new ArrayList<DataObject>();
        if (this.sock == null) {
            this.connectAll();
        }
        if (this.sock.isClosed()) {
            try {
                this.sock = this.con.getConnection();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DatabaseMetaData dmd = this.sock.getMetaData();
        System.out.println("product version : " + dmd.getDatabaseProductVersion());
        System.out.println("driver version : " + dmd.getDriverVersion());
        ResultSet res = schemaName != null && schemaName.trim().equals("") ? dmd.getTables(null, schemaName, "%", new String[]{"TABLE", "VIEW"}) : dmd.getTables(null, "%", "%", new String[]{"TABLE", "VIEW"});
        while (res.next()) {
            try {
                String schName = res.getString("TABLE_SCHEM");
                DataObject table = new DataObject(res.getString("TABLE_NAME"));
                System.out.println(table.getName());
                if (table.getName().startsWith("BIN$") || table.getName().startsWith("SYS_IOT")) continue;
                if (schName != null && !"".equals(schName) && !"null".equals(schName)) {
                    table.setSelectStatement("SELECT * FROM " + schName + "." + table.getName());
                } else {
                    table.setSelectStatement("SELECT * FROM " + table.getName());
                }
                VanillaPreparedStatement s = this.sock.createStatement();
                System.out.println(table.getSelectStatement());
                ResultSet r = s.executeQuery(String.valueOf(table.getSelectStatement()) + " WHERE 1=0");
                ResultSetMetaData rsmd = r.getMetaData();
                int i = 1;
                while (i <= rsmd.getColumnCount()) {
                    DataObjectItem it = new DataObjectItem(rsmd.getColumnLabel(i));
                    it.setOrigin(rsmd.getColumnName(i));
                    it.setClasse(rsmd.getColumnClassName(i));
                    it.setSqlType(rsmd.getColumnTypeName(i));
                    table.addDataObjectItem(it);
                    ++i;
                }
                r.close();
                s.close();
                buf.add(table);
                this.getParent().addDataObject(table);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        res.close();
        ConnectionManager.getInstance().returnJdbcConnection(this.sock);
        return buf;
    }

    public DataObject getFactTableFromQuery(String name, String query) throws Exception {
        if (this.sock == null) {
            this.connectAll();
        }
        if (this.sock.isClosed()) {
            try {
                this.sock = this.con.getConnection();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DataObject table = new DataObject();
        table.setSelectStatement(query);
        table.setName(name);
        table.setView(true);
        table.setDataObjectType("fact");
        VanillaPreparedStatement stmt = null;
        ResultSet rs = null;
        stmt = this.sock.createStatement();
        rs = stmt.executeQuery(query);
        ResultSetMetaData rsmd = rs.getMetaData();
        int i = 1;
        while (i <= rsmd.getColumnCount()) {
            DataObjectItem it = new DataObjectItem(rsmd.getColumnLabel(i));
            it.setOrigin(rsmd.getColumnName(i));
            it.setClasse(rsmd.getColumnClassName(i));
            it.setSqlType(rsmd.getColumnTypeName(i));
            table.addDataObjectItem(it);
            ++i;
        }
        rs.close();
        stmt.close();
        return table;
    }

    public String getFAXML() {
        String tmp = "";
        tmp = "            <connection>\n                <name>" + this.name + "</name>\n" + "                <id>" + this.id + "</id>\n" + "                <type>" + this.type + "</type>\n" + "                <data-source-location>" + this.dataSourceLocation + "</data-source-location>\n";
        tmp = this.server != null ? String.valueOf(tmp) + "                <server-id>" + this.server.getId() + "</server-id>\n" : String.valueOf(tmp) + "                <server-id></server-id>\n";
        if (this.repositoryDsId != null && this.repositoryUrl != null) {
            tmp = String.valueOf(tmp) + "                <repositoryDataSourceId>" + this.repositoryDsId + "</repositoryDataSourceId>\n";
            tmp = String.valueOf(tmp) + "                <repositoryUrl>" + this.repositoryUrl + "</repositoryUrl>\n";
        }
        if (this.directoryItemId != null) {
            tmp = String.valueOf(tmp) + "                <directoryItemId>" + this.directoryItemId + "</directoryItemId>\n";
        }
        tmp = String.valueOf(tmp) + "                <driver>" + this.getDriver() + "</driver>\n" + "                <schema-name>" + this.getSchemaName() + "</schema-name>\n" + "                <url>" + this.getUrl() + "</url>\n" + "                <transformation-url>" + this.transUrl + "</transformation-url>\n" + "                <file-location>" + this.fileLocation + "</file-location>\n" + "                <user>" + this.getUser() + "</user>\n" + "                <password>" + this.getPass() + "</password>\n" + "                <description>" + this.description + "</description>\n" + "            </connection>\n";
        return tmp;
    }

    public String getDriver() {
        if (this.driver != null) {
            return this.driver;
        }
        return this.con.getDriverName();
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    @Override
    public String getPass() {
        if (this.pass != null) {
            return this.pass;
        }
        return this.con.getPass();
    }

    @Override
    public void setPass(String pass) {
        this.pass = pass;
    }

    @Override
    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        return this.con.getUrl();
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUser() {
        if (this.user != null) {
            return this.user;
        }
        return this.con.getUser();
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        int i = Integer.parseInt(id.substring(1));
        if (i > counter) {
            counter = i + 1;
        }
    }

    public String getDriverFile() {
        return this.driverFile;
    }

    public void setDriverFile(String driverFile) {
        this.driverFile = driverFile;
    }

    public void setConnection(SQLConnection con2) {
        this.con = con2;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setRepositoryDataSourceId(int id) {
        this.repositoryDsId = "" + id;
    }

    public void setRepositoryDataSourceId(String id) {
        this.repositoryDsId = id;
    }

    public void setRepositoryDataSourceUrl(String host) {
        this.repositoryUrl = host;
    }

    public String getRepositoryDataSourceId() {
        return this.repositoryDsId;
    }

    public String getRepositoryDataSourceUrl() {
        return this.repositoryUrl;
    }
}

