/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.datasource;

import java.util.ArrayList;
import java.util.List;
import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataObjectItem;
import org.fasd.datasource.DataSourceConnection;
import org.fasd.export.IExportable;

public class DataSource
implements IExportable {
    private static int counter = 0;
    protected String id;
    protected String name = "";
    private List<DataSourceConnection> drivers = new ArrayList<DataSourceConnection>();
    private DataSourceConnection defaultConnection;
    private String defaultConnectionId;
    protected ArrayList<DataObject> dataObjects = new ArrayList();

    public static void resetCounter() {
        counter = 0;
    }

    public DataSource(String name, DataSourceConnection driver) {
        this.name = name;
        this.drivers.add(driver);
        this.defaultConnection = driver;
        this.id = "t" + String.valueOf(++counter);
    }

    public DataSource() {
        this.id = "t" + String.valueOf(++counter);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        int i = Integer.parseInt(id.substring(1));
        if (i > counter) {
            counter = i + 1;
        }
    }

    public DataSourceConnection getDriver() {
        if (this.defaultConnectionId != null) {
            for (DataSourceConnection c : this.getDrivers()) {
                if (!c.getId().equals(this.defaultConnectionId)) continue;
                this.setDriver(c);
                this.defaultConnectionId = null;
                break;
            }
        } else if (this.defaultConnection == null && this.getDrivers().size() > 0) {
            this.defaultConnection = this.getDrivers().get(0);
        }
        return this.defaultConnection;
    }

    public List<DataSourceConnection> getDrivers() {
        return new ArrayList<DataSourceConnection>(this.drivers);
    }

    public void setDefaultDriverId(String driverId) {
        this.defaultConnectionId = driverId;
    }

    public boolean addConnection(DataSourceConnection connection) {
        if (connection != null && !this.drivers.contains(connection)) {
            this.drivers.add(connection);
            connection.setParent(this);
            return true;
        }
        return false;
    }

    public boolean removeConnection(DataSourceConnection connection) {
        return this.drivers.remove(connection);
    }

    public void setDSName(String name) {
        this.name = name;
    }

    public void setDriver(DataSourceConnection driver) {
        this.defaultConnection = driver;
        driver.setParent(this);
        this.addConnection(driver);
    }

    public ArrayList<DataObject> getDataObjects() {
        return this.dataObjects;
    }

    public void addDataObject(DataObject tab) {
        this.dataObjects.add(tab);
        tab.setDataSource(this);
    }

    public String getDSName() {
        return this.name;
    }

    @Override
    public String getFAXML() {
        String tmp = "";
        tmp = String.valueOf(tmp) + "        <datasource-item>\n";
        tmp = String.valueOf(tmp) + "            <name>" + this.name + "</name>\n";
        tmp = String.valueOf(tmp) + "            <id>" + this.id + "</id>\n";
        tmp = String.valueOf(tmp) + "            <defaultConnectionId>" + this.getDriver().getId() + "</defaultConnectionId>\n";
        for (DataSourceConnection c : this.getDrivers()) {
            tmp = String.valueOf(tmp) + c.getFAXML();
        }
        int i = 0;
        while (i < this.dataObjects.size()) {
            tmp = String.valueOf(tmp) + this.dataObjects.get(i).getFAXML();
            ++i;
        }
        tmp = String.valueOf(tmp) + "        </datasource-item>\n";
        return tmp;
    }

    public String getXML() {
        return null;
    }

    public boolean containsDataObjectNamed(String tableName) {
        for (DataObject o : this.dataObjects) {
            if (!o.getName().equals(tableName)) continue;
            return true;
        }
        return false;
    }

    public void removeDataObject(DataObject data) {
        this.dataObjects.remove(data);
    }

    public DataObject findDataObjectNamed(String tableName) {
        for (DataObject o : this.dataObjects) {
            if (!o.getName().equalsIgnoreCase(tableName)) continue;
            return o;
        }
        return null;
    }

    public void clear() {
        this.dataObjects.clear();
    }

    public DataObject findDataObject(String id) {
        for (DataObject o : this.dataObjects) {
            if (!o.getId().equals(id)) continue;
            return o;
        }
        return null;
    }

    public DataObjectItem findItemNamed(String origin) {
        for (DataObject o : this.dataObjects) {
            for (DataObjectItem it : o.getColumns()) {
                if (!it.getOrigin().equals(origin)) continue;
                return it;
            }
        }
        return null;
    }

    public void refreshAggregateTables() {
        for (DataObject d : this.dataObjects) {
            try {
                d.fillTableInDataBase();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

