/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.datasource;

import java.util.Properties;
import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataObjectItem;
import org.fasd.datasource.DatasourceOda;

public class DataObjectOda
extends DataObject {
    private Properties publicProperties = new Properties();
    private Properties privateProperties = new Properties();
    private String queryText;
    private String odaDatasetExtensionId;

    public DataObjectOda() {
    }

    public DataObjectOda(DatasourceOda con) {
        this.dataSource = con;
    }

    public Properties getPublicProperties() {
        return this.publicProperties;
    }

    public void setPublicProperties(Properties publicProperties) {
        this.publicProperties = publicProperties;
    }

    public Properties getPrivateProperties() {
        return this.privateProperties;
    }

    public void setPrivateProperties(Properties privateProperties) {
        this.privateProperties = privateProperties;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public String getOdaDatasetExtensionId() {
        return this.odaDatasetExtensionId;
    }

    public void setOdaDatasetExtensionId(String odaDatasetExtensionId) {
        this.odaDatasetExtensionId = odaDatasetExtensionId;
    }

    @Override
    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<dataobject-oda>\n");
        buf.append("\t\t\t\t<id>" + this.getId() + "</id>\n");
        buf.append("\t\t\t\t<name>" + this.name + "</name>\n");
        buf.append("\t\t\t\t<data-source-id>" + this.dataSource.getId() + "</data-source-id>\n");
        buf.append("\t\t\t\t<datasetextensionid>" + this.odaDatasetExtensionId + "</datasetextensionid>\n");
        buf.append("\t\t\t\t<public-properties>\n");
        for (Object obj : this.publicProperties.keySet()) {
            buf.append("\t\t\t\t\t<property><name>" + obj + "</name><value>" + this.publicProperties.get(obj) + "</value></property>\n");
        }
        buf.append("\t\t\t\t</public-properties>\n");
        buf.append("\t\t\t\t<private-properties>\n");
        for (Object obj : this.privateProperties.keySet()) {
            buf.append("\t\t\t\t\t<property><name>" + obj + "</name><value>" + this.privateProperties.get(obj) + "</value></property>\n");
        }
        buf.append("\t\t\t\t</private-properties>\n");
        buf.append("\t\t\t\t<querytext><![CDATA[" + this.queryText + "]]></querytext>\n");
        buf.append("\t\t\t\t<dataobjecttype>" + this.dataObjectType + "</dataobjecttype>\n");
        int i = 0;
        while (i < this.items.size()) {
            buf.append(((DataObjectItem)this.items.get(i)).getFAXML());
            ++i;
        }
        buf.append("</dataobject-oda>\n");
        return buf.toString();
    }
}

