/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.datasource;

import bpm.connection.manager.connection.ConnectionManager;
import bpm.connection.manager.connection.jdbc.VanillaJdbcConnection;
import bpm.connection.manager.connection.jdbc.VanillaPreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.fasd.datasource.DataInline;
import org.fasd.datasource.DataObjectItem;
import org.fasd.datasource.DataSource;
import org.fasd.olap.ServerConnection;

public class DataObject {
    private static int counter = 0;
    public static String[] TYPES = new String[]{"dimension", "fact", "label", "closure", "aggregate"};
    private int positionX = 10;
    private int positionY = 10;
    private String id;
    protected String name;
    protected DataSource dataSource;
    private String serverId = "";
    private ServerConnection server;
    protected String dataObjectType = "";
    private String selectStatement = "";
    private String transName = "";
    private String fileName = "";
    private String desc = "";
    private String creationStatement = null;
    private String fillingStatement = null;
    private boolean isInline = false;
    private DataInline datas;
    private boolean isView = false;
    protected ArrayList<DataObjectItem> items = new ArrayList();

    public static void resetCounter() {
        counter = 0;
    }

    public DataObject(String name) {
        this.name = name;
        this.id = "c" + String.valueOf(++counter);
    }

    public DataObject() {
        this.id = "c" + String.valueOf(++counter);
    }

    public boolean isView() {
        return this.isView;
    }

    public void setView(boolean isView) {
        this.isView = isView;
    }

    public void setView(String isView) {
        this.isView = Boolean.parseBoolean(isView);
    }

    public void setItems(ArrayList<DataObjectItem> items) {
        this.items = items;
    }

    public void addDataObjectItem(DataObjectItem item) {
        for (DataObjectItem i : this.items) {
            if (!i.getOrigin().equals(item.getOrigin())) continue;
            return;
        }
        item.setParent(this);
        this.items.add(item);
    }

    public ArrayList<DataObjectItem> getColumns() {
        return this.items;
    }

    public String getId() {
        return this.id;
    }

    public String getFAXML() {
        String tmp = "";
        tmp = String.valueOf(tmp) + "            <dataobject-item>\n";
        tmp = String.valueOf(tmp) + "            \t<id>" + this.getId() + "</id>\n";
        tmp = String.valueOf(tmp) + "                <name>" + this.name + "</name>\n";
        tmp = String.valueOf(tmp) + "                <data-source-id>" + this.dataSource.getId() + "</data-source-id>\n";
        tmp = String.valueOf(tmp) + "                <server-id>" + this.serverId + "</server-id>\n";
        tmp = String.valueOf(tmp) + "                <data-object-type>" + this.dataObjectType + "</data-object-type>\n";
        tmp = String.valueOf(tmp) + "                <positionX>" + this.positionX + "</positionX>\n";
        tmp = String.valueOf(tmp) + "                <positionY>" + this.positionY + "</positionY>\n";
        String statementFormated = this.selectStatement.replace('<', '#');
        statementFormated = statementFormated.replace('>', '#');
        tmp = String.valueOf(tmp) + "                <isView>" + this.isView() + "</isView>\n";
        tmp = String.valueOf(tmp) + "                <select-statment-definition>" + statementFormated + "</select-statment-definition>\n";
        tmp = String.valueOf(tmp) + "                <transformation-name>" + this.transName + "</transformation-name>\n";
        tmp = String.valueOf(tmp) + "                <file-name>" + this.fileName + "</file-name>\n";
        tmp = String.valueOf(tmp) + "                <description>" + this.desc + "</description>\n";
        tmp = String.valueOf(tmp) + "                <isInline>" + this.isInline + "</isInline>\n";
        if (this.creationStatement != null) {
            tmp = String.valueOf(tmp) + "                <creationStatement>" + this.creationStatement + "</creationStatement>\n";
        }
        if (this.fillingStatement != null) {
            tmp = String.valueOf(tmp) + "                <fillingStatement>" + this.fillingStatement + "</fillingStatement>\n";
        }
        int i = 0;
        while (i < this.items.size()) {
            tmp = String.valueOf(tmp) + this.items.get(i).getFAXML();
            ++i;
        }
        if (this.isInline) {
            tmp = String.valueOf(tmp) + this.datas.getFAXML();
        }
        tmp = String.valueOf(tmp) + "            </dataobject-item>\n";
        return tmp;
    }

    public void setId(String id) {
        this.id = id;
        int i = Integer.parseInt(id.substring(1));
        if (i > counter) {
            counter = i + 1;
        }
    }

    public String getDataObjectType() {
        return this.dataObjectType;
    }

    public void setDataObjectType(String dataObjectType) {
        this.dataObjectType = dataObjectType;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSelectStatement() {
        return this.selectStatement;
    }

    public void setSelectStatement(String selectStatement) {
        StringTokenizer st = new StringTokenizer(selectStatement, "#");
        String result = "";
        int i = 0;
        while (st.hasMoreElements()) {
            result = String.valueOf(result) + st.nextToken();
            if (i % 2 == 0 && st.hasMoreElements()) {
                result = String.valueOf(result) + "<";
                ++i;
                continue;
            }
            if (i % 2 != 1) continue;
            result = String.valueOf(result) + ">";
            ++i;
        }
        this.selectStatement = result;
    }

    public ServerConnection getServer() {
        return this.server;
    }

    public void setServer(ServerConnection server) {
        this.server = server;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getTransName() {
        return this.transName;
    }

    public void setTransName(String transName) {
        this.transName = transName;
    }

    public String getPhysicalName() {
        try {
            return this.selectStatement.substring(this.selectStatement.indexOf(" FROM ") + 6, this.selectStatement.length());
        }
        catch (Exception exception) {
            return this.name;
        }
    }

    public String getShortName() {
        if (this.getDataSource() != null && this.selectStatement.contains(".")) {
            return this.selectStatement.substring(this.selectStatement.lastIndexOf(".") + 1, this.selectStatement.length());
        }
        return this.getPhysicalName();
    }

    public boolean isClosure() {
        return this.dataObjectType.equals("closure");
    }

    public DataObjectItem findItemNamed(String primaryKey) {
        for (DataObjectItem i : this.items) {
            if (!i.getName().equals(primaryKey)) continue;
            return i;
        }
        return null;
    }

    public void removeItem(DataObjectItem i) {
        this.items.remove(i);
    }

    public void buildSelectStatement() {
        String buf = "SELECT ";
        boolean first = true;
        for (DataObjectItem i : this.items) {
            if (first) {
                first = !first;
                buf = String.valueOf(buf) + i.getOrigin();
                continue;
            }
            buf = String.valueOf(buf) + ", " + i.getOrigin();
        }
        this.selectStatement = buf = String.valueOf(buf) + " FROM " + this.getPhysicalName();
    }

    public boolean isInline() {
        return this.isInline;
    }

    public void setInline(boolean isInline) {
        this.isInline = isInline;
    }

    public void setInline(String isInline) {
        this.isInline = Boolean.parseBoolean(isInline);
    }

    public void setDatas(DataInline datas) {
        this.datas = datas;
        datas.setDataObject(this);
    }

    public DataInline getDatas() {
        return this.datas;
    }

    public String getCreationStatement() {
        return this.creationStatement;
    }

    public void setCreationStatement(String creationStatement) {
        this.creationStatement = creationStatement;
    }

    public String getFillingStatement() {
        return this.fillingStatement;
    }

    public void setFillingStatement(String fillingStatement) {
        this.fillingStatement = fillingStatement;
    }

    public void createTableInDataBase() throws Exception {
        if (this.creationStatement == null) {
            throw new Exception("The creationStatement is not set");
        }
        VanillaJdbcConnection c = null;
        VanillaPreparedStatement stmt = null;
        try {
            this.dataSource.getDriver().connectAll();
            c = this.dataSource.getDriver().getConnection().getConnection();
            stmt = c.createStatement();
            stmt.executeQuery(this.creationStatement);
        }
        catch (Throwable throwable) {
            if (stmt != null) {
                stmt.close();
            }
            if (c != null) {
                ConnectionManager.getInstance().returnJdbcConnection(c);
            }
            throw throwable;
        }
        if (stmt != null) {
            stmt.close();
        }
        if (c != null) {
            ConnectionManager.getInstance().returnJdbcConnection(c);
        }
    }

    public void fillTableInDataBase() throws Exception {
        if (this.fillingStatement == null) {
            throw new Exception("This statement for refreshing datas is not set");
        }
        VanillaJdbcConnection c = null;
        VanillaPreparedStatement stmt = null;
        try {
            try {
                this.dataSource.getDriver().connectAll();
                c = this.dataSource.getDriver().getConnection().getConnection();
                stmt = c.createStatement();
                System.out.println("execute SQL : truncate " + this.getPhysicalName());
                stmt.executeQuery("delete from " + this.getPhysicalName());
                System.out.println("execute SQL : " + this.fillingStatement);
                stmt.executeQuery(this.fillingStatement);
            }
            catch (SQLException e1) {
                throw e1;
            }
            catch (Exception e1) {
                throw e1;
            }
        }
        catch (Throwable throwable) {
            if (stmt != null) {
                stmt.close();
            }
            if (c != null) {
                ConnectionManager.getInstance().returnJdbcConnection(c);
            }
            throw throwable;
        }
        if (stmt != null) {
            stmt.close();
        }
        if (c != null) {
            ConnectionManager.getInstance().returnJdbcConnection(c);
        }
    }

    public int getPositionX() {
        return this.positionX;
    }

    public void setPositionX(int positionX) {
        this.positionX = positionX;
    }

    public void setPositionX(String positionX) {
        try {
            this.positionX = Integer.parseInt(positionX);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public int getPositionY() {
        return this.positionY;
    }

    public void setPositionY(int positionY) {
        this.positionY = positionY;
    }

    public void setPositionY(String positionY) {
        try {
            this.positionY = Integer.parseInt(positionY);
        }
        catch (NumberFormatException numberFormatException) {}
    }
}

