/*
 * Decompiled with CFR 0.152.
 */
package org.fasd.datasource;

import java.util.ArrayList;
import java.util.List;
import org.fasd.datasource.DataObject;
import org.fasd.datasource.DataObjectItem;
import org.fasd.datasource.DataRow;

public class DataInline {
    private List<DataRow> datas = new ArrayList<DataRow>();
    private DataObject table;
    private String tableId = "";

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public void setDataObject(DataObject table) {
        this.table = table;
    }

    public DataObject getDataObject() {
        return this.table;
    }

    public void addRow(DataRow row) {
        this.datas.add(row);
    }

    public void removeRow(DataRow row) {
        this.datas.remove(row);
    }

    public String getFAXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("        <inline-datas>\n");
        for (DataRow r : this.datas) {
            buf.append(r.getFAXML());
        }
        buf.append("        </inline-datas>\n");
        return buf.toString();
    }

    public String getXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("                <InlineTable alias=\"" + this.table.getName() + "\">\n");
        buf.append("                    <ColumnDefs>\n");
        for (DataObjectItem i : this.table.getColumns()) {
            buf.append("                        <ColumnDef name=\"" + i.getName() + "\" type=\"" + i.getSqlType() + "\"/>\n");
        }
        buf.append("                    </ColumnDefs>\n");
        buf.append("                    <Rows>\n");
        for (DataRow d : this.datas) {
            buf.append(d.getXML());
        }
        buf.append("                    </Rows>\n");
        buf.append("                </InlineTable>\n");
        return buf.toString();
    }

    public List<DataRow> getRows() {
        return this.datas;
    }
}

