/*
 * Decompiled with CFR 0.152.
 */
package bpm.fm.oda.driver.ui.impl;

import bpm.fm.api.IFreeMetricsManager;
import bpm.fm.api.RemoteFreeMetricsManager;
import bpm.fm.api.model.Theme;
import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.platform.core.beans.User;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceWizardPage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FreeMetricsDatasourcePage
extends DataSourceWizardPage {
    private Text url;
    private Text login;
    private Text password;
    private ComboViewer groupNames;
    private ComboViewer themes;
    private IFreeMetricsManager manager;
    private RemoteVanillaPlatform vanillaApi;
    private int groupId;
    private int themeId;

    public FreeMetricsDatasourcePage(String pageName) {
        super(pageName);
    }

    public Properties collectCustomProperties() {
        Properties props = new Properties();
        props.setProperty("fmGroupId", String.valueOf(this.groupId));
        props.setProperty("fmLogin", this.login.getText());
        props.setProperty("freemetricsPassword", this.password.getText());
        props.setProperty("fmThemeId", String.valueOf(this.themeId));
        props.setProperty("fmUrl", this.url.getText());
        return props;
    }

    public void createPageCustomControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Label l3 = new Label(parent, 0);
        l3.setLayoutData((Object)new GridData(1, 2, false, false));
        l3.setText("Url");
        this.url = new Text(parent, 2048);
        this.url.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Login");
        this.login = new Text(parent, 2048);
        this.login.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label l2 = new Label(parent, 0);
        l2.setLayoutData((Object)new GridData(1, 2, false, false));
        l2.setText("Password");
        this.password = new Text(parent, 0x400800);
        this.password.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Button conRep = new Button(parent, 8);
        conRep.setText("Load group and themes");
        conRep.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        conRep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FreeMetricsDatasourcePage.this.connect(-1, -1);
            }
        });
        Label l7 = new Label(parent, 0);
        l7.setLayoutData((Object)new GridData(1, 2, false, false));
        l7.setText("Group");
        this.groupNames = new ComboViewer(parent, 8);
        this.groupNames.getCombo().setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.groupNames.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.groupNames.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Group)element).getName();
            }
        });
        this.groupNames.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                block4: {
                    Group group = (Group)((IStructuredSelection)event.getSelection()).getFirstElement();
                    FreeMetricsDatasourcePage.this.groupId = group.getId();
                    try {
                        List ths = FreeMetricsDatasourcePage.this.manager.getThemesByGroup(FreeMetricsDatasourcePage.this.groupId);
                        FreeMetricsDatasourcePage.this.themes.setInput((Object)ths);
                        if (FreeMetricsDatasourcePage.this.themeId > 0) {
                            for (Theme th : ths) {
                                if (th.getId() != FreeMetricsDatasourcePage.this.themeId) continue;
                                FreeMetricsDatasourcePage.this.themes.setSelection((ISelection)new StructuredSelection((Object)th));
                                break block4;
                            }
                            break block4;
                        }
                        FreeMetricsDatasourcePage.this.themeId = ((Theme)ths.get(0)).getId();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        l7 = new Label(parent, 0);
        l7.setLayoutData((Object)new GridData(1, 2, false, false));
        l7.setText("Theme");
        this.themes = new ComboViewer(parent, 8);
        this.themes.getCombo().setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.themes.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.themes.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Theme)element).getName();
            }
        });
        this.themes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Theme group = (Theme)((IStructuredSelection)event.getSelection()).getFirstElement();
                FreeMetricsDatasourcePage.this.themeId = group.getId();
            }
        });
    }

    public void setInitialProperties(Properties props) {
        String propUrl = props.getProperty("fmUrl");
        String propLogin = props.getProperty("fmLogin");
        String propPass = props.getProperty("freemetricsPassword");
        int propGrp = Integer.parseInt(props.getProperty("fmGroupId"));
        int propTheme = Integer.parseInt(props.getProperty("fmThemeId"));
        this.url.setText(propUrl);
        this.login.setText(propLogin);
        this.password.setText(propPass);
        if (!(propUrl == null || propUrl.isEmpty() || propLogin == null || propLogin.isEmpty() || propPass == null || propPass.isEmpty())) {
            this.connect(propGrp, propTheme);
        }
    }

    private void connect(int propGrp, int propTheme) {
        this.manager = new RemoteFreeMetricsManager(this.url.getText(), this.login.getText(), this.password.getText());
        this.vanillaApi = new RemoteVanillaPlatform(this.url.getText(), this.login.getText(), this.password.getText());
        User user = null;
        try {
            user = this.vanillaApi.getVanillaSecurityManager().authentify("", this.login.getText(), this.password.getText(), false);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        List groups = null;
        try {
            groups = this.vanillaApi.getVanillaSecurityManager().getGroups(user);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.groupNames.setInput((Object)groups);
        if (propGrp > -1) {
            if (propTheme > -1) {
                this.themeId = propTheme;
            }
            this.groupId = propGrp;
            for (Group g : groups) {
                if (g.getId() != propGrp) continue;
                this.groupNames.setSelection((ISelection)new StructuredSelection((Object)g));
                break;
            }
        } else {
            this.groupId = ((Group)groups.get(0)).getId();
        }
    }
}

