/*
 * Decompiled with CFR 0.152.
 */
package bpm.fm.oda.driver.ui.impl;

import bpm.fm.api.model.Axis;
import bpm.fm.api.model.Metric;
import bpm.fm.oda.driver.Activator;
import bpm.fm.oda.driver.impl.Driver;
import bpm.fm.oda.driver.impl.QueryParser;
import bpm.freemetrics.api.manager.IManager;
import bpm.freemetrics.api.manager.client.FmClientAccessor;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FreeMetricsDatasetPage
extends DataSetWizardPage {
    private Button btnSelectMetric;
    private Button btnParamMetric;
    private Button btnSelectAxe;
    private Button btnParamAxe;
    private Button btnSelectDate;
    private Button btnParamDate;
    private Button chkParamDate;
    private Button chkParamMetric;
    private Button chkParamAxe;
    private ComboViewer cbMetric;
    private ComboViewer cbAxe;
    private Text txtDateStart;
    private Text txtDateEnd;
    private Text txtDatePattern;
    private FmClientAccessor fmClient;

    public FreeMetricsDatasetPage(String pageName) {
        super(pageName);
    }

    public void createPageCustomControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout());
        root.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createMetricPart(root);
        this.createAxePart(root);
        this.createDatePart(root);
        try {
            this.initData();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("An error occured while loading the data : " + e.getMessage()));
            e.printStackTrace();
        }
        this.setControl((Control)root);
    }

    private void initData() throws Exception {
        Properties connProps = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
        String fmLogin = connProps.getProperty("fmLogin");
        String fmPass = connProps.getProperty("freemetricsPassword");
        this.fmClient = FmClientAccessor.getClient((IManager)Activator.getDefault().getFmManager(), (String)fmLogin, (String)fmPass, (String)connProps.getProperty("fmUrl"));
        try {
            int groupId = Integer.parseInt(connProps.getProperty("fmGroupId"));
            int themeId = Integer.parseInt(connProps.getProperty("fmThemeId"));
            this.fmClient.setGroupId(groupId);
            this.fmClient.setThemeId(themeId);
        }
        catch (Exception exception) {}
        this.cbAxe.setInput((Object)this.fmClient.getAxis());
        this.cbMetric.setInput((Object)this.fmClient.getMetrics());
        try {
            DataSetDesign dataSetDesign = this.getInitializationDesign();
            if (dataSetDesign == null) {
                return;
            }
            String queryText = dataSetDesign.getQueryText();
            if (queryText == null || queryText.equals("")) {
                return;
            }
            QueryParser parser = new QueryParser(queryText);
            parser.parse();
            SimpleDateFormat sdf = new SimpleDateFormat(parser.getDateFormat());
            if (parser.getStartDate() != null) {
                this.txtDateStart.setText(sdf.format(parser.getStartDate()));
            }
            if (parser.getEndDate() != null) {
                this.txtDateEnd.setText(sdf.format(parser.getEndDate()));
            }
            for (Object a : (List)this.cbAxe.getInput()) {
                if (((Axis)a).getId() != parser.getApplicationId()) continue;
                this.cbAxe.setSelection((ISelection)new StructuredSelection(a), true);
                break;
            }
            for (Object obss : (List)this.cbMetric.getInput()) {
                Metric obs = (Metric)obss;
                if (obs.getId() != parser.getMetricId()) continue;
                this.cbMetric.setSelection((ISelection)new StructuredSelection((Object)obs), true);
                break;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void createDatasetPart(Composite root) {
        Group grpParameters = new Group(root, 0);
        grpParameters.setLayout((Layout)new GridLayout(1, false));
        grpParameters.setLayoutData((Object)new GridData(4, 4, true, false));
        grpParameters.setText("Param\u00c3\u00a8tres");
        this.chkParamDate = new Button((Composite)grpParameters, 32);
        this.chkParamDate.setLayoutData((Object)new GridData(4, 4, true, false));
        this.chkParamDate.setText("G\u00c3\u00a9n\u00c3\u00a9rer le jeu de donn\u00c3\u00a9es de dates");
        this.chkParamDate.setEnabled(false);
        this.chkParamAxe = new Button((Composite)grpParameters, 32);
        this.chkParamAxe.setLayoutData((Object)new GridData(4, 4, true, false));
        this.chkParamAxe.setText("G\u00c3\u00a9n\u00c3\u00a9rer le jeu de donn\u00c3\u00a9es des axes");
        this.chkParamAxe.setEnabled(false);
        this.chkParamMetric = new Button((Composite)grpParameters, 32);
        this.chkParamMetric.setLayoutData((Object)new GridData(4, 4, true, false));
        this.chkParamMetric.setText("G\u00c3\u00a9n\u00c3\u00a9rer le jeu de donn\u00c3\u00a9es des indicateurs");
        this.chkParamMetric.setEnabled(false);
    }

    private void createDatePart(Composite root) {
        Group grpDate = new Group(root, 0);
        grpDate.setLayout((Layout)new GridLayout(3, false));
        grpDate.setLayoutData((Object)new GridData(4, 4, true, false));
        grpDate.setText("Date");
        this.btnSelectDate = new Button((Composite)grpDate, 16);
        this.btnSelectDate.setLayoutData((Object)new GridData(4, 4, false, false));
        this.btnSelectDate.setText("Choix de la date");
        this.btnSelectDate.setSelection(true);
        this.btnSelectDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FreeMetricsDatasetPage.this.txtDateStart.setEnabled(true);
                FreeMetricsDatasetPage.this.txtDateEnd.setEnabled(true);
            }
        });
        this.txtDateStart = new Text((Composite)grpDate, 2048);
        this.txtDateStart.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label lblDate = new Label((Composite)grpDate, 0);
        lblDate.setLayoutData((Object)new GridData(4, 4, false, false));
        lblDate.setText(" End Date :");
        this.txtDateEnd = new Text((Composite)grpDate, 2048);
        this.txtDateEnd.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.btnParamDate = new Button((Composite)grpDate, 16);
        this.btnParamDate.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.btnParamDate.setText("Date en tant que param\u00e8tre");
        this.btnParamDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FreeMetricsDatasetPage.this.txtDateStart.setEnabled(false);
                FreeMetricsDatasetPage.this.txtDateEnd.setEnabled(false);
            }
        });
        Label lblDatePattern = new Label((Composite)grpDate, 0);
        lblDatePattern.setLayoutData((Object)new GridData(4, 4, false, false));
        lblDatePattern.setText("Format de date");
        this.txtDatePattern = new Text((Composite)grpDate, 2048);
        this.txtDatePattern.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.txtDatePattern.setText("yyyy-MM-dd");
    }

    private void createAxePart(Composite root) {
        Group grpAxe = new Group(root, 0);
        grpAxe.setLayout((Layout)new GridLayout(2, false));
        grpAxe.setLayoutData((Object)new GridData(4, 4, true, false));
        grpAxe.setText("Axe");
        this.btnSelectAxe = new Button((Composite)grpAxe, 16);
        this.btnSelectAxe.setLayoutData((Object)new GridData(4, 4, false, false));
        this.btnSelectAxe.setText("Choisir un axe");
        this.btnSelectAxe.setSelection(true);
        this.btnSelectAxe.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FreeMetricsDatasetPage.this.cbAxe.getCombo().setEnabled(true);
            }
        });
        this.cbAxe = new ComboViewer((Composite)grpAxe, 2052);
        this.cbAxe.getCombo().setLayoutData((Object)new GridData(4, 4, true, false));
        this.cbAxe.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Axis m = (Axis)element;
                return m.getName();
            }
        });
        this.cbAxe.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.btnParamAxe = new Button((Composite)grpAxe, 16);
        this.btnParamAxe.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.btnParamAxe.setText("Axe en tant que param\u00e8tre");
        this.btnParamAxe.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FreeMetricsDatasetPage.this.cbAxe.getCombo().setEnabled(false);
            }
        });
    }

    private void createMetricPart(Composite root) {
        Group grpMetric = new Group(root, 0);
        grpMetric.setLayout((Layout)new GridLayout(2, false));
        grpMetric.setLayoutData((Object)new GridData(4, 4, true, false));
        grpMetric.setText("Indicateur");
        this.btnSelectMetric = new Button((Composite)grpMetric, 16);
        this.btnSelectMetric.setLayoutData((Object)new GridData(4, 4, false, false));
        this.btnSelectMetric.setText("Choisir un indicateur");
        this.btnSelectMetric.setSelection(true);
        this.btnSelectMetric.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FreeMetricsDatasetPage.this.cbMetric.getCombo().setEnabled(true);
            }
        });
        this.cbMetric = new ComboViewer((Composite)grpMetric, 2052);
        this.cbMetric.getCombo().setLayoutData((Object)new GridData(4, 4, true, false));
        this.cbMetric.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Metric m = (Metric)element;
                return m.getName();
            }
        });
        this.cbMetric.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.btnParamMetric = new Button((Composite)grpMetric, 16);
        this.btnParamMetric.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.btnParamMetric.setText("Indicateur en tant que param\u00e8tre");
        this.btnParamMetric.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FreeMetricsDatasetPage.this.cbMetric.getCombo().setEnabled(false);
            }
        });
    }

    private String getQueryText() {
        IStructuredSelection ss;
        StringBuffer buf = new StringBuffer();
        buf.append("<queryAssoc>\n");
        if (this.btnParamAxe.getSelection()) {
            buf.append("<fmApplicationAsParameter>" + this.btnParamAxe.getSelection() + "</fmApplicationAsParameter>\n");
        } else {
            ss = (IStructuredSelection)this.cbAxe.getSelection();
            Axis app = (Axis)ss.getFirstElement();
            buf.append("<fmApplicationAsParameter>" + this.btnParamAxe.getSelection() + "</fmApplicationAsParameter>\n");
            buf.append("<fmApplicationId>" + app.getId() + "</fmApplicationId>\n");
        }
        if (this.btnParamMetric.getSelection()) {
            buf.append("<fmMetricAsParameter>" + this.btnParamMetric.getSelection() + "</fmMetricAsParameter>\n");
        } else {
            ss = (IStructuredSelection)this.cbMetric.getSelection();
            Metric met = (Metric)ss.getFirstElement();
            buf.append("<fmMetricAsParameter>" + this.btnParamMetric.getSelection() + "</fmMetricAsParameter>\n");
            buf.append("<fmMetricId>" + met.getId() + "</fmMetricId>\n");
        }
        if (this.btnParamDate.getSelection()) {
            buf.append("<dateAsParameter>" + this.btnParamDate.getSelection() + "</dateAsParameter>\n");
        } else {
            String dateStart = this.txtDateStart.getText();
            String dateEnd = this.txtDateEnd.getText();
            buf.append("<dateStart>" + dateStart + "</dateStart>\n");
            buf.append("<dateEnd>" + dateEnd + "</dateEnd>\n");
            buf.append("<dateAsParameter>" + this.btnParamDate.getSelection() + "</dateAsParameter>\n");
        }
        buf.append("<dateFormat>" + this.txtDatePattern.getText() + "</dateFormat>\n");
        if (this.btnParamDate.getSelection()) {
            buf.append("<generateDateDataset>" + this.btnParamDate.getSelection() + "</generateDateDataset>\n");
        }
        if (this.btnParamAxe.getSelection()) {
            buf.append("<generateAxeDataset>" + this.btnParamAxe.getSelection() + "</generateAxeDataset>\n");
        }
        if (this.btnParamMetric.getSelection()) {
            buf.append("<generateMetricDataset>" + this.btnParamMetric.getSelection() + "</generateMetricDataset>\n");
        }
        buf.append("</queryAssoc>\n");
        return buf.toString();
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        this.savePage(design);
        return design;
    }

    private void savePage(DataSetDesign dataSetDesign) {
        block5: {
            String queryText = this.getQueryText();
            dataSetDesign.setQueryText(queryText);
            IConnection customConn = null;
            try {
                try {
                    Driver customDriver = new Driver();
                    customConn = customDriver.getConnection(null);
                    Properties connProps = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
                    customConn.open(connProps);
                    this.updateDesign(dataSetDesign, customConn, queryText);
                }
                catch (OdaException e) {
                    dataSetDesign.setResultSets(null);
                    dataSetDesign.setParameters(null);
                    e.printStackTrace();
                    this.closeConnection(customConn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(customConn);
                throw throwable;
            }
            this.closeConnection(customConn);
        }
    }

    private void updateDesign(DataSetDesign dataSetDesign, IConnection conn, String queryText) throws OdaException {
        IQuery query = conn.newQuery(null);
        query.prepare(queryText);
        try {
            IResultSetMetaData md = query.getMetaData();
            this.updateResultSetDesign(md, dataSetDesign);
        }
        catch (OdaException e) {
            dataSetDesign.setResultSets(null);
            e.printStackTrace();
        }
        try {
            IParameterMetaData paramMd = query.getParameterMetaData();
            this.updateParameterDesign(paramMd, dataSetDesign);
        }
        catch (OdaException ex) {
            dataSetDesign.setParameters(null);
            ex.printStackTrace();
        }
    }

    private void updateResultSetDesign(IResultSetMetaData md, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private void updateParameterDesign(IParameterMetaData paramMd, DataSetDesign dataSetDesign) throws OdaException {
        ParameterDefinition paramDef;
        DataSetParameters paramDesign = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)paramMd, (ParameterMode)DesignSessionUtil.toParameterModeDesign((int)1));
        dataSetDesign.setParameters(paramDesign);
        if (paramDesign == null) {
            return;
        }
        paramDesign.setDerivedMetaData(true);
        if (paramDesign.getParameterDefinitions().size() > 0 && (paramDef = (ParameterDefinition)paramDesign.getParameterDefinitions().get(0)) != null) {
            paramDef.setDefaultScalarValue("dummy default value");
        }
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }
}

