/*
 * Decompiled with CFR 0.152.
 */
package bpm.fm.oda.driver.ui.impl;

import bpm.fm.api.model.Axis;
import bpm.fm.api.model.Metric;
import bpm.fm.oda.driver.Activator;
import bpm.fm.oda.driver.impl.Driver;
import bpm.fm.oda.driver.impl.QueryHelper;
import bpm.freemetrics.api.manager.IManager;
import bpm.freemetrics.api.manager.client.FmClientAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DatasetPage
extends DataSetWizardPage {
    private CheckboxTableViewer metricTable;
    private CheckboxTableViewer axisTable;
    private DateTime startDate;
    private DateTime endDate;
    private Button chkDateParam;
    private FmClientAccessor fmClient;

    public DatasetPage(String pageName) {
        super(pageName);
    }

    public void createPageCustomControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout());
        root.setLayoutData((Object)new GridData(4, 4, true, true));
        Group grpMetric = new Group(root, 0);
        grpMetric.setLayout((Layout)new GridLayout());
        grpMetric.setLayoutData((Object)new GridData(4, 4, true, false));
        grpMetric.setText("Indicateur");
        this.metricTable = new CheckboxTableViewer((Composite)grpMetric, 0);
        this.metricTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.metricTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Metric)element).getName();
            }
        });
        this.metricTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        Group grpAxis = new Group(root, 0);
        grpAxis.setLayout((Layout)new GridLayout());
        grpAxis.setLayoutData((Object)new GridData(4, 4, true, false));
        grpAxis.setText("Axe");
        this.axisTable = new CheckboxTableViewer((Composite)grpAxis, 0);
        this.axisTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.axisTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Axis)element).getName();
            }
        });
        this.axisTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        Group grpDate = new Group(root, 0);
        grpDate.setLayout((Layout)new GridLayout(3, false));
        grpDate.setLayoutData((Object)new GridData(4, 4, true, false));
        grpDate.setText("Date");
        this.startDate = new DateTime((Composite)grpDate, 1024);
        this.startDate.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblDate = new Label((Composite)grpDate, 0);
        lblDate.setLayoutData((Object)new GridData(4, 4, false, false));
        lblDate.setText(" -> ");
        this.endDate = new DateTime((Composite)grpDate, 1024);
        this.endDate.setLayoutData((Object)new GridData(4, 4, true, false));
        this.chkDateParam = new Button((Composite)grpDate, 32);
        this.chkDateParam.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.chkDateParam.setText("Date as parameter");
        try {
            this.initData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setControl((Control)root);
    }

    private void initData() throws Exception {
        Properties connProps = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
        String fmLogin = connProps.getProperty("fmLogin");
        String fmPass = connProps.getProperty("freemetricsPassword");
        this.fmClient = FmClientAccessor.getClient((IManager)Activator.getDefault().getFmManager(), (String)fmLogin, (String)fmPass, (String)connProps.getProperty("fmUrl"));
        try {
            int groupId = Integer.parseInt(connProps.getProperty("fmGroupId"));
            int themeId = Integer.parseInt(connProps.getProperty("fmThemeId"));
            this.fmClient.setGroupId(groupId);
            this.fmClient.setThemeId(themeId);
        }
        catch (Exception exception) {}
        List metrics = this.fmClient.getMetrics();
        List axis = this.fmClient.getAxis();
        this.metricTable.setInput((Object)metrics);
        this.axisTable.setInput((Object)axis);
        try {
            DataSetDesign dataSetDesign = this.getInitializationDesign();
            if (dataSetDesign == null) {
                return;
            }
            String queryText = dataSetDesign.getQueryText();
            if (queryText == null || queryText.equals("")) {
                return;
            }
            QueryHelper helper = new QueryHelper(this.fmClient);
            helper.parseQueryXml(queryText);
            this.metricTable.setCheckedElements(helper.getMetrics().toArray());
            this.axisTable.setCheckedElements(helper.getAxes().toArray());
            this.startDate.setDate(helper.getStartDate().getYear() + 1900, helper.getStartDate().getMonth(), helper.getStartDate().getDate());
            if (helper.getEndDate() != null) {
                this.endDate.setDate(helper.getEndDate().getYear() + 1900, helper.getEndDate().getMonth(), helper.getEndDate().getDate());
            }
            this.chkDateParam.setSelection(helper.isDateAsParameter());
        }
        catch (Exception exception) {}
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        block7: {
            ArrayList<Metric> selectedMetric = new ArrayList<Metric>();
            Object[] objectArray = this.metricTable.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                selectedMetric.add((Metric)o);
                ++n2;
            }
            ArrayList<Axis> selectedAxis = new ArrayList<Axis>();
            Object[] objectArray2 = this.axisTable.getCheckedElements();
            int n3 = objectArray2.length;
            n = 0;
            while (n < n3) {
                Object o = objectArray2[n];
                selectedAxis.add((Axis)o);
                ++n;
            }
            int day = this.startDate.getDay();
            int month = this.startDate.getMonth() + 1;
            int year = this.startDate.getYear();
            String strDate = String.valueOf(year) + "-";
            strDate = String.valueOf(strDate) + (month < 10 ? "0" + month + "-" : String.valueOf(month) + "-");
            strDate = String.valueOf(strDate) + (day < 10 ? "0" + day + "-" : Integer.valueOf(day));
            int day2 = this.endDate.getDay();
            int month2 = this.endDate.getMonth() + 1;
            int year2 = this.endDate.getYear();
            String enDate = String.valueOf(year2) + "-";
            enDate = String.valueOf(enDate) + (month2 < 10 ? "0" + month2 + "-" : String.valueOf(month2) + "-");
            enDate = String.valueOf(enDate) + (day2 < 10 ? "0" + day2 + "-" : Integer.valueOf(day2));
            String xml = new QueryHelper().createQueryXml(selectedMetric, selectedAxis, strDate, enDate, this.chkDateParam.getSelection());
            IConnection conn = null;
            try {
                try {
                    Properties connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
                    conn = new Driver().getConnection("");
                    conn.open(connProps);
                    design.setQueryText(xml);
                    this.updateDesign(design, conn, xml);
                }
                catch (OdaException e) {
                    design.setResultSets(null);
                    design.setParameters(null);
                    e.printStackTrace();
                    this.closeConnection(conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(conn);
                throw throwable;
            }
            this.closeConnection(conn);
        }
        return design;
    }

    private void updateDesign(DataSetDesign dataSetDesign, IConnection conn, String queryText) throws OdaException {
        IQuery query = conn.newQuery(null);
        query.prepare(queryText);
        try {
            IResultSetMetaData md = query.getMetaData();
            this.updateResultSetDesign(md, dataSetDesign);
        }
        catch (OdaException e) {
            dataSetDesign.setResultSets(null);
            e.printStackTrace();
        }
        try {
            IParameterMetaData paramMd = query.getParameterMetaData();
            this.updateParameterDesign(paramMd, dataSetDesign);
        }
        catch (OdaException ex) {
            dataSetDesign.setParameters(null);
            ex.printStackTrace();
        }
    }

    private void updateResultSetDesign(IResultSetMetaData md, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private void updateParameterDesign(IParameterMetaData paramMd, DataSetDesign dataSetDesign) throws OdaException {
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }
}

