/*
 * Decompiled with CFR 0.152.
 */
package bpm.fm.oda.driver.ui.impl;

import bpm.fm.oda.driver.Activator;
import bpm.fm.oda.driver.impl.Driver;
import bpm.fm.oda.driver.impl.QueryParser;
import bpm.freemetrics.api.manager.IManager;
import bpm.freemetrics.api.manager.client.FmClientAccessor;
import bpm.freemetrics.api.organisation.application.Application;
import bpm.freemetrics.api.organisation.metrics.Metric;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CustomDataSetWizardPage
extends DataSetWizardPage {
    private static String DEFAULT_MESSAGE = "Define the query text for the data set";
    private ComboViewer metrics;
    private ComboViewer applications;
    private Button dateAsParameter;
    private Text dateFormat;
    private FmClientAccessor fmClient;

    public CustomDataSetWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public CustomDataSetWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
    }

    private Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(composite, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Select an Application");
        this.applications = new ComboViewer(composite, 8);
        this.applications.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.applications.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Collection l = (Collection)inputElement;
                return l.toArray(new Object[l.size()]);
            }
        });
        this.applications.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Application)element).getName();
            }
        });
        this.applications.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)CustomDataSetWizardPage.this.applications.getSelection();
                Application m = (Application)ss.getFirstElement();
                CustomDataSetWizardPage.this.metrics.setInput((Object)CustomDataSetWizardPage.this.fmClient.getMetricsForApplication(m));
                CustomDataSetWizardPage.this.validateData();
            }
        });
        l = new Label(composite, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Select a Metric");
        this.metrics = new ComboViewer(composite, 8);
        this.metrics.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.metrics.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Collection l = (Collection)inputElement;
                return l.toArray(new Object[l.size()]);
            }
        });
        this.metrics.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Metric)element).getName();
            }
        });
        this.metrics.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CustomDataSetWizardPage.this.validateData();
            }
        });
        this.dateAsParameter = new Button(composite, 32);
        this.dateAsParameter.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.dateAsParameter.setText("Date As Parameter");
        this.dateAsParameter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomDataSetWizardPage.this.dateFormat.setEnabled(CustomDataSetWizardPage.this.dateAsParameter.getSelection());
            }
        });
        l = new Label(composite, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Date Format");
        this.dateFormat = new Text(composite, 2048);
        this.dateFormat.setLayoutData((Object)new GridData(4, 2, true, false));
        this.dateFormat.setText("yyyy-MM-dd");
        this.dateFormat.setEnabled(false);
        this.setPageComplete(false);
        return composite;
    }

    private void initFmWidgets() {
        try {
            Properties connProps = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
            String fmLogin = connProps.getProperty("fmLogin");
            String fmPass = connProps.getProperty("freemetricsPassword");
            this.fmClient = FmClientAccessor.getClient((IManager)Activator.getDefault().getFmManager(), (String)fmLogin, (String)fmPass, (String)connProps.getProperty("fmUrl"));
            try {
                int groupId = Integer.parseInt(connProps.getProperty("fmGroupId"));
                int themeId = Integer.parseInt(connProps.getProperty("fmThemeId"));
                this.fmClient.setGroupId(groupId);
                this.fmClient.setThemeId(themeId);
            }
            catch (Exception exception) {}
            this.applications.setInput((Object)this.fmClient.getApplications());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeControl() {
        this.initFmWidgets();
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null) {
            return;
        }
        String queryText = dataSetDesign.getQueryText();
        if (queryText == null || queryText.equals("")) {
            return;
        }
        try {
            QueryParser parser = new QueryParser(queryText);
            parser.parse();
            for (Application a : (List)this.applications.getInput()) {
                if (a.getId() != parser.getApplicationId()) continue;
                this.applications.setSelection((ISelection)new StructuredSelection((Object)a));
                break;
            }
            for (Metric m : (List)this.metrics.getInput()) {
                if (m.getId() != parser.getMetricId()) continue;
                this.metrics.setSelection((ISelection)new StructuredSelection((Object)m));
                break;
            }
            this.dateAsParameter.setSelection(parser.isDateParameter());
            this.dateFormat.setText(parser.getDateFormat());
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Query Parsing failed", (String)("The query cannot be parsed : " + queryText));
        }
        this.validateData();
        this.setMessage(DEFAULT_MESSAGE);
    }

    private String getQueryText() {
        IStructuredSelection ss = (IStructuredSelection)this.applications.getSelection();
        Application app = (Application)ss.getFirstElement();
        ss = (IStructuredSelection)this.metrics.getSelection();
        Metric met = (Metric)ss.getFirstElement();
        StringBuffer buf = new StringBuffer();
        buf.append("<queryAssoc>\n");
        buf.append("<fmApplicationId>" + app.getId() + "</fmApplicationId>\n");
        buf.append("<fmMetricId>" + met.getId() + "</fmMetricId>\n");
        buf.append("<dateAsParameter>" + this.dateAsParameter.getSelection() + "</dateAsParameter>\n");
        buf.append("<dateFormat>" + this.dateFormat.getText() + "</dateFormat>\n");
        buf.append("</queryAssoc>\n");
        return buf.toString();
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.getControl() == null) {
            return design;
        }
        if (!this.hasValidData()) {
            return null;
        }
        this.savePage(design);
        return design;
    }

    protected void collectResponseState() {
        super.collectResponseState();
    }

    protected boolean canLeave() {
        return this.isPageComplete();
    }

    private void validateData() {
        boolean isValid = !this.applications.getSelection().isEmpty() && !this.metrics.getSelection().isEmpty();
        this.setPageComplete(isValid);
    }

    private boolean hasValidData() {
        this.validateData();
        return this.canLeave();
    }

    private void savePage(DataSetDesign dataSetDesign) {
        block5: {
            String queryText = this.getQueryText();
            dataSetDesign.setQueryText(queryText);
            IConnection customConn = null;
            try {
                try {
                    Driver customDriver = new Driver();
                    customConn = customDriver.getConnection(null);
                    Properties connProps = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
                    customConn.open(connProps);
                    this.updateDesign(dataSetDesign, customConn, queryText);
                }
                catch (OdaException e) {
                    dataSetDesign.setResultSets(null);
                    dataSetDesign.setParameters(null);
                    e.printStackTrace();
                    this.closeConnection(customConn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(customConn);
                throw throwable;
            }
            this.closeConnection(customConn);
        }
    }

    private void updateDesign(DataSetDesign dataSetDesign, IConnection conn, String queryText) throws OdaException {
        IQuery query = conn.newQuery(null);
        query.prepare(queryText);
        try {
            IResultSetMetaData md = query.getMetaData();
            this.updateResultSetDesign(md, dataSetDesign);
        }
        catch (OdaException e) {
            dataSetDesign.setResultSets(null);
            e.printStackTrace();
        }
        try {
            IParameterMetaData paramMd = query.getParameterMetaData();
            this.updateParameterDesign(paramMd, dataSetDesign);
        }
        catch (OdaException ex) {
            dataSetDesign.setParameters(null);
            ex.printStackTrace();
        }
    }

    private void updateResultSetDesign(IResultSetMetaData md, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private void updateParameterDesign(IParameterMetaData paramMd, DataSetDesign dataSetDesign) throws OdaException {
        ParameterDefinition paramDef;
        DataSetParameters paramDesign = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)paramMd, (ParameterMode)DesignSessionUtil.toParameterModeDesign((int)1));
        dataSetDesign.setParameters(paramDesign);
        if (paramDesign == null) {
            return;
        }
        paramDesign.setDerivedMetaData(true);
        if (paramDesign.getParameterDefinitions().size() > 0 && (paramDef = (ParameterDefinition)paramDesign.getParameterDefinitions().get(0)) != null) {
            paramDef.setDefaultScalarValue("dummy default value");
        }
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }
}

