/*
 * Decompiled with CFR 0.152.
 */
package bpm.studio.jdbc.management.ui.dialogs;

import bpm.studio.jdbc.management.config.IConstants;
import bpm.studio.jdbc.management.model.DriverInfo;
import bpm.studio.jdbc.management.model.ListDriver;
import bpm.studio.jdbc.management.util.JarClassFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DialogDriverInfo
extends Dialog {
    private Text name;
    private Text driverFile;
    private Text urlPrefix;
    private ComboViewer driverClass;
    private DriverInfo driverInfo;

    public DialogDriverInfo(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayoutData((Object)new GridData(1808));
        main.setLayout((Layout)new GridLayout(3, false));
        Label l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Driver Name");
        this.name = new Text(main, 2048);
        this.name.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DialogDriverInfo.this.check();
            }
        });
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Jdbc Jar File");
        this.driverFile = new Text(main, 2048);
        this.driverFile.setLayoutData((Object)new GridData(4, 2, true, false));
        this.driverFile.setEnabled(false);
        Button b = new Button(main, 8);
        b.setLayoutData((Object)new GridData(3, 2, false, false));
        b.setText("...");
        b.setToolTipText("Select a File");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block6: {
                    FileDialog fd = new FileDialog(DialogDriverInfo.this.getShell(), 4096);
                    fd.setFilterExtensions(new String[]{"*.jar"});
                    fd.setFilterPath(Platform.getInstallLocation().getURL().getFile());
                    String filePath = fd.open().replace("\\", "/").replace("//", "/");
                    String shortFileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
                    if (!filePath.startsWith(IConstants.getJdbcJarFolder().replace("//", "/")) && !("/" + filePath).startsWith(IConstants.getJdbcJarFolder().replace("\\", "/").replace("//", "/"))) {
                        try {
                            int l;
                            FileInputStream fis = new FileInputStream(filePath);
                            FileOutputStream fos = new FileOutputStream(String.valueOf(IConstants.getJdbcJarFolder()) + "/" + shortFileName);
                            byte[] buf = new byte[1024];
                            while ((l = fis.read(buf)) > 0) {
                                fos.write(buf, 0, l);
                            }
                            fos.close();
                            fis.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    DialogDriverInfo.this.driverFile.setText(shortFileName);
                    try {
                        DialogDriverInfo.this.driverClass.setInput((Object)JarClassFinder.getClassImplementingJdbcDriver((String)filePath));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        MessageDialog.openError((Shell)DialogDriverInfo.this.getShell(), (String)"Problem", (String)("Unable to analyze Jar file : " + ex.getMessage()));
                        DialogDriverInfo.this.driverClass.setInput(new ArrayList());
                        if (filePath.startsWith(IConstants.getJdbcJarFolder())) break block6;
                        new File(filePath).delete();
                    }
                }
                DialogDriverInfo.this.check();
            }
        });
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Driver class");
        this.driverClass = new ComboViewer(main, 8);
        this.driverClass.getControl().setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.driverClass.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Collection c = (Collection)inputElement;
                return c.toArray(new Object[c.size()]);
            }
        });
        this.driverClass.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Class c = (Class)element;
                return c.getName();
            }
        });
        this.driverClass.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DialogDriverInfo.this.check();
            }
        });
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Url prefix");
        this.urlPrefix = new Text(main, 2048);
        this.urlPrefix.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.urlPrefix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DialogDriverInfo.this.check();
            }
        });
        return main;
    }

    protected void initializeBounds() {
        this.getShell().setText("Jdbc Driver Info");
        this.getShell().setSize(600, 400);
    }

    private void check() {
        boolean valid = true;
        if ("".equals(this.name.getText().trim())) {
            valid = false;
        }
        try {
            if (this.driverInfo != null && ListDriver.getInstance((String)(String.valueOf(Platform.getInstallLocation().getURL().getFile()) + "/resources/driverjdbc.xml")).getInfo(this.name.getText()) != null) {
                valid = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if ("".equals(this.urlPrefix.getText().trim())) {
            valid = false;
        }
        if (this.driverClass.getSelection().isEmpty()) {
            valid = false;
        }
        this.getButton(0).setEnabled(valid);
    }

    protected void okPressed() {
        if (this.driverInfo == null) {
            this.driverInfo = new DriverInfo();
        }
        this.driverInfo.setClassName(((Class)((IStructuredSelection)this.driverClass.getSelection()).getFirstElement()).getName());
        this.driverInfo.setFile(this.driverFile.getText());
        this.driverInfo.setName(this.name.getText());
        this.driverInfo.setUrlPrefix(this.urlPrefix.getText());
        super.okPressed();
    }

    public DriverInfo getDriverInfo() {
        return this.driverInfo;
    }

    public String getFilePath() {
        return null;
    }
}

