/*
 * Decompiled with CFR 0.152.
 */
package bpm.studio.jdbc.management.ui;

import bpm.studio.jdbc.management.config.IConstants;
import bpm.studio.jdbc.management.model.DriverInfo;
import bpm.studio.jdbc.management.model.ListDriver;
import bpm.studio.jdbc.management.ui.dialogs.DialogDriverInfo;
import java.util.Collection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JdbcDriverRegistrationPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer viewer;
    private Button add;
    private Button del;

    public JdbcDriverRegistrationPage() {
    }

    public JdbcDriverRegistrationPage(String title) {
        super(title);
    }

    public JdbcDriverRegistrationPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        main.setLayoutData((Object)new GridData(1808));
        this.add = new Button(main, 8);
        this.add.setLayoutData((Object)new GridData(4, 2, true, false));
        this.add.setText("Add jdbc driver");
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverInfo info;
                DialogDriverInfo dial = new DialogDriverInfo(JdbcDriverRegistrationPage.this.getShell());
                if (dial.open() == 0 && (info = dial.getDriverInfo()) != null) {
                    try {
                        ListDriver.getInstance((String)IConstants.getJdbcDriverXmlFile()).addDriver(info, true);
                        JdbcDriverRegistrationPage.this.viewer.refresh();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.del = new Button(main, 8);
        this.del.setLayoutData((Object)new GridData(4, 2, true, false));
        this.del.setText("Remove jdbc driver");
        this.del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)JdbcDriverRegistrationPage.this.viewer.getSelection();
                if (ss.isEmpty()) {
                    return;
                }
                try {
                    ListDriver.getInstance((String)IConstants.getJdbcDriverXmlFile()).removeDriver((DriverInfo)ss.getFirstElement());
                    JdbcDriverRegistrationPage.this.viewer.refresh();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.viewer = new TableViewer(main, 2560);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Collection c = (Collection)inputElement;
                return c.toArray(new Object[c.size()]);
            }
        });
        TableViewerColumn col = new TableViewerColumn(this.viewer, 16384);
        col.getColumn().setText("Driver Name");
        col.getColumn().setWidth(200);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((DriverInfo)element).getName();
            }
        });
        col = new TableViewerColumn(this.viewer, 16384);
        col.getColumn().setText("Driver Class");
        col.getColumn().setWidth(200);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((DriverInfo)element).getClassName();
            }
        });
        col = new TableViewerColumn(this.viewer, 16384);
        col.getColumn().setText("Jdbc Jar File");
        col.getColumn().setWidth(200);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((DriverInfo)element).getFile();
            }
        });
        try {
            this.viewer.setInput((Object)ListDriver.getInstance((String)IConstants.getJdbcDriverXmlFile()).getDriversInfo());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Problem", (String)("Error when getting the registered drivers : " + ex.getMessage()));
        }
        return main;
    }

    public void init(IWorkbench workbench) {
    }
}

