/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.services;

import bpm.gateway.core.server.database.DBColumn;
import bpm.gateway.core.server.database.DBSchema;
import bpm.gateway.core.server.database.DBTable;
import bpm.gateway.core.server.database.DataBaseConnection;
import bpm.gateway.core.server.database.dwhview.DwhDbConnection;
import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.Table;
import bpm.sqldesigner.query.services.AbstractDatabaseService;
import java.util.ArrayList;
import java.util.List;

public class DwhDatabaseService
extends AbstractDatabaseService {
    public DwhDatabaseService(DwhDbConnection dbc) {
        super((DataBaseConnection)dbc);
    }

    private DwhDbConnection getDwhConnection() {
        return (DwhDbConnection)this.dbc;
    }

    @Override
    public List<Column> extractColumns(String tableName) {
        ArrayList<Column> cols = new ArrayList<Column>();
        DBSchema sch = this.getDwhConnection().getSchema();
        for (DBTable t : sch.getTables()) {
            if (!tableName.equals(t.getName())) continue;
            for (DBColumn col : t.getDataColumns()) {
                Column c = new Column();
                c.setName(col.getName());
                c.setType(col.getType());
                c.setKey(col.isPrimaryKey());
                cols.add(c);
            }
        }
        return cols;
    }

    @Override
    public List<Table> extractTables() {
        ArrayList<Table> tables = new ArrayList<Table>();
        DBSchema sch = this.getDwhConnection().getSchema();
        for (DBTable t : sch.getTables()) {
            Table tb = new Table();
            if (sch.isNoSchema()) {
                tb.setName(t.getName());
            } else {
                tb.setName(String.valueOf(sch.getName()) + "." + t.getName());
            }
            tables.add(tb);
        }
        return tables;
    }
}

