/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.services;

import bpm.gateway.core.DocumentGateway;
import bpm.gateway.core.exception.ServerException;
import bpm.gateway.core.server.database.DataBaseConnection;
import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.Table;
import bpm.sqldesigner.query.services.AbstractDatabaseService;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DatabaseServices
extends AbstractDatabaseService {
    public DatabaseServices(DataBaseConnection dbc) {
        super(dbc);
    }

    public DatabaseServices(String host, String port, String login, String password, String dataBaseName, String driverName, String driversPath, String driversXMLFile) {
        super(host, port, login, password, dataBaseName, driverName, driversPath, driversXMLFile);
    }

    @Override
    public DataBaseConnection connect(DocumentGateway document) throws ServerException {
        if (!this.dbc.isOpened()) {
            this.dbc.connect(document);
        }
        return this.dbc;
    }

    @Override
    public List<Table> extractTables() {
        ArrayList<Table> tables = new ArrayList<Table>();
        if (this.isConnected()) {
            ResultSet resultSet = null;
            try {
                try {
                    DatabaseMetaData md = this.dbc.getSocket(null).getMetaData();
                    resultSet = md.getTables(null, null, "%", new String[]{"TABLE", "VIEW", "ALIAS"});
                    while (resultSet.next()) {
                        Table table = new Table();
                        String shName = resultSet.getString("TABLE_SCHEM");
                        if (shName != null && !"".equals(shName)) {
                            table.setName(String.valueOf(shName) + "." + resultSet.getString(3));
                        } else {
                            table.setName(resultSet.getString(3));
                        }
                        tables.add(table);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        resultSet.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            tables = null;
        }
        return tables;
    }

    @Override
    public List<Column> extractColumns(String tableName) {
        ArrayList<Column> columns = new ArrayList<Column>();
        String schName = null;
        String tName = null;
        if (tableName.contains(".")) {
            String[] s = tableName.split("\\.");
            schName = s[0];
            tName = s[1];
        } else {
            tName = tableName;
        }
        if (this.isConnected()) {
            ResultSet resultSet = null;
            try {
                try {
                    DatabaseMetaData md = this.dbc.getSocket(null).getMetaData();
                    resultSet = md.getColumns(null, schName, tName, "%");
                    while (resultSet.next()) {
                        Column column = new Column();
                        String name = resultSet.getString(4);
                        column.setName(name);
                        column.setType(resultSet.getString(6));
                        columns.add(column);
                    }
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    try {
                        resultSet.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            columns = null;
        }
        return columns;
    }
}

